/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.GatewayServiceLocator;
import org.josso.gateway.WebserviceClientAuthentication;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.identity.service.WebserviceSSOIdentityManager;
import org.josso.gateway.identity.service.WebserviceSSOIdentityProvider;
import org.josso.gateway.session.service.SSOSessionManagerService;
import org.josso.gateway.session.service.WebserviceSSOSessionManager;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityManager;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityManagerWSLocator;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProvider;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProviderWSLocator;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManager;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManagerWSLocator;

public class WebserviceGatewayServiceLocator
extends GatewayServiceLocator {
    private static final Log logger = LogFactory.getLog(WebserviceGatewayServiceLocator.class);
    private static final String TRANSPORT_SECURITY_NONE = "none";
    private static final String TRANSPORT_SECURITY_CONFIDENTIAL = "confidential";
    private String _endpoint;
    private String _username;
    private String _transportSecurity = "none";
    private String _servicesWebContext;
    private String _sessionManagerServicePath;
    private String _identityManagerServicePath;
    private String _identityProviderServicePath;

    public SSOSessionManagerService getSSOSessionManager() throws Exception {
        SSOSessionManagerWSLocator ssoManagerServiceLocator = new SSOSessionManagerWSLocator();
        String smEndpoint = this.getSSOSessionManagerEndpoint();
        logger.debug((Object)("Using SSOSessionManager endpoint '" + smEndpoint + "'"));
        ssoManagerServiceLocator.setSSOSessionManagerSoapEndpointAddress(smEndpoint);
        SSOSessionManager ssoSessionManagerWebservice = ssoManagerServiceLocator.getSSOSessionManagerSoap();
        WebserviceSSOSessionManager wsm = new WebserviceSSOSessionManager(ssoSessionManagerWebservice);
        return wsm;
    }

    public SSOIdentityManagerService getSSOIdentityManager() throws Exception {
        SSOIdentityManagerWSLocator ssoIdentityManagerServiceLocator = new SSOIdentityManagerWSLocator();
        String imEndpoint = this.getSSOIdentityManagerEndpoint();
        logger.debug((Object)("Using SSOIdentityManager endpoint '" + imEndpoint + "'"));
        ssoIdentityManagerServiceLocator.setSSOIdentityManagerSoapEndpointAddress(imEndpoint);
        SSOIdentityManager ssoIdentityManagerWebservice = ssoIdentityManagerServiceLocator.getSSOIdentityManagerSoap();
        WebserviceSSOIdentityManager wim = new WebserviceSSOIdentityManager(ssoIdentityManagerWebservice);
        return wim;
    }

    public SSOIdentityProviderService getSSOIdentityProvider() throws Exception {
        SSOIdentityProviderWSLocator ssoIdentityProviderServiceLocator = new SSOIdentityProviderWSLocator();
        String ipEndpoint = this.getSSOIdentityProviderEndpoint();
        logger.debug((Object)("Using SSOIdentityProvider endpoint '" + ipEndpoint + "'"));
        ssoIdentityProviderServiceLocator.setSSOIdentityProviderSoapEndpointAddress(ipEndpoint);
        SSOIdentityProvider ssoIdentityProviderWebservice = ssoIdentityProviderServiceLocator.getSSOIdentityProviderSoap();
        WebserviceSSOIdentityProvider wip = new WebserviceSSOIdentityProvider(ssoIdentityProviderWebservice);
        return wip;
    }

    public String getEndpointBase() {
        return (this._transportSecurity.equalsIgnoreCase(TRANSPORT_SECURITY_CONFIDENTIAL) ? "https" : "http") + "://" + this._endpoint + "/";
    }

    public String getSSOSessionManagerEndpoint() {
        if (this._sessionManagerServicePath != null) {
            return this.getEndpointBase() + this._sessionManagerServicePath;
        }
        return this.getEndpointBase() + (this._servicesWebContext != null ? this._servicesWebContext : "josso") + "/services/SSOSessionManagerSoap";
    }

    public String getSSOIdentityManagerEndpoint() {
        if (this._identityManagerServicePath != null) {
            return this.getEndpointBase() + this._identityManagerServicePath;
        }
        return this.getEndpointBase() + (this._servicesWebContext != null ? this._servicesWebContext : "josso") + "/services/SSOIdentityManagerSoap";
    }

    public String getSSOIdentityProviderEndpoint() {
        if (this._identityProviderServicePath != null) {
            return this.getEndpointBase() + this._identityProviderServicePath;
        }
        return this.getEndpointBase() + (this._servicesWebContext != null ? this._servicesWebContext : "josso") + "/services/SSOIdentityProviderSoap";
    }

    public void setEndpoint(String endpoint) {
        this._endpoint = endpoint;
    }

    public String getEndpoint() {
        return this._endpoint;
    }

    public void setServicesWebContext(String servicesWebContext) {
        this._servicesWebContext = servicesWebContext;
    }

    public String getServicesWebContext() {
        return this._servicesWebContext;
    }

    public void setUsername(String username) {
        WebserviceClientAuthentication.setUsername(username);
        this._username = username;
    }

    public String getUsername() {
        return this._username;
    }

    public void setPassword(String password) {
        WebserviceClientAuthentication.setPassword(password);
    }

    public String getPassword() {
        return "*";
    }

    public void setTransportSecurity(String transportSecurity) {
        this._transportSecurity = transportSecurity;
    }

    public String getTransportSecurity() {
        return this._transportSecurity;
    }

    public String getSessionManagerServicePath() {
        return this._sessionManagerServicePath;
    }

    public void setSessionManagerServicePath(String sessionManagerServicePath) {
        this._sessionManagerServicePath = sessionManagerServicePath;
    }

    public String getIdentityManagerServicePath() {
        return this._identityManagerServicePath;
    }

    public void setIdentityManagerServicePath(String identityManagerServicePath) {
        this._identityManagerServicePath = identityManagerServicePath;
    }

    public String getIdentityProviderServicePath() {
        return this._identityProviderServicePath;
    }

    public void setIdentityProviderServicePath(String identityProviderServicePath) {
        this._identityProviderServicePath = identityProviderServicePath;
    }
}

