/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jetty;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.ServletContainerVisitor;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.jetty.Jetty8WebAppContext;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.session.SessionTask;
import org.gatein.wci.session.SessionTaskVisitor;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;

public class Jetty8ServletContainerContext
implements ServletContainerContext,
Container.Listener,
LifeCycle.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(Jetty8ServletContainerContext.class);
    private final Container container;
    private final CommandDispatcher dispatcher = new CommandDispatcher("/jetty8gateinservlet");
    private boolean crossContextLogout = true;
    private ServletContainerContext.Registration registration;
    private final Map<String, String> manualMonitoredContexts = new HashMap<String, String>();
    private final Set<String> monitoredContexts = new HashSet<String>();
    private final String containerInfo = "Jetty " + Server.getVersion();

    public Jetty8ServletContainerContext(Server server) {
        this.container = server.getContainer();
    }

    public void start() {
        ServletContainerFactory.registerContext((ServletContainerContext)this);
        this.container.addEventListener((Container.Listener)this);
    }

    public void stop() {
        this.container.removeEventListener((Container.Listener)this);
        if (this.registration != null) {
            this.registration.cancel();
            this.registration = null;
        }
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        if (this.manualMonitoredContexts.containsKey(targetServletContext.getServletContextName())) {
            String customPath = this.manualMonitoredContexts.get(targetServletContext.getServletContextName());
            return new CommandDispatcher(customPath).include(targetServletContext, request, response, callback, handback);
        }
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials) throws AuthenticationException, ServletException, IOException {
        try {
            this._login((Request)request, (Response)response, credentials);
        }
        catch (ServletException se) {
            throw new AuthenticationException((Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _login(Request req, Response resp, Credentials credentials) throws ServletException {
        HttpSession session = req.getSession();
        if (session.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                if (session.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
                    req.login(credentials.getUsername(), credentials.getPassword());
                    session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)req.getAuthentication());
                }
            }
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HttpSession sess = request.getSession(false);
        request.logout();
        if (sess == null) {
            return;
        }
        if (!this.crossContextLogout) {
            return;
        }
        String sessId = sess.getId();
        ServletContainerFactory.getServletContainer().visit((ServletContainerVisitor)new SessionTaskVisitor(sessId, new SessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean executeTask(HttpSession session) {
                ClassLoader portalContainerCL = Thread.currentThread().getContextClassLoader();
                ClassLoader webAppCL = session.getServletContext().getClassLoader();
                Thread.currentThread().setContextClassLoader(webAppCL);
                try {
                    session.invalidate();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(portalContainerCL);
                }
                return true;
            }
        }));
    }

    public String getContainerInfo() {
        return this.containerInfo;
    }

    public void addBean(Object o) {
        if (o instanceof org.eclipse.jetty.webapp.WebAppContext) {
            this.registerWebAppContext((org.eclipse.jetty.webapp.WebAppContext)o);
        }
    }

    private void registerWebAppContext(org.eclipse.jetty.webapp.WebAppContext ctx) {
        if (!this.monitoredContexts.contains(ctx.getServletContext().getServletContextName())) {
            LOG.debug((Object)("Register lifecycle listener on webapp " + ctx.getContextPath()));
            ctx.addLifeCycleListener((LifeCycle.Listener)this);
            if (ctx.isStarted()) {
                this.startWebAppContext(ctx);
            }
            this.monitoredContexts.add(ctx.getServletContext().getServletContextName());
        }
    }

    public void removeBean(Object o) {
        if (o instanceof org.eclipse.jetty.webapp.WebAppContext) {
            this.unregisterWebAppContext((org.eclipse.jetty.webapp.WebAppContext)o);
        }
    }

    private void unregisterWebAppContext(org.eclipse.jetty.webapp.WebAppContext ctx) {
        if (this.monitoredContexts.contains(ctx.getServletContext().getServletContextName())) {
            this.monitoredContexts.remove(ctx.getServletContext().getServletContextName());
            if (!ctx.isStopped()) {
                this.stopWebAppContext(ctx);
            }
            LOG.debug((Object)("Unregister lifecycle listener on webapp " + ctx.getContextPath()));
            ctx.removeLifeCycleListener((LifeCycle.Listener)this);
        }
    }

    public void add(Container.Relationship relationship) {
        this.addBean(relationship.getChild());
    }

    public void remove(Container.Relationship relationship) {
        this.removeBean(relationship.getChild());
    }

    public void lifeCycleStarting(LifeCycle lifeCycle) {
    }

    public void lifeCycleStarted(LifeCycle lifeCycle) {
        this.startWebAppContext((org.eclipse.jetty.webapp.WebAppContext)lifeCycle);
    }

    private void startWebAppContext(org.eclipse.jetty.webapp.WebAppContext ctx) {
        try {
            if (!ServletContainer.isDisabledNativeRegistration((ServletContext)ctx.getServletContext())) {
                Jetty8WebAppContext jetty8Ctx = new Jetty8WebAppContext((ServletContextHandler)ctx);
                if (this.registration != null) {
                    this.registration.registerWebApp((WebAppContext)jetty8Ctx);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to register webapp " + ctx.getContextPath()), (Throwable)ex);
        }
    }

    public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
    }

    public void lifeCycleStopping(LifeCycle lifeCycle) {
    }

    public void lifeCycleStopped(LifeCycle lifeCycle) {
        this.stopWebAppContext((org.eclipse.jetty.webapp.WebAppContext)lifeCycle);
    }

    private void stopWebAppContext(org.eclipse.jetty.webapp.WebAppContext ctx) {
        try {
            if (!ServletContainer.isDisabledNativeRegistration((ServletContext)ctx.getServletContext()) && this.registration != null) {
                this.registration.unregisterWebApp(ctx.getContextPath());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to unregister webapp " + ctx.getContextPath()), (Throwable)ex);
        }
    }
}

