/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.crosscontext;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.test.WebAppRegistry;

public class CrossContextServlet
extends HttpServlet {
    static int status = 0;
    private ServletContainer container;
    private WebAppRegistry registry;

    public void init() throws ServletException {
        this.container = ServletContainerFactory.getServletContainer();
        this.registry = new WebAppRegistry();
        this.container.addWebAppListener((WebAppListener)this.registry);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebApp app = this.registry.getWebApp("/crosscontextapp");
        if (app == null) {
            throw new ServletException("Could not find the app to dispatch to");
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            throw new ServletException("Was not expecting a session to exist");
        }
        this.container.login(req, resp, new Credentials("foo", "bar"));
        session = req.getSession();
        String id = session.getId();
        String dispatchedId = (String)this.container.include(app.getServletContext(), req, resp, new RequestDispatchCallback(){

            public Object doCallback(ServletContext dispatchedCtx, HttpServletRequest dispatchedReq, HttpServletResponse dispatchedResp, Object handback) throws ServletException, IOException {
                if (dispatchedReq.getSession(false) != null) {
                    throw new ServletException("Was not expecting a session to exist");
                }
                HttpSession dispatchedSession = dispatchedReq.getSession();
                dispatchedSession.setAttribute("payload", (Object)"foo");
                return dispatchedSession.getId();
            }
        }, null);
        if (!id.equals(dispatchedId)) {
            throw new ServletException("Was expecting session ids to be the same");
        }
        String payload = (String)this.container.include(app.getServletContext(), req, resp, new RequestDispatchCallback(){

            public Object doCallback(ServletContext dispatchedCtx, HttpServletRequest dispatchedReq, HttpServletResponse dispatchedResp, Object handback) throws ServletException, IOException {
                HttpSession dispatchedSession = dispatchedReq.getSession();
                return dispatchedSession.getAttribute("payload");
            }
        }, null);
        if (!"foo".equals(payload)) {
            throw new ServletException("Was expecting a foo payload instead of " + payload);
        }
        this.container.logout(req, resp);
        payload = (String)this.container.include(app.getServletContext(), req, resp, new RequestDispatchCallback(){

            public Object doCallback(ServletContext dispatchedCtx, HttpServletRequest dispatchedReq, HttpServletResponse dispatchedResp, Object handback) throws ServletException, IOException {
                HttpSession dispatchedSession = dispatchedReq.getSession();
                return dispatchedSession.getAttribute("payload");
            }
        }, null);
        if (payload != null) {
            throw new ServletException("Was expecting a null payload instead of " + payload);
        }
        resp.setStatus(200);
    }

    public void destroy() {
        if (this.registry != null && this.container != null) {
            this.container.removeWebAppListener((WebAppListener)this.registry);
        }
    }
}

