/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;

public class GateInServletRegistrations {
    private static final Map<String, WebAppContext> pendingContexts = Collections.synchronizedMap(new LinkedHashMap(16, 0.5f, false));
    private static Map<ServletContext, String> requestDispatchMap = new ConcurrentHashMap<ServletContext, String>();
    private static ServletContainerContext servletContainerContext;

    public static void register(WebAppContext webAppContext, String dispatcherPath) {
        requestDispatchMap.put(webAppContext.getServletContext(), dispatcherPath);
        if (servletContainerContext != null) {
            servletContainerContext.registerWebApp(webAppContext, dispatcherPath);
        } else {
            pendingContexts.put(webAppContext.getContextPath(), webAppContext);
        }
    }

    public static void unregister(ServletContext servletContext) {
        requestDispatchMap.remove(servletContext);
        String contextPath = servletContext.getContextPath();
        if (servletContainerContext != null) {
            servletContainerContext.unregisterWebApp(servletContext);
        }
        pendingContexts.remove(contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServletContainerContext(ServletContainerContext context) {
        ArrayList<WebAppContext> pendingCtxs;
        servletContainerContext = context;
        Map<String, WebAppContext> map = pendingContexts;
        synchronized (map) {
            pendingCtxs = new ArrayList<WebAppContext>(pendingContexts.values());
        }
        for (WebAppContext webAppContext : pendingCtxs) {
            String dispatcherPath = requestDispatchMap.get(webAppContext.getServletContext());
            servletContainerContext.registerWebApp(webAppContext, dispatcherPath);
        }
    }
}

