/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.impl.generic;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.api.GateInServletRegistrations;
import org.gatein.wci.authentication.GenericAuthentication;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;

public class GenericServletContainerContext
implements ServletContainerContext,
ServletContextListener {
    private static GenericServletContainerContext instance;
    private static HashMap<ServletContext, String> requestDispatchMap;
    private GenericAuthentication authentication = new GenericAuthentication();
    private ServletContainerContext.Registration registration;

    public static GenericServletContainerContext getInstance() {
        return instance;
    }

    @Override
    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        String dispatcherPath = requestDispatchMap.get(targetServletContext);
        CommandDispatcher dispatcher = new CommandDispatcher(dispatcherPath);
        return dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    @Override
    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
        GateInServletRegistrations.setServletContainerContext(this);
    }

    @Override
    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    @Override
    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials, long validityMillis) throws IOException {
        this.authentication.login(credentials, request, response, validityMillis);
    }

    @Override
    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials, long validityMillis, String initialURI) throws IOException {
        this.authentication.login(credentials, request, response, validityMillis, initialURI);
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.authentication.logout(request, response);
    }

    @Override
    public String getContainerInfo() {
        return "Generic";
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (instance != null) {
            throw new IllegalStateException("Shared instance singleton already created");
        }
        instance = this;
        DefaultServletContainerFactory.registerContext(this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    @Override
    public void registerWebApp(WebAppContext webappContext, String dispatcherPath) {
        requestDispatchMap.put(webappContext.getServletContext(), dispatcherPath);
        GenericServletContainerContext.instance.registration.registerWebApp(webappContext);
    }

    @Override
    public void unregisterWebApp(ServletContext servletContext) {
        requestDispatchMap.remove(servletContext);
        GenericServletContainerContext.instance.registration.unregisterWebApp(servletContext.getContextPath());
    }

    static {
        requestDispatchMap = new HashMap();
    }
}

