/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.support;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.gatein.common.util.Tools;

public class MockHttpSession
implements InvocationHandler,
Serializable {
    private final Map map = new HashMap();

    private MockHttpSession() {
    }

    public static HttpSession createMockSession() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return (HttpSession)Proxy.newProxyInstance(loader, new Class[]{HttpSession.class}, (InvocationHandler)new MockHttpSession());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("setAttribute".equals(methodName)) {
            this.map.put(args[0], args[1]);
            return null;
        }
        if ("removeAttribute".equals(methodName)) {
            this.map.remove(args[0]);
            return null;
        }
        if ("getAttribute".equals(methodName)) {
            return this.map.get(args[0]);
        }
        if ("getAttributeNames".equals(methodName)) {
            return Tools.toEnumeration(this.map.keySet().iterator());
        }
        if ("toString".equals(methodName)) {
            return "MockHttpSession";
        }
        if ("getId".equals(methodName)) {
            return "SESSION_ID";
        }
        throw new UnsupportedOperationException("MockHttpSession does not support: " + method);
    }
}

