/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.xml.namespace.QName;
import org.gatein.common.RuntimeContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.wsrp.WSRPUtils;

public final class WSRPConstants {
    public static final boolean RUNS_IN_EPP = RuntimeContext.getInstance().isRunningIn(RuntimeContext.RunningEnvironment.epp);
    public static final String WSRP_SERVICE_VERSION;
    public static final String NORMAL_WINDOW_STATE = "wsrp:normal";
    public static final String MINIMIZED_WINDOW_STATE = "wsrp:minimized";
    public static final String MAXIMIZED_WINDOW_STATE = "wsrp:maximized";
    public static final String SOLO_WINDOW_STATE = "wsrp:solo";
    public static final String VIEW_MODE = "wsrp:view";
    public static final String EDIT_MODE = "wsrp:edit";
    public static final String HELP_MODE = "wsrp:help";
    public static final String PREVIEW_MODE = "wsrp:preview";
    public static final String NONE_USER_AUTHENTICATION = "wsrp:none";
    public static final String PASSWORD_USER_AUTHENTICATION = "wsrp:password";
    public static final String CERTIFICATE_USER_AUTHENTICATION = "wsrp:certificate";
    public static final String DEFAULT_CHARACTER_SET = "UTF-8";
    public static final String DEFAULT_CONSUMER_NAME;
    public static final String CONSUMER_AGENT;
    public static final String CACHE_PER_USER = "wsrp:perUser";
    public static final String CACHE_FOR_ALL = "wsrp:forAll";
    public static final int SESSION_NEVER_EXPIRES = -1;
    public static final QName XSD_STRING;
    public static final QName XSD_INTEGER;
    public static final QName XSD_INT;
    public static final QName XSD_LONG;
    public static final QName XSD_SHORT;
    public static final QName XSD_DECIMAL;
    public static final QName XSD_FLOAT;
    public static final QName XSD_DOUBLE;
    public static final QName XSD_BOOLEAN;
    public static final QName XSD_BYTE;
    public static final QName XSD_DATE_TIME;
    public static final QName XSD_BASE_64_BINARY;
    public static final QName XSD_HEX_BINARY;
    public static final QName XSD_UNSIGNED_INT;
    public static final QName XSD_UNSIGNED_SHORT;
    public static final QName XSD_TIME;
    public static final QName XSD_DATE;
    public static final QName XSD_ANY_SIMPLE_TYPE;
    public static String DEFAULT_LOCALE;

    private WSRPConstants() {
    }

    public static List<String> getDefaultLocales() {
        ArrayList<String> locales = new ArrayList<String>(2);
        locales.add(DEFAULT_LOCALE);
        locales.add("en");
        return locales;
    }

    public static List<String> getDefaultMimeTypes() {
        return Collections.singletonList("text/html");
    }

    static {
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("wsrp.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load wsrp.properties.");
        }
        WSRP_SERVICE_VERSION = props.getProperty("wsrp.service.version");
        CONSUMER_AGENT = PortalContext.VERSION.getName() + "." + PortalContext.VERSION.getMajor() + "." + PortalContext.VERSION.getMinor() + "." + PortalContext.VERSION.getQualifier();
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (localhost != null) {
            DEFAULT_CONSUMER_NAME = localhost.getCanonicalHostName();
        } else {
            Random random = new Random(System.currentTimeMillis());
            DEFAULT_CONSUMER_NAME = CONSUMER_AGENT + " Unconfigured " + random.nextInt();
        }
        XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
        XSD_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "integer");
        XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int");
        XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long");
        XSD_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "short");
        XSD_DECIMAL = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
        XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float");
        XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double");
        XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
        XSD_BYTE = new QName("http://www.w3.org/2001/XMLSchema", "byte");
        XSD_DATE_TIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
        XSD_BASE_64_BINARY = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
        XSD_HEX_BINARY = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");
        XSD_UNSIGNED_INT = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
        XSD_UNSIGNED_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort");
        XSD_TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
        XSD_DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");
        XSD_ANY_SIMPLE_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType");
        DEFAULT_LOCALE = WSRPUtils.toString(Locale.getDefault());
    }
}

