/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.spec.v1;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.StateString;
import org.gatein.pc.portlet.impl.jsr168.PortletUtils;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.spec.v2.ErrorCodes;
import org.oasis.wsrp.v1.V1CacheControl;
import org.oasis.wsrp.v1.V1ClientData;
import org.oasis.wsrp.v1.V1ClonePortlet;
import org.oasis.wsrp.v1.V1Contact;
import org.oasis.wsrp.v1.V1CookieProtocol;
import org.oasis.wsrp.v1.V1DestroyFailed;
import org.oasis.wsrp.v1.V1DestroyPortlets;
import org.oasis.wsrp.v1.V1EmployerInfo;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1GetPortletDescription;
import org.oasis.wsrp.v1.V1GetPortletProperties;
import org.oasis.wsrp.v1.V1GetPortletPropertyDescription;
import org.oasis.wsrp.v1.V1GetServiceDescription;
import org.oasis.wsrp.v1.V1InitCookie;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1ItemDescription;
import org.oasis.wsrp.v1.V1LocalizedString;
import org.oasis.wsrp.v1.V1MarkupContext;
import org.oasis.wsrp.v1.V1MarkupParams;
import org.oasis.wsrp.v1.V1MarkupType;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1ModelTypes;
import org.oasis.wsrp.v1.V1ModifyRegistration;
import org.oasis.wsrp.v1.V1NamedString;
import org.oasis.wsrp.v1.V1Online;
import org.oasis.wsrp.v1.V1PerformBlockingInteraction;
import org.oasis.wsrp.v1.V1PersonName;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1Postal;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1PropertyList;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RegistrationData;
import org.oasis.wsrp.v1.V1ReleaseSessions;
import org.oasis.wsrp.v1.V1ResetProperty;
import org.oasis.wsrp.v1.V1Resource;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.V1ResourceValue;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1SessionContext;
import org.oasis.wsrp.v1.V1SetPortletProperties;
import org.oasis.wsrp.v1.V1StateChange;
import org.oasis.wsrp.v1.V1Telecom;
import org.oasis.wsrp.v1.V1TelephoneNum;
import org.oasis.wsrp.v1.V1Templates;
import org.oasis.wsrp.v1.V1UpdateResponse;
import org.oasis.wsrp.v1.V1UploadContext;
import org.oasis.wsrp.v1.V1UserContext;
import org.oasis.wsrp.v1.V1UserProfile;
import org.oasis.wsrp.v2.CacheControl;
import org.oasis.wsrp.v2.ClientData;
import org.oasis.wsrp.v2.ClonePortlet;
import org.oasis.wsrp.v2.Contact;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.DestroyPortlets;
import org.oasis.wsrp.v2.EmployerInfo;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.FailedPortlets;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetPortletDescription;
import org.oasis.wsrp.v2.GetPortletProperties;
import org.oasis.wsrp.v2.GetPortletPropertyDescription;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.ItemDescription;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModelTypes;
import org.oasis.wsrp.v2.ModifyRegistration;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.Online;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PersonName;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.Postal;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.PropertyDescription;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ReleaseSessions;
import org.oasis.wsrp.v2.ResetProperty;
import org.oasis.wsrp.v2.Resource;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceValue;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.SessionParams;
import org.oasis.wsrp.v2.SetPortletProperties;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.Telecom;
import org.oasis.wsrp.v2.TelephoneNum;
import org.oasis.wsrp.v2.Templates;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UploadContext;
import org.oasis.wsrp.v2.UserContext;
import org.oasis.wsrp.v2.UserProfile;

public class V1ToV2Converter {
    public static final V1ToV2Extension EXTENSION = new V1ToV2Extension();
    public static final V1ToV2MarkupType MARKUPTYPE = new V1ToV2MarkupType();
    public static final V1ToV2PortletDescription PORTLETDESCRIPTION = new V1ToV2PortletDescription();
    public static final V1ToV2LocalizedString LOCALIZEDSTRING = new V1ToV2LocalizedString();
    public static final V1ToV2ItemDescription ITEMDESCRIPTION = new V1ToV2ItemDescription();
    public static final V1ToV2PropertyDescription PROPERTYDESCRIPTION = new V1ToV2PropertyDescription();
    public static final V1ToV2Resource RESOURCE = new V1ToV2Resource();
    public static final V1ToV2ResourceValue RESOURCEVALUE = new V1ToV2ResourceValue();
    public static final V1ToV2NamedString NAMEDSTRING = new V1ToV2NamedString();
    public static final V1ToV2UploadContext UPLOADCONTEXT = new V1ToV2UploadContext();
    public static final V1ToV2Property PROPERTY = new V1ToV2Property();
    public static final V1ToV2ResetProperty RESETPROPERTY = new V1ToV2ResetProperty();

    public static MarkupParams toV2MarkupParams(V1MarkupParams v1MarkupParams) {
        if (v1MarkupParams != null) {
            List<Extension> extensions;
            List validNewWindowStates;
            List validNewModes;
            MarkupParams markupParams = WSRPTypeFactory.createMarkupParams(v1MarkupParams.isSecureClientCommunication(), v1MarkupParams.getLocales(), v1MarkupParams.getMimeTypes(), v1MarkupParams.getMode(), v1MarkupParams.getWindowState());
            markupParams.setClientData(V1ToV2Converter.toV2ClientData(v1MarkupParams.getClientData()));
            if (v1MarkupParams.getNavigationalState() != null) {
                markupParams.setNavigationalContext(WSRPTypeFactory.createNavigationalContextOrNull((StateString)new OpaqueStateString(v1MarkupParams.getNavigationalState()), null));
            }
            markupParams.setValidateTag(v1MarkupParams.getValidateTag());
            List charSets = v1MarkupParams.getMarkupCharacterSets();
            if (charSets != null) {
                markupParams.getMarkupCharacterSets().addAll(charSets);
            }
            if ((validNewModes = v1MarkupParams.getValidNewModes()) != null) {
                markupParams.getValidNewModes().addAll(validNewModes);
            }
            if ((validNewWindowStates = v1MarkupParams.getValidNewWindowStates()) != null) {
                markupParams.getValidNewWindowStates().addAll(validNewWindowStates);
            }
            if ((extensions = WSRPUtils.transform(v1MarkupParams.getExtensions(), EXTENSION)) != null) {
                markupParams.getExtensions().addAll(extensions);
            }
            return markupParams;
        }
        return null;
    }

    public static ClientData toV2ClientData(V1ClientData v1ClientData) {
        if (v1ClientData != null) {
            ClientData clientData = WSRPTypeFactory.createClientData(v1ClientData.getUserAgent());
            List extensions = v1ClientData.getExtensions();
            if (extensions != null) {
                clientData.getExtensions().addAll(Lists.transform((List)extensions, (Function)EXTENSION));
            }
            return clientData;
        }
        return null;
    }

    public static PortletContext toV2PortletContext(V1PortletContext v1PortletContext) {
        if (v1PortletContext != null) {
            PortletContext portletContext = WSRPTypeFactory.createPortletContext(v1PortletContext.getPortletHandle(), v1PortletContext.getPortletState());
            List extensions = v1PortletContext.getExtensions();
            if (extensions != null) {
                portletContext.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return portletContext;
        }
        return null;
    }

    public static RegistrationContext toV2RegistrationContext(V1RegistrationContext registrationContext) {
        if (registrationContext != null) {
            RegistrationContext result = WSRPTypeFactory.createRegistrationContext(registrationContext.getRegistrationHandle());
            result.setRegistrationState(registrationContext.getRegistrationState());
            List<Extension> extensions = WSRPUtils.transform(registrationContext.getExtensions(), EXTENSION);
            if (extensions != null) {
                result.getExtensions().addAll(extensions);
            }
            return result;
        }
        return null;
    }

    public static RuntimeContext toV2RuntimeContext(V1RuntimeContext v1RuntimeContext, String portletHandle) {
        if (v1RuntimeContext != null) {
            String portletInstanceKey = ParameterValidation.isNullOrEmpty((String)v1RuntimeContext.getPortletInstanceKey()) ? portletHandle : v1RuntimeContext.getPortletInstanceKey();
            String namespacePrefix = ParameterValidation.isNullOrEmpty((String)v1RuntimeContext.getNamespacePrefix()) ? PortletUtils.generateNamespaceFrom((String)portletHandle) : v1RuntimeContext.getNamespacePrefix();
            RuntimeContext runtimeContext = WSRPTypeFactory.createRuntimeContext(v1RuntimeContext.getUserAuthentication(), portletInstanceKey, namespacePrefix);
            SessionParams sessionParams = WSRPTypeFactory.createSessionParams(v1RuntimeContext.getSessionID());
            runtimeContext.setSessionParams(sessionParams);
            runtimeContext.setTemplates(V1ToV2Converter.toV2Templates(v1RuntimeContext.getTemplates()));
            List extensions = v1RuntimeContext.getExtensions();
            if (extensions != null) {
                runtimeContext.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return runtimeContext;
        }
        return null;
    }

    public static Templates toV2Templates(V1Templates v1Templates) {
        if (v1Templates != null) {
            String defaultTemplate = v1Templates.getDefaultTemplate();
            String blockingActionTemplate = v1Templates.getBlockingActionTemplate();
            String renderTemplate = v1Templates.getRenderTemplate();
            String resourceTemplate = v1Templates.getResourceTemplate();
            String secureDefaultTemplate = v1Templates.getSecureDefaultTemplate();
            String secureBlockingActionTemplate = v1Templates.getSecureBlockingActionTemplate();
            String secureRenderTemplate = v1Templates.getSecureRenderTemplate();
            String secureResourceTemplate = v1Templates.getSecureResourceTemplate();
            Templates templates = WSRPTypeFactory.createTemplates(defaultTemplate, blockingActionTemplate, renderTemplate, resourceTemplate, secureDefaultTemplate, secureBlockingActionTemplate, secureRenderTemplate, secureResourceTemplate);
            List extensions = v1Templates.getExtensions();
            if (extensions != null) {
                templates.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return templates;
        }
        return null;
    }

    public static UserContext toV2UserContext(V1UserContext v1UserContext) {
        if (v1UserContext != null) {
            UserContext userContext = WSRPTypeFactory.createUserContext(v1UserContext.getUserContextKey());
            userContext.setProfile(V1ToV2Converter.toV2UserProfile(v1UserContext.getProfile()));
            List extensions = v1UserContext.getExtensions();
            if (extensions != null) {
                userContext.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            if (v1UserContext.getUserCategories() != null) {
                userContext.getUserCategories().addAll(v1UserContext.getUserCategories());
            }
            return userContext;
        }
        return null;
    }

    public static UserProfile toV2UserProfile(V1UserProfile v1UserProfile) {
        if (v1UserProfile != null) {
            PersonName name = V1ToV2Converter.toV2PersonName(v1UserProfile.getName());
            XMLGregorianCalendar bdate = v1UserProfile.getBdate();
            String gender = v1UserProfile.getGender();
            EmployerInfo employerInfo = V1ToV2Converter.toV2EmployerInfo(v1UserProfile.getEmployerInfo());
            Contact homeInfo = V1ToV2Converter.toV2Context(v1UserProfile.getHomeInfo());
            Contact businessInfo = V1ToV2Converter.toV2Context(v1UserProfile.getBusinessInfo());
            UserProfile userProfile = WSRPTypeFactory.createUserProfile(name, bdate, gender, employerInfo, homeInfo, businessInfo);
            return userProfile;
        }
        return null;
    }

    public static EmployerInfo toV2EmployerInfo(V1EmployerInfo v1EmployerInfo) {
        if (v1EmployerInfo != null) {
            String employer = v1EmployerInfo.getEmployer();
            String department = v1EmployerInfo.getEmployer();
            String jobTitle = v1EmployerInfo.getJobtitle();
            EmployerInfo employerInfo = WSRPTypeFactory.createEmployerInfo(employer, department, jobTitle);
            List extensions = v1EmployerInfo.getExtensions();
            if (extensions != null) {
                employerInfo.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return employerInfo;
        }
        return null;
    }

    public static PersonName toV2PersonName(V1PersonName v1PersonName) {
        if (v1PersonName != null) {
            PersonName personName = WSRPTypeFactory.createPersonName(v1PersonName.getPrefix(), v1PersonName.getGiven(), v1PersonName.getFamily(), v1PersonName.getMiddle(), v1PersonName.getSuffix(), v1PersonName.getNickname());
            List extensions = v1PersonName.getExtensions();
            if (extensions != null) {
                personName.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return personName;
        }
        return null;
    }

    public static Contact toV2Context(V1Contact v1Contact) {
        if (v1Contact != null) {
            Postal postal = V1ToV2Converter.toV2Postal(v1Contact.getPostal());
            Telecom teleCom = V1ToV2Converter.toV2Telecom(v1Contact.getTelecom());
            Online online = V1ToV2Converter.toV2Online(v1Contact.getOnline());
            Contact contact = WSRPTypeFactory.createContact(postal, teleCom, online);
            List extensions = v1Contact.getExtensions();
            if (extensions != null) {
                contact.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return contact;
        }
        return null;
    }

    public static Online toV2Online(V1Online v1Online) {
        if (v1Online != null) {
            Online online = WSRPTypeFactory.createOnline(v1Online.getEmail(), v1Online.getUri());
            List extensions = v1Online.getExtensions();
            if (extensions != null) {
                online.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return online;
        }
        return null;
    }

    public static Postal toV2Postal(V1Postal v1Postal) {
        if (v1Postal != null) {
            Postal postal = WSRPTypeFactory.createPostal(v1Postal.getName(), v1Postal.getStreet(), v1Postal.getCity(), v1Postal.getStateprov(), v1Postal.getPostalcode(), v1Postal.getCountry(), v1Postal.getOrganization());
            List extensions = v1Postal.getExtensions();
            if (extensions != null) {
                postal.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return postal;
        }
        return null;
    }

    public static Telecom toV2Telecom(V1Telecom v1Telecom) {
        if (v1Telecom != null) {
            TelephoneNum telephone = V1ToV2Converter.toV2TelephoneNum(v1Telecom.getTelephone());
            TelephoneNum fax = V1ToV2Converter.toV2TelephoneNum(v1Telecom.getFax());
            TelephoneNum mobile = V1ToV2Converter.toV2TelephoneNum(v1Telecom.getMobile());
            TelephoneNum pager = V1ToV2Converter.toV2TelephoneNum(v1Telecom.getPager());
            Telecom telecom = WSRPTypeFactory.createTelecom(telephone, fax, mobile, pager);
            List extensions = v1Telecom.getExtensions();
            if (extensions != null) {
                telecom.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return telecom;
        }
        return null;
    }

    public static TelephoneNum toV2TelephoneNum(V1TelephoneNum v1TelephoneNum) {
        if (v1TelephoneNum != null) {
            String intCode = v1TelephoneNum.getIntcode();
            String loccode = v1TelephoneNum.getLoccode();
            String number = v1TelephoneNum.getNumber();
            String ext = v1TelephoneNum.getExt();
            String comment = v1TelephoneNum.getComment();
            TelephoneNum telephoneNum = WSRPTypeFactory.createTelephoneNum(intCode, loccode, number, ext, comment);
            List extensions = v1TelephoneNum.getExtensions();
            if (extensions != null) {
                telephoneNum.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return telephoneNum;
        }
        return null;
    }

    public static <E extends Exception> E toV2Exception(Class<E> v2ExceptionClass, Exception v1Exception) {
        if (!"org.oasis.wsrp.v2".equals(v2ExceptionClass.getPackage().getName())) {
            throw new IllegalArgumentException("Specified exception class is not a WSRP 2 exception: " + v2ExceptionClass);
        }
        Class<?> v1ExceptionClass = v1Exception.getClass();
        String v1Name = v1ExceptionClass.getSimpleName();
        int v1Index = v1Name.indexOf("V1");
        if (v1Index != 0 && !"org.oasis.wsrp.v1".equals(v1ExceptionClass.getPackage().getName())) {
            throw new IllegalArgumentException("Specified exception is not a WSRP 1 exception: " + v1Exception);
        }
        String v2Name = v2ExceptionClass.getSimpleName();
        if (!v2Name.equals(v1Name.substring(2))) {
            throw new IllegalArgumentException("Exception names do not match. Requested: " + v2Name + ", was given: " + v1Name);
        }
        return WSRPExceptionFactory.createWSException(v2ExceptionClass, v1Exception.getMessage(), v1Exception.getCause());
    }

    public static InteractionParams toV2InteractionParams(V1InteractionParams v1InteractionParams) {
        if (v1InteractionParams != null) {
            InteractionParams interactionParams = WSRPTypeFactory.createInteractionParams(V1ToV2Converter.toV2StateChange(v1InteractionParams.getPortletStateChange()));
            interactionParams.setInteractionState(v1InteractionParams.getInteractionState());
            interactionParams.getExtensions().addAll(Lists.transform((List)v1InteractionParams.getExtensions(), (Function)EXTENSION));
            interactionParams.getFormParameters().addAll(Lists.transform((List)v1InteractionParams.getFormParameters(), (Function)NAMEDSTRING));
            interactionParams.getUploadContexts().addAll(Lists.transform((List)v1InteractionParams.getUploadContexts(), (Function)UPLOADCONTEXT));
            return interactionParams;
        }
        return null;
    }

    public static StateChange toV2StateChange(V1StateChange v1StateChange) {
        if (v1StateChange != null) {
            return StateChange.fromValue((String)v1StateChange.value());
        }
        return null;
    }

    public static LocalizedString toV2LocalizedString(V1LocalizedString localizedString) {
        return LOCALIZEDSTRING.apply(localizedString);
    }

    public static CookieProtocol toV2CookieProtocol(V1CookieProtocol v1CookieProtocol) {
        if (v1CookieProtocol != null) {
            return CookieProtocol.fromValue((String)v1CookieProtocol.value());
        }
        return null;
    }

    public static ModelDescription toV2ModelDescription(V1ModelDescription v1ModelDescription) {
        if (v1ModelDescription != null) {
            ModelDescription result = WSRPTypeFactory.createModelDescription(WSRPUtils.transform(v1ModelDescription.getPropertyDescriptions(), PROPERTYDESCRIPTION));
            List<Extension> extensions = WSRPUtils.transform(v1ModelDescription.getExtensions(), EXTENSION);
            if (extensions != null) {
                result.getExtensions().addAll(extensions);
            }
            result.setModelTypes(V1ToV2Converter.toV2ModelTypes(v1ModelDescription.getModelTypes()));
            return result;
        }
        return null;
    }

    public static ModelTypes toV2ModelTypes(V1ModelTypes modelTypes) {
        if (modelTypes != null) {
            ModelTypes result = new ModelTypes();
            result.setAny(modelTypes.getAny());
            return result;
        }
        return null;
    }

    public static ResourceList toV2ResourceList(V1ResourceList v1ResourceList) {
        if (v1ResourceList != null) {
            List<Resource> resources = WSRPUtils.transform(v1ResourceList.getResources(), RESOURCE);
            ResourceList result = WSRPTypeFactory.createResourceList(resources);
            List<Extension> extensions = WSRPUtils.transform(v1ResourceList.getExtensions(), EXTENSION);
            if (extensions != null) {
                result.getExtensions().addAll(extensions);
            }
            return result;
        }
        return null;
    }

    public static PropertyList toV2PropertyList(V1PropertyList v1PropertyList) {
        if (v1PropertyList != null) {
            List<Extension> extensions;
            List<ResetProperty> resetProperties;
            PropertyList result = WSRPTypeFactory.createPropertyList();
            List<Property> properties = WSRPUtils.transform(v1PropertyList.getProperties(), PROPERTY);
            if (properties != null) {
                result.getProperties().addAll(properties);
            }
            if ((resetProperties = WSRPUtils.transform(v1PropertyList.getResetProperties(), RESETPROPERTY)) != null) {
                result.getResetProperties().addAll(resetProperties);
            }
            if ((extensions = WSRPUtils.transform(v1PropertyList.getExtensions(), EXTENSION)) != null) {
                result.getExtensions().addAll(extensions);
            }
            return result;
        }
        return null;
    }

    public static PortletDescription toV2PortletDescription(V1PortletDescription v1PortletDescription) {
        return PORTLETDESCRIPTION.apply(v1PortletDescription);
    }

    public static List<FailedPortlets> toV2FailedPortlets(List<V1DestroyFailed> destroyFailed) {
        if (ParameterValidation.existsAndIsNotEmpty(destroyFailed)) {
            ArrayList<FailedPortlets> result = new ArrayList<FailedPortlets>(destroyFailed.size());
            for (V1DestroyFailed failed : destroyFailed) {
                result.add(WSRPTypeFactory.createFailedPortlets(Collections.singletonList(failed.getPortletHandle()), ErrorCodes.Codes.OPERATIONFAILED, failed.getReason()));
            }
            return result;
        }
        return null;
    }

    public static RegistrationData toV2RegistrationData(V1RegistrationData registrationData) {
        if (registrationData != null) {
            List<Extension> extensions;
            List windowStates;
            List consumerUserScopes;
            List modes;
            RegistrationData result = WSRPTypeFactory.createRegistrationData(registrationData.getConsumerName(), registrationData.getConsumerAgent(), registrationData.isMethodGetSupported());
            List<Property> properties = WSRPUtils.transform(registrationData.getRegistrationProperties(), PROPERTY);
            if (properties != null) {
                result.getRegistrationProperties().addAll(properties);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)(modes = registrationData.getConsumerModes()))) {
                result.getConsumerModes().addAll(modes);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)(consumerUserScopes = registrationData.getConsumerUserScopes()))) {
                result.getConsumerUserScopes().addAll(consumerUserScopes);
            }
            if (ParameterValidation.existsAndIsNotEmpty((Collection)(windowStates = registrationData.getConsumerWindowStates()))) {
                result.getConsumerWindowStates().addAll(windowStates);
            }
            if ((extensions = WSRPUtils.transform(registrationData.getExtensions(), EXTENSION)) != null) {
                result.getExtensions().addAll(extensions);
            }
            return result;
        }
        return null;
    }

    public static MarkupContext toV2MarkupContext(V1MarkupContext v1MarkupContext) {
        if (v1MarkupContext != null) {
            MarkupContext result = WSRPTypeFactory.createMarkupContext(v1MarkupContext.getMimeType(), v1MarkupContext.getMarkupString(), v1MarkupContext.getMarkupBinary(), v1MarkupContext.isUseCachedMarkup());
            result.setCacheControl(V1ToV2Converter.toV2CacheControl(v1MarkupContext.getCacheControl()));
            result.setLocale(v1MarkupContext.getLocale());
            result.setMimeType(v1MarkupContext.getMimeType());
            result.setPreferredTitle(v1MarkupContext.getPreferredTitle());
            result.setRequiresRewriting(v1MarkupContext.isRequiresUrlRewriting());
            List extensions = v1MarkupContext.getExtensions();
            if (extensions != null) {
                result.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return result;
        }
        return null;
    }

    private static CacheControl toV2CacheControl(V1CacheControl v1CacheControl) {
        if (v1CacheControl != null) {
            CacheControl result = WSRPTypeFactory.createCacheControl(v1CacheControl.getExpires(), v1CacheControl.getUserScope());
            result.setValidateTag(v1CacheControl.getValidateTag());
            List extensions = v1CacheControl.getExtensions();
            if (extensions != null) {
                result.getExtensions().addAll(WSRPUtils.transform(extensions, EXTENSION));
            }
            return result;
        }
        return null;
    }

    public static SessionContext toV2SessionContext(V1SessionContext sessionContext) {
        if (sessionContext != null) {
            SessionContext result = WSRPTypeFactory.createSessionContext(sessionContext.getSessionID(), sessionContext.getExpires());
            result.getExtensions().addAll(Lists.transform((List)sessionContext.getExtensions(), (Function)EXTENSION));
            return result;
        }
        return null;
    }

    public static UpdateResponse toV2UpdateResponse(V1UpdateResponse updateResponse) {
        if (updateResponse != null) {
            UpdateResponse result = WSRPTypeFactory.createUpdateResponse();
            result.setMarkupContext(V1ToV2Converter.toV2MarkupContext(updateResponse.getMarkupContext()));
            String state = updateResponse.getNavigationalState();
            if (state != null) {
                result.setNavigationalContext(WSRPTypeFactory.createNavigationalContextOrNull((StateString)new OpaqueStateString(state), null));
            }
            result.setNewWindowState(updateResponse.getNewWindowState());
            result.setPortletContext(V1ToV2Converter.toV2PortletContext(updateResponse.getPortletContext()));
            result.setSessionContext(V1ToV2Converter.toV2SessionContext(updateResponse.getSessionContext()));
            result.setNewMode(updateResponse.getNewMode());
            return result;
        }
        return null;
    }

    public static GetServiceDescription toV2GetServiceDescription(V1GetServiceDescription getServiceDescription) {
        if (getServiceDescription != null) {
            GetServiceDescription result = WSRPTypeFactory.createGetServiceDescription(V1ToV2Converter.toV2RegistrationContext(getServiceDescription.getRegistrationContext()), null);
            List locales = getServiceDescription.getDesiredLocales();
            if (ParameterValidation.existsAndIsNotEmpty((Collection)locales)) {
                result.getDesiredLocales().addAll(locales);
            }
            return result;
        }
        return null;
    }

    public static GetMarkup toV2GetMarkup(V1GetMarkup getMarkup) {
        if (getMarkup != null) {
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(getMarkup.getPortletContext());
            RuntimeContext runtimeContext = V1ToV2Converter.toV2RuntimeContext(getMarkup.getRuntimeContext(), portletContext.getPortletHandle());
            MarkupParams markupParams = V1ToV2Converter.toV2MarkupParams(getMarkup.getMarkupParams());
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(getMarkup.getRegistrationContext());
            UserContext userContext = V1ToV2Converter.toV2UserContext(getMarkup.getUserContext());
            return WSRPTypeFactory.createGetMarkup(registrationContext, portletContext, runtimeContext, userContext, markupParams);
        }
        return null;
    }

    public static ModifyRegistration toV2ModifyRegistration(V1ModifyRegistration modifyRegistration) {
        if (modifyRegistration != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(modifyRegistration.getRegistrationContext());
            RegistrationData registrationData = V1ToV2Converter.toV2RegistrationData(modifyRegistration.getRegistrationData());
            ModifyRegistration result = WSRPTypeFactory.createModifyRegistration(registrationContext, registrationData);
            return result;
        }
        return null;
    }

    public static ClonePortlet toV2ClonePortlet(V1ClonePortlet clonePortlet) {
        if (clonePortlet != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(clonePortlet.getRegistrationContext());
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(clonePortlet.getPortletContext());
            UserContext userContext = V1ToV2Converter.toV2UserContext(clonePortlet.getUserContext());
            ClonePortlet result = WSRPTypeFactory.createClonePortlet(registrationContext, portletContext, userContext);
            return result;
        }
        return null;
    }

    public static PerformBlockingInteraction toV2PerformBlockingInteraction(V1PerformBlockingInteraction performBlockingInteraction) {
        if (performBlockingInteraction != null) {
            InteractionParams interactionParams = V1ToV2Converter.toV2InteractionParams(performBlockingInteraction.getInteractionParams());
            MarkupParams markupParams = V1ToV2Converter.toV2MarkupParams(performBlockingInteraction.getMarkupParams());
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(performBlockingInteraction.getPortletContext());
            RuntimeContext runtimeContext = V1ToV2Converter.toV2RuntimeContext(performBlockingInteraction.getRuntimeContext(), portletContext.getPortletHandle());
            return WSRPTypeFactory.createPerformBlockingInteraction(V1ToV2Converter.toV2RegistrationContext(performBlockingInteraction.getRegistrationContext()), portletContext, runtimeContext, V1ToV2Converter.toV2UserContext(performBlockingInteraction.getUserContext()), markupParams, interactionParams);
        }
        return null;
    }

    public static DestroyPortlets toV2DestroyPortlets(V1DestroyPortlets destroyPortlets) {
        if (destroyPortlets != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(destroyPortlets.getRegistrationContext());
            DestroyPortlets result = WSRPTypeFactory.createDestroyPortlets(registrationContext, destroyPortlets.getPortletHandles());
            return result;
        }
        return null;
    }

    public static SetPortletProperties toV2SetPortletProperties(V1SetPortletProperties setPortletProperties) {
        if (setPortletProperties != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(setPortletProperties.getRegistrationContext());
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(setPortletProperties.getPortletContext());
            PropertyList propertyList = V1ToV2Converter.toV2PropertyList(setPortletProperties.getPropertyList());
            SetPortletProperties result = WSRPTypeFactory.createSetPortletProperties(registrationContext, portletContext, propertyList);
            result.setUserContext(V1ToV2Converter.toV2UserContext(setPortletProperties.getUserContext()));
            return result;
        }
        return null;
    }

    public static GetPortletProperties toV2GetPortletProperties(V1GetPortletProperties getPortletProperties) {
        if (getPortletProperties != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(getPortletProperties.getRegistrationContext());
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(getPortletProperties.getPortletContext());
            UserContext userContext = V1ToV2Converter.toV2UserContext(getPortletProperties.getUserContext());
            GetPortletProperties result = WSRPTypeFactory.createGetPortletProperties(registrationContext, portletContext, userContext, getPortletProperties.getNames());
            return result;
        }
        return null;
    }

    public static ReleaseSessions toV2ReleaseSessions(V1ReleaseSessions releaseSessions) {
        if (releaseSessions != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(releaseSessions.getRegistrationContext());
            ReleaseSessions result = WSRPTypeFactory.createReleaseSessions(registrationContext, releaseSessions.getSessionIDs());
            return result;
        }
        return null;
    }

    public static InitCookie toV2InitCookie(V1InitCookie initCookie) {
        if (initCookie != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(initCookie.getRegistrationContext());
            InitCookie result = WSRPTypeFactory.createInitCookie(registrationContext);
            return result;
        }
        return null;
    }

    public static GetPortletPropertyDescription toV2GetPortletPropertyDescription(V1GetPortletPropertyDescription getPortletPropertyDescription) {
        if (getPortletPropertyDescription != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(getPortletPropertyDescription.getRegistrationContext());
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(getPortletPropertyDescription.getPortletContext());
            UserContext userContext = V1ToV2Converter.toV2UserContext(getPortletPropertyDescription.getUserContext());
            GetPortletPropertyDescription result = WSRPTypeFactory.createGetPortletPropertyDescription(registrationContext, portletContext, userContext, getPortletPropertyDescription.getDesiredLocales());
            return result;
        }
        return null;
    }

    public static GetPortletDescription toV2GetPortletDescription(V1GetPortletDescription getPortletDescription) {
        if (getPortletDescription != null) {
            RegistrationContext registrationContext = V1ToV2Converter.toV2RegistrationContext(getPortletDescription.getRegistrationContext());
            PortletContext portletContext = V1ToV2Converter.toV2PortletContext(getPortletDescription.getPortletContext());
            UserContext userContext = V1ToV2Converter.toV2UserContext(getPortletDescription.getUserContext());
            GetPortletDescription result = WSRPTypeFactory.createGetPortletDescription(registrationContext, portletContext, userContext);
            result.getDesiredLocales().addAll(getPortletDescription.getDesiredLocales());
            return result;
        }
        return null;
    }

    private static class V1ToV2ResetProperty
    implements Function<V1ResetProperty, ResetProperty> {
        private V1ToV2ResetProperty() {
        }

        public ResetProperty apply(V1ResetProperty from) {
            if (from != null) {
                return WSRPTypeFactory.createResetProperty(from.getName());
            }
            return null;
        }
    }

    public static class V1ToV2Property
    implements Function<V1Property, Property> {
        public Property apply(V1Property from) {
            if (from != null) {
                Property result = WSRPTypeFactory.createProperty(from.getName(), from.getLang(), from.getStringValue());
                result.setType(WSRPConstants.XSD_STRING);
                List any = from.getAny();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)any)) {
                    result.getAny().addAll(any);
                }
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2PropertyDescription
    implements Function<V1PropertyDescription, PropertyDescription> {
        public PropertyDescription apply(V1PropertyDescription from) {
            if (from != null) {
                PropertyDescription result = WSRPTypeFactory.createPropertyDescription(from.getName(), from.getType());
                result.setHint(V1ToV2Converter.toV2LocalizedString(from.getHint()));
                result.setLabel(V1ToV2Converter.toV2LocalizedString(from.getLabel()));
                List<Extension> extensions = WSRPUtils.transform(from.getExtensions(), EXTENSION);
                if (extensions != null) {
                    result.getExtensions().addAll(extensions);
                }
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2ResourceValue
    implements Function<V1ResourceValue, ResourceValue> {
        public ResourceValue apply(V1ResourceValue from) {
            if (from != null) {
                ResourceValue result = WSRPTypeFactory.createResourceValue(from.getLang(), from.getValue());
                List<Extension> extensions = WSRPUtils.transform(from.getExtensions(), EXTENSION);
                if (extensions != null) {
                    result.getExtensions().addAll(extensions);
                }
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2Resource
    implements Function<V1Resource, Resource> {
        public Resource apply(V1Resource from) {
            if (from != null) {
                Resource result = WSRPTypeFactory.createResource(from.getResourceName(), WSRPUtils.transform(from.getValues(), RESOURCEVALUE));
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2LocalizedString
    implements Function<V1LocalizedString, LocalizedString> {
        public LocalizedString apply(V1LocalizedString from) {
            if (from != null) {
                return WSRPTypeFactory.createLocalizedString(from.getLang(), from.getResourceName(), from.getValue());
            }
            return null;
        }
    }

    public static class V1ToV2MarkupType
    implements Function<V1MarkupType, MarkupType> {
        public MarkupType apply(V1MarkupType from) {
            if (from != null) {
                MarkupType result = WSRPTypeFactory.createMarkupType(from.getMimeType(), from.getModes(), from.getWindowStates(), from.getLocales());
                List<Extension> extensions = WSRPUtils.transform(from.getExtensions(), EXTENSION);
                if (extensions != null) {
                    result.getExtensions().addAll(extensions);
                }
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2UploadContext
    implements Function<V1UploadContext, UploadContext> {
        public UploadContext apply(V1UploadContext v1UploadContext) {
            if (v1UploadContext != null) {
                UploadContext result = WSRPTypeFactory.createUploadContext(v1UploadContext.getMimeType(), v1UploadContext.getUploadData());
                result.getExtensions().addAll(Lists.transform((List)v1UploadContext.getExtensions(), (Function)EXTENSION));
                result.getMimeAttributes().addAll(Lists.transform((List)v1UploadContext.getMimeAttributes(), (Function)NAMEDSTRING));
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2NamedString
    implements Function<V1NamedString, NamedString> {
        public NamedString apply(V1NamedString v1NamedString) {
            if (v1NamedString != null) {
                return WSRPTypeFactory.createNamedString(v1NamedString.getName(), v1NamedString.getValue());
            }
            return null;
        }
    }

    public static class V1ToV2ItemDescription
    implements Function<V1ItemDescription, ItemDescription> {
        public ItemDescription apply(V1ItemDescription from) {
            if (from != null) {
                LocalizedString description = LOCALIZEDSTRING.apply(from.getDescription());
                ItemDescription result = WSRPTypeFactory.createItemDescription(description, null, from.getItemName());
                List<Extension> extensions = WSRPUtils.transform(from.getExtensions(), EXTENSION);
                if (extensions != null) {
                    result.getExtensions().addAll(extensions);
                }
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2PortletDescription
    implements Function<V1PortletDescription, PortletDescription> {
        public PortletDescription apply(V1PortletDescription from) {
            if (from != null) {
                List userProfileItems;
                List userCategories;
                List<LocalizedString> keywords;
                PortletDescription result = WSRPTypeFactory.createPortletDescription(from.getPortletHandle(), WSRPUtils.transform(from.getMarkupTypes(), MARKUPTYPE));
                result.setDescription(LOCALIZEDSTRING.apply(from.getDescription()));
                result.setDisplayName(LOCALIZEDSTRING.apply(from.getDisplayName()));
                List<Extension> extensions = WSRPUtils.transform(from.getExtensions(), EXTENSION);
                if (extensions != null) {
                    result.getExtensions().addAll(extensions);
                }
                if ((keywords = WSRPUtils.transform(from.getKeywords(), LOCALIZEDSTRING)) != null) {
                    result.getKeywords().addAll(keywords);
                }
                if ((userCategories = from.getUserCategories()) != null) {
                    result.getUserCategories().addAll(userCategories);
                }
                if ((userProfileItems = from.getUserProfileItems()) != null) {
                    result.getUserProfileItems().addAll(userProfileItems);
                }
                result.setDefaultMarkupSecure(from.isDefaultMarkupSecure());
                result.setDoesUrlTemplateProcessing(from.isDoesUrlTemplateProcessing());
                result.setTemplatesStoredInSession(from.isTemplatesStoredInSession());
                result.setHasUserSpecificState(from.isHasUserSpecificState());
                result.setOnlySecure(from.isOnlySecure());
                result.setUserContextStoredInSession(from.isUserContextStoredInSession());
                result.setUsesMethodGet(from.isUsesMethodGet());
                result.setShortTitle(LOCALIZEDSTRING.apply(from.getShortTitle()));
                result.setTitle(LOCALIZEDSTRING.apply(from.getTitle()));
                result.setGroupID(from.getGroupID());
                return result;
            }
            return null;
        }
    }

    public static class V1ToV2Extension
    implements Function<V1Extension, Extension> {
        public Extension apply(V1Extension from) {
            if (from != null) {
                Extension extension = WSRPTypeFactory.createExtension(from.getAny());
                return extension;
            }
            return null;
        }
    }
}

