/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Tools;
import org.gatein.wsrp.consumer.handlers.SessionHandler;
import org.oasis.wsrp.v2.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerSessionInformation
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(ProducerSessionInformation.class);
    private boolean initCookieDone = false;
    private boolean perGroupCookies = false;
    private Map<String, Cookie[]> groupCookies;
    private Map<String, SessionInfo> portletSessions;
    private Map<String, String> sessionId2PortletHandle;
    private Cookie[] userCookie;
    private transient SessionHandler parent;
    private String parentSessionId;

    public String getParentSessionId() {
        return this.parentSessionId;
    }

    public void setParentSessionId(String parentSessionId) {
        boolean error = false;
        if (parentSessionId != null) {
            parentSessionId = SessionHandler.getRealId(parentSessionId);
            if (this.parentSessionId != null && !parentSessionId.equals(this.parentSessionId)) {
                error = true;
            }
        } else if (this.parentSessionId != null) {
            error = true;
        }
        if (error) {
            throw new IllegalStateException("Cannot modify Parent Session id once it has been set!");
        }
        this.parentSessionId = parentSessionId;
    }

    public String getUserCookie() {
        if (this.userCookie == null) {
            return null;
        }
        this.userCookie = this.purgeExpiredCookies(this.userCookie);
        if (this.userCookie.length == 0) {
            this.setInitCookieDone(false);
        }
        return this.outputToExternalForm(this.userCookie);
    }

    public void setUserCookie(Cookie[] userCookie) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((Object[])userCookie, (String)"cookies");
        this.userCookie = userCookie;
    }

    public boolean isInitCookieDone() {
        return this.initCookieDone;
    }

    public void setInitCookieDone(boolean initCookieDone) {
        this.initCookieDone = initCookieDone;
    }

    public boolean isPerGroupCookies() {
        return this.perGroupCookies;
    }

    public void setPerGroupCookies(boolean perGroupCookies) {
        this.perGroupCookies = perGroupCookies;
    }

    public void setGroupCookieFor(String groupId, Cookie[] cookies) {
        if (!this.isPerGroupCookies()) {
            throw new IllegalStateException("Cannot add group cookie when cookie protocol is perUser.");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Cannot set cookie for a null portlet group id!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((Object[])cookies, (String)"cookies");
        if (this.groupCookies == null) {
            this.groupCookies = new HashMap<String, Cookie[]>();
        }
        if (this.groupCookies.containsKey(groupId)) {
            log.debug("Trying to set a cookie for an existing group: " + groupId);
        }
        this.groupCookies.put(groupId, cookies);
    }

    public String getGroupCookieFor(String groupId) {
        if (this.groupCookies == null) {
            return null;
        }
        Cookie[] cookies = this.groupCookies.get(groupId);
        if (cookies != null) {
            if ((cookies = this.purgeExpiredCookies(cookies)).length == 0) {
                this.setInitCookieDone(false);
            }
            this.groupCookies.put(groupId, cookies);
            return this.outputToExternalForm(cookies);
        }
        return null;
    }

    public void clearGroupCookies() {
        this.groupCookies = null;
    }

    public void addSessionForPortlet(String portletHandle, SessionContext sessionContext) {
        SessionInfo info = new SessionInfo(sessionContext, portletHandle);
        if (this.portletSessions == null) {
            this.portletSessions = new HashMap<String, SessionInfo>();
            this.sessionId2PortletHandle = new HashMap<String, String>();
        }
        this.portletSessions.put(portletHandle, info);
        this.sessionId2PortletHandle.put(sessionContext.getSessionID(), portletHandle);
        if (this.parent != null) {
            this.parent.addSessionMapping(sessionContext.getSessionID(), this);
        }
    }

    public String getSessionIdForPortlet(String portletHandle) {
        SessionIdResult idResult = this.internalGetSessionIdForPortlet(portletHandle);
        if (idResult.expired) {
            return null;
        }
        return idResult.id;
    }

    public int getNumberOfSessions() {
        if (this.portletSessions != null) {
            return this.portletSessions.size();
        }
        return 0;
    }

    public String removeSession(String sessionId) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)sessionId, (String)"session id");
        String portletHandle = this.sessionId2PortletHandle.get(sessionId);
        if (portletHandle == null) {
            throw new IllegalArgumentException("No such session id: '" + sessionId + "'");
        }
        return this.removeSessionForPortlet(portletHandle);
    }

    public List<String> removeSessions() {
        ArrayList<String> idsToRelease = new ArrayList<String>(this.getNumberOfSessions());
        ArrayList<String> handlesCopy = new ArrayList<String>(this.portletSessions.keySet());
        for (String handle : handlesCopy) {
            SessionIdResult result = this.removeSessionIdForPortlet(handle);
            if (result.expired) continue;
            idsToRelease.add(result.id);
        }
        return idsToRelease;
    }

    public String removeSessionForPortlet(String portletHandle) {
        SessionIdResult result = this.removeSessionIdForPortlet(portletHandle);
        return result.expired ? null : result.id;
    }

    private SessionIdResult removeSessionIdForPortlet(String portletHandle) {
        SessionIdResult result = this.internalGetSessionIdForPortlet(portletHandle);
        String id = result.id;
        if (id == null) {
            throw new IllegalArgumentException("There is no Session associated with portlet '" + portletHandle + "'");
        }
        if (!result.expired) {
            this.portletSessions.remove(portletHandle);
            this.sessionId2PortletHandle.remove(id);
            if (this.parent != null) {
                this.parent.removeSessionId(id);
            }
        }
        return result;
    }

    public void replaceUserCookiesWith(ProducerSessionInformation currentSessionInfo) {
        if (currentSessionInfo != null && currentSessionInfo.userCookie != null && currentSessionInfo.userCookie.length > 0) {
            this.userCookie = currentSessionInfo.userCookie;
        }
    }

    private String outputToExternalForm(Cookie[] cookies) {
        if (cookies != null && cookies.length != 0) {
            int cookieNumber = cookies.length;
            StringBuffer sb = new StringBuffer(128 * cookieNumber);
            for (int i = 0; i < cookieNumber; ++i) {
                sb.append(cookies[i].toExternalForm());
                if (i == cookieNumber - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    private Cookie[] purgeExpiredCookies(Cookie[] cookies) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((Object[])cookies, (String)"cookies");
        List cleanCookies = Tools.toList((Object[])cookies);
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired()) continue;
            cleanCookies.remove(cookie);
        }
        return cleanCookies.toArray(new Cookie[cleanCookies.size()]);
    }

    private SessionIdResult internalGetSessionIdForPortlet(String portletHandle) {
        SessionInfo session = this.getSessionInfoFor(portletHandle);
        if (session != null) {
            String id = session.getSessionId();
            if (!session.isStillValid()) {
                this.portletSessions.remove(session.getPortletHandle());
                this.sessionId2PortletHandle.remove(session.getSessionId());
                if (this.parent != null) {
                    this.parent.removeSessionId(session.getSessionId());
                }
                return new SessionIdResult(id, true);
            }
            return new SessionIdResult(id, false);
        }
        return new SessionIdResult(null, false);
    }

    private SessionInfo getSessionInfoFor(String portletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", null);
        if (this.portletSessions == null) {
            return null;
        }
        return this.portletSessions.get(portletHandle);
    }

    Collection<String> getSessionIds() {
        return this.sessionId2PortletHandle.keySet();
    }

    void setParent(SessionHandler sessionHandler) {
        this.parent = sessionHandler;
    }

    public void updateHandleAssociatedInfo(String originalHandle, String newHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)originalHandle, (String)"original handle", (String)"Updating information associated with a portlet handle");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)newHandle, (String)"new handle", (String)"Updating information associated with a portlet handle");
        String sessionId = this.getSessionIdForPortlet(originalHandle);
        SessionInfo info = this.getSessionInfoFor(originalHandle);
        if (sessionId != null && info != null) {
            this.portletSessions.put(newHandle, info);
            this.portletSessions.remove(originalHandle);
            this.sessionId2PortletHandle.put(sessionId, newHandle);
            log.debug("Updated mapping information for '" + originalHandle + "' to reference '" + newHandle + "' instead.");
        }
    }

    private class SessionIdResult {
        private String id;
        private boolean expired;

        public SessionIdResult(String id, boolean expired) {
            this.id = id;
            this.expired = expired;
        }
    }

    private class SessionInfo
    implements Serializable {
        private SessionContext sessionContext;
        private long lastInvocationTime;
        private String portletHandle;

        public SessionInfo(SessionContext sessionContext, String portletHandle) {
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)sessionContext, (String)"SessionContext");
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)sessionContext.getSessionID(), (String)"session id", (String)"SessionContext");
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"SessionInfo");
            this.sessionContext = sessionContext;
            this.portletHandle = portletHandle;
            this.lastInvocationTime = System.currentTimeMillis();
        }

        private boolean isStillValid() {
            int expires = this.sessionContext.getExpires();
            if (expires == -1) {
                return true;
            }
            long now = System.currentTimeMillis();
            long secondsSinceLastInvocation = (now - this.lastInvocationTime) / 1000L;
            this.lastInvocationTime = now;
            long diff = (long)expires - secondsSinceLastInvocation;
            log.debug("Session ID '" + this.sessionContext.getSessionID() + "' is " + (diff > 0L ? "" : "not") + " valid (time since last invocation: " + diff + ")");
            return diff > 0L;
        }

        private String getSessionId() {
            return this.sessionContext.getSessionID();
        }

        private String getPortletHandle() {
            return this.portletHandle;
        }
    }
}

