/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.migration;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;

public class BaseMigrationInfo {
    protected static final SortedMap<QName, List<String>> EMPTY_FAILED = new TreeMap<QName, List<String>>();
    protected final SortedMap<QName, List<String>> errorCodeToHandles;
    protected final long exportTime;

    public BaseMigrationInfo(long exportTime, SortedMap<QName, List<String>> errorCodeToHandles) {
        this.errorCodeToHandles = ParameterValidation.existsAndIsNotEmpty(errorCodeToHandles) ? errorCodeToHandles : EMPTY_FAILED;
        this.exportTime = exportTime;
    }

    public SortedMap<QName, List<String>> getErrorCodesToFailedPortletHandlesMapping() {
        return Collections.unmodifiableSortedMap(this.errorCodeToHandles);
    }

    public long getExportTime() {
        return this.exportTime;
    }

    public String getHumanReadableExportTime(Locale locale) {
        return this.getHumanReadableTime(locale, this.exportTime);
    }

    protected String getHumanReadableTime(Locale locale, long time) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateFormat.getDateTimeInstance(0, 0, locale).format(new Date(time));
    }
}

