/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services.v1;

import com.google.common.base.Function;
import java.util.List;
import javax.xml.ws.Holder;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.spec.v1.V1ToV2Converter;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetRegistrationLifetime;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.SetRegistrationLifetime;
import org.oasis.wsrp.v2.UserContext;

public class V1RegistrationService
extends RegistrationService<WSRPV1RegistrationPortType> {
    public V1RegistrationService(WSRPV1RegistrationPortType service) {
        super(service);
    }

    @Override
    public void register(RegistrationData registrationData, Lifetime lifetime, UserContext userContext, Holder<byte[]> registrationState, Holder<Lifetime> scheduledDestruction, Holder<List<Extension>> extensions, Holder<String> registrationHandle) throws MissingParameters, OperationFailed, OperationNotSupported {
        try {
            Holder v1Extensions = new Holder();
            ((WSRPV1RegistrationPortType)this.service).register(registrationData.getConsumerName(), registrationData.getConsumerAgent(), registrationData.isMethodGetSupported(), registrationData.getConsumerModes(), registrationData.getConsumerWindowStates(), registrationData.getConsumerUserScopes(), null, WSRPUtils.transform((List)registrationData.getRegistrationProperties(), (Function)V2ToV1Converter.PROPERTY), new Holder(), registrationHandle, registrationState);
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1MissingParameters v1MissingParameters) {
            throw (MissingParameters)V1ToV2Converter.toV2Exception(MissingParameters.class, (Exception)((Object)v1MissingParameters));
        }
        catch (V1OperationFailed v1OperationFailed) {
            throw (OperationFailed)((Object)V1ToV2Converter.toV2Exception(OperationFailed.class, (Exception)((Object)v1OperationFailed)));
        }
    }

    @Override
    public List<Extension> deregister(RegistrationContext registrationContext, UserContext userContext) throws InvalidRegistration, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1Extensions = new Holder();
            ((WSRPV1RegistrationPortType)this.service).deregister(registrationContext.getRegistrationHandle(), registrationContext.getRegistrationState(), v1Extensions);
            return WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            throw (InvalidRegistration)((Object)V1ToV2Converter.toV2Exception(InvalidRegistration.class, (Exception)((Object)v1InvalidRegistration)));
        }
        catch (V1OperationFailed v1OperationFailed) {
            throw (OperationFailed)((Object)V1ToV2Converter.toV2Exception(OperationFailed.class, (Exception)((Object)v1OperationFailed)));
        }
    }

    @Override
    public void modifyRegistration(RegistrationContext registrationContext, RegistrationData registrationData, UserContext userContext, Holder<byte[]> registrationState, Holder<Lifetime> scheduledDestruction, Holder<List<Extension>> extensions) throws InvalidRegistration, MissingParameters, OperationFailed, OperationNotSupported, ResourceSuspended {
        try {
            Holder v1Extensions = new Holder();
            ((WSRPV1RegistrationPortType)this.service).modifyRegistration(V2ToV1Converter.toV1RegistrationContext((RegistrationContext)registrationContext), V2ToV1Converter.toV1RegistrationData((RegistrationData)registrationData), registrationState, v1Extensions);
            extensions.value = WSRPUtils.transform((List)((List)v1Extensions.value), (Function)V1ToV2Converter.EXTENSION);
        }
        catch (V1InvalidRegistration v1InvalidRegistration) {
            throw (InvalidRegistration)((Object)V1ToV2Converter.toV2Exception(InvalidRegistration.class, (Exception)((Object)v1InvalidRegistration)));
        }
        catch (V1MissingParameters v1MissingParameters) {
            throw (MissingParameters)V1ToV2Converter.toV2Exception(MissingParameters.class, (Exception)((Object)v1MissingParameters));
        }
        catch (V1OperationFailed v1OperationFailed) {
            throw (OperationFailed)((Object)V1ToV2Converter.toV2Exception(OperationFailed.class, (Exception)((Object)v1OperationFailed)));
        }
    }

    @Override
    public Lifetime getRegistrationLifetime(GetRegistrationLifetime getRegistrationLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)((Object)WSRPExceptionFactory.createWSException(OperationNotSupported.class, (String)"getRegistrationLifetime is not supported in WSRP 1", null));
    }

    @Override
    public Lifetime setRegistrationLifetime(SetRegistrationLifetime setRegistrationLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)((Object)WSRPExceptionFactory.createWSException(OperationNotSupported.class, (String)"setRegistrationLifetime is not supported in WSRP 1", null));
    }
}

