/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.test.protocol.v2.ServiceDescriptionBehavior;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ServiceDescription;

public class RegistrationInfoTestCase
extends TestCase {
    private RegistrationInfo info;
    private static final String producerId = "test";
    private static final RegistrationContext FAKE_REGISTRATION_CONTEXT = WSRPTypeFactory.createRegistrationContext((String)"handle");

    protected void setUp() throws Exception {
        ProducerInfo pi = new ProducerInfo(null);
        this.info = pi.getRegistrationInfo();
    }

    public void testInitialState() {
        RegistrationInfoTestCase.assertTrue((boolean)this.info.getRegistrationProperties().isEmpty());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.getRegistrationPropertyNames().isEmpty());
        RegistrationInfoTestCase.assertNull((Object)this.info.getRegistrationContext());
        RegistrationInfoTestCase.assertNotNull((Object)this.info.getRegistrationData());
        RegistrationInfoTestCase.assertNull((Object)this.info.getRegistrationHandle());
        RegistrationInfoTestCase.assertNull((Object)this.info.getRegistrationState());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded());
        RegistrationInfoTestCase.assertNull((Object)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertNull((Object)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertNull((Object)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistered());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        try {
            this.info.isRegistrationDeterminedNotRequired();
            RegistrationInfoTestCase.fail((String)"refresh hasn't been called, isRegistrationDeterminedNotRequired should fail");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.info.isRegistrationDeterminedRequired();
            RegistrationInfoTestCase.fail((String)"refresh hasn't been called, isRegistrationDeterminedRequired should fail");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRegistration() {
        this.register();
        RegistrationInfoTestCase.assertEquals((String)FAKE_REGISTRATION_CONTEXT.getRegistrationHandle(), (String)this.info.getRegistrationHandle());
        RegistrationInfoTestCase.assertEquals((Object)FAKE_REGISTRATION_CONTEXT.getRegistrationState(), (Object)this.info.getRegistrationState());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistered());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationDeterminedNotRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationDeterminedRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isUndetermined());
    }

    public void testIsModifyRegistrationNeeded() {
        String key = "foo";
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistered());
        this.info.setRegistrationPropertyValue(key, "bar");
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        this.register();
        this.info.setRegistrationPropertyValue(key, "bar");
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        this.info.setRegistrationPropertyValue(key, "new");
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifyRegistrationNeeded());
    }

    private void register() {
        this.info.setRegistrationContext(FAKE_REGISTRATION_CONTEXT);
        this.info.setConsumerName(WSRPConstants.DEFAULT_CONSUMER_NAME);
    }

    public void testSimpleSetGetRegistrationProperty() {
        QName key = QName.valueOf("{urn:foo:ns}foo");
        this.info.setRegistrationPropertyValue(key, "bar");
        RegistrationInfoTestCase.assertNull((Object)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        Map properties = this.info.getRegistrationProperties();
        RegistrationInfoTestCase.assertFalse((boolean)properties.isEmpty());
        Set names = this.info.getRegistrationPropertyNames();
        RegistrationInfoTestCase.assertFalse((boolean)names.isEmpty());
        RegistrationInfoTestCase.assertTrue((boolean)properties.containsKey(key));
        RegistrationInfoTestCase.assertTrue((boolean)names.contains(key));
        Object prop = properties.get(key);
        RegistrationInfoTestCase.assertNotNull(prop);
        RegistrationProperty registrationProperty = this.info.getRegistrationProperty(key);
        RegistrationInfoTestCase.assertEquals(prop, (Object)registrationProperty);
        RegistrationInfoTestCase.assertEquals((String)"bar", (String)registrationProperty.getValue());
    }

    public void testRegistrationPropertiesAndRefresh() {
        this.info.setRegistrationPropertyValue("prop0", "value0");
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(this.createServiceDescription(true, 1), producerId, true, false, false);
        RegistrationProperty prop = this.info.getRegistrationProperty("prop0");
        RegistrationInfoTestCase.assertNull((Object)prop.isInvalid());
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isConsistentWithProducerExpectations());
        prop.setStatus(RegistrationProperty.Status.VALID);
        this.info.setRegistrationPropertyValue("prop0", "value1");
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded());
        RegistrationInfoTestCase.assertNull((String)"Property value has changed since last refresh, status should be unknown", (Object)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((String)"Property value has changed since last refresh, status should be unknown", (Object)RegistrationProperty.Status.UNCHECKED_VALUE, (Object)prop.getStatus());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifyRegistrationNeeded());
    }

    public void testRefreshNoRegistration() {
        ServiceDescription sd = this.createServiceDescription(false, 0);
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(sd, producerId, true, false, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationDeterminedNotRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationDeterminedRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        result = this.info.refresh(sd, producerId, false, false, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationDeterminedNotRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationDeterminedRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
    }

    public void testRefreshRegistrationDefaultRegistrationNoLocalInfo() {
        RegistrationInfoTestCase.assertNull((Object)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertNull((Object)this.info.isRegistrationValid());
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(this.createServiceDescription(true, 0), producerId, true, false, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationDeterminedRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationDeterminedNotRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
    }

    public void testRefreshRegistrationDefaultRegistrationExtraLocalInfo() {
        this.info.setRegistrationPropertyValue("foo", "bar");
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(this.createServiceDescription(true, 0), producerId, false, false, true);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertTrue((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertEquals((Object)RefreshResult.Status.FAILURE, (Object)result.getStatus());
        RegistrationInfoTestCase.assertEquals((int)1, (int)this.info.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertEquals((int)1, (int)result.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        this.checkProperties(result);
    }

    private void checkProperties(RegistrationInfo.RegistrationRefreshResult result) {
        Map regProps = result.getRegistrationProperties();
        RegistrationInfoTestCase.assertNotNull((Object)regProps);
        RegistrationProperty prop = (RegistrationProperty)regProps.get(QName.valueOf("foo"));
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertEquals((String)"bar", (String)prop.getValue());
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.INEXISTENT, (Object)prop.getStatus());
    }

    public void testRefreshRegistrationDefaultRegistrationExtraLocalInfoWhileRegistered() {
        this.register();
        this.info.setRegistrationPropertyValue("foo", "bar");
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(this.createServiceDescription(true, 0), producerId, false, false, true);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertEquals((Object)RefreshResult.Status.MODIFY_REGISTRATION_REQUIRED, (Object)result.getStatus());
        RegistrationInfoTestCase.assertTrue((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertEquals((int)1, (int)this.info.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertEquals((int)1, (int)result.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifyRegistrationNeeded());
        this.checkProperties(result);
    }

    public void testRefreshRegistrationRegistrationNoLocalInfo() {
        ServiceDescription sd = this.createServiceDescription(true, 2);
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(sd, producerId, false, false, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertTrue((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertEquals((Object)RefreshResult.Status.FAILURE, (Object)result.getStatus());
        RegistrationInfoTestCase.assertEquals((int)0, (int)this.info.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertEquals((int)2, (int)result.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        Map regProps = result.getRegistrationProperties();
        RegistrationInfoTestCase.assertNotNull((Object)regProps);
        RegistrationProperty prop = (RegistrationProperty)regProps.get(QName.valueOf("prop0"));
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING, (Object)prop.getStatus());
        prop = (RegistrationProperty)regProps.get(QName.valueOf("prop1"));
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING, (Object)prop.getStatus());
    }

    public void testRefreshRegistrationRegistrationNoLocalInfoWhileRegistered() {
        this.register();
        ServiceDescription sd = this.createServiceDescription(true, 2);
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(sd, producerId, false, true, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertTrue((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertEquals((Object)RefreshResult.Status.MODIFY_REGISTRATION_REQUIRED, (Object)result.getStatus());
        RegistrationInfoTestCase.assertEquals((int)0, (int)this.info.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertEquals((int)2, (int)result.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifyRegistrationNeeded());
        Map regProps = result.getRegistrationProperties();
        RegistrationInfoTestCase.assertNotNull((Object)regProps);
        RegistrationProperty prop = (RegistrationProperty)regProps.get(QName.valueOf("prop0"));
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING, (Object)prop.getStatus());
        prop = (RegistrationProperty)regProps.get(QName.valueOf("prop1"));
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING, (Object)prop.getStatus());
    }

    public void testRefreshRegistrationRegistrationMergeWithLocalInfo() {
        this.info.setRegistrationPropertyValue("foo", "bar");
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(this.createServiceDescription(true, 2), producerId, true, false, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertTrue((boolean)result.hasIssues());
        RegistrationProperty prop = this.info.getRegistrationProperty("prop0");
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertNull((Object)prop.getValue());
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING_VALUE, (Object)prop.getStatus());
        prop = this.info.getRegistrationProperty("prop1");
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertNull((Object)prop.getValue());
        RegistrationInfoTestCase.assertTrue((boolean)prop.isInvalid());
        RegistrationInfoTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING_VALUE, (Object)prop.getStatus());
        RegistrationInfoTestCase.assertEquals((int)2, (int)this.info.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertEquals((int)2, (int)result.getRegistrationProperties().size());
        RegistrationInfoTestCase.assertNull((Object)this.info.getRegistrationProperty("foo"));
    }

    public void testForceRefreshRegistration() {
        RegistrationInfo.RegistrationRefreshResult result = this.info.refresh(this.createServiceDescription(true, 0), producerId, false, false, false);
        RegistrationInfoTestCase.assertNotNull((Object)result);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
        this.info.setRegistrationPropertyValue("foo", "bar");
        result = this.info.refresh(this.createServiceDescription(true, 0), producerId, false, false, false);
        RegistrationInfoTestCase.assertTrue((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
        this.info.removeRegistrationProperty("foo");
        result = this.info.refresh(this.createServiceDescription(true, 0), producerId, false, false, false);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
        result = this.info.refresh(this.createServiceDescription(false, 0), producerId, false, false, false);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
        result = this.info.refresh(this.createServiceDescription(false, 0), producerId, false, true, false);
        RegistrationInfoTestCase.assertFalse((boolean)result.hasIssues());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
    }

    public void testSetRegistrationContext() {
        RegistrationInfoTestCase.assertNull((Object)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertNull((Object)this.info.getRegistrationHandle());
        String registrationHandle = "registrationHandle";
        this.info.setRegistrationContext(WSRPTypeFactory.createRegistrationContext((String)registrationHandle));
        RegistrationContext registrationContext = this.info.getRegistrationContext();
        RegistrationInfoTestCase.assertNotNull((Object)registrationContext);
        RegistrationInfoTestCase.assertEquals((String)registrationHandle, (String)registrationContext.getRegistrationHandle());
        RegistrationInfoTestCase.assertNull((Object)registrationContext.getRegistrationState());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationDeterminedRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationDeterminedNotRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
    }

    public void testGetRegistrationData() {
        RegistrationInfoTestCase.assertNotNull((Object)this.info.getRegistrationData());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        this.info.setRegistrationPropertyValue("prop0", "value0");
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        RegistrationData registrationData = this.info.getRegistrationData();
        this.checkRegistrationData(registrationData, "value0");
        this.info.setRegistrationPropertyValue("prop0", "value1");
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        this.register();
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationNeeded());
        List properties = this.info.getRegistrationData().getRegistrationProperties();
        RegistrationInfoTestCase.assertEquals((String)"value1", (String)((Property)properties.get(0)).getStringValue());
    }

    public void testGetRegistrationDataWithInitialWrongValue() {
        this.info.setRegistrationPropertyValue("prop0", "incorrect");
        this.info.refresh(this.createServiceDescription(true, 1), producerId, true, true, false);
        this.checkRegistrationData(this.info.getRegistrationData(), "incorrect");
        this.info.setRegistrationPropertyValue("prop0", "value0");
        RegistrationInfo.RegistrationRefreshResult res = this.info.refresh(this.createServiceDescription(true, 1), producerId, true, true, false);
        RegistrationInfoTestCase.assertFalse((boolean)res.hasIssues());
        this.checkRegistrationData(this.info.getRegistrationData(), "value0");
    }

    public void testRefreshWhileRegisteredAndProducerNotSendingPropertyDescriptions() {
        this.info.setRegistrationPropertyValue("prop0", "value0");
        this.info.refresh(this.createServiceDescription(true, 1), producerId, true, true, false);
        this.info.setRegistrationContext(FAKE_REGISTRATION_CONTEXT);
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        ServiceDescription description = this.createServiceDescription(true, 0);
        this.info.refresh(description, producerId, true, true, false);
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        RegistrationProperty prop = this.info.getRegistrationProperty("prop0");
        RegistrationInfoTestCase.assertNotNull((Object)prop);
        RegistrationInfoTestCase.assertFalse((boolean)prop.isInvalid());
        this.info.refresh(description, producerId, true, true, true);
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertNull((Object)this.info.getRegistrationProperty("prop0"));
    }

    public void testRefreshRegisteredWithoutPropsAndProducerNowSendsProps() {
        this.info.setRegistrationContext(FAKE_REGISTRATION_CONTEXT);
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationValid());
        this.info.refresh(this.createServiceDescription(true, 1), producerId, true, true, true);
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        RegistrationInfoTestCase.assertTrue((boolean)this.info.isRegistrationDeterminedRequired());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isRegistrationValid());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isConsistentWithProducerExpectations());
        RegistrationInfoTestCase.assertFalse((boolean)this.info.isModifiedSinceLastRefresh());
    }

    private void checkRegistrationData(RegistrationData registrationData, String prop0Value) {
        RegistrationInfoTestCase.assertNotNull((Object)registrationData);
        List properties = registrationData.getRegistrationProperties();
        RegistrationInfoTestCase.assertNotNull((Object)properties);
        RegistrationInfoTestCase.assertEquals((int)1, (int)properties.size());
        Property property = (Property)properties.get(0);
        RegistrationInfoTestCase.assertEquals((String)"prop0", (String)property.getName().toString());
        RegistrationInfoTestCase.assertEquals((String)prop0Value, (String)property.getStringValue());
    }

    private ServiceDescription createServiceDescription(boolean requiresRegistration, int numberOfProperties) {
        return ServiceDescriptionBehavior.createServiceDescription(requiresRegistration, numberOfProperties);
    }
}

