/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;
import org.gatein.wsrp.consumer.registry.InMemoryConsumerRegistry;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerRegistryTestCase
extends TestCase {
    protected AbstractConsumerRegistry registry;

    protected void setUp() throws Exception {
        this.registry = new InMemoryConsumerRegistry();
    }

    public void testCreateAndGet() {
        String id = "test";
        WSRPConsumer consumer = this.registry.createConsumer(id, null, null);
        ConsumerRegistryTestCase.assertNotNull((Object)consumer);
        ConsumerRegistryTestCase.assertEquals((String)id, (String)consumer.getProducerId());
        ProducerInfo info = consumer.getProducerInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)info);
        ConsumerRegistryTestCase.assertNotNull((Object)info.getKey());
        ConsumerRegistryTestCase.assertEquals((String)consumer.getProducerId(), (String)info.getId());
        EndpointConfigurationInfo endpoint = info.getEndpointConfigurationInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)endpoint);
        RegistrationInfo regInfo = info.getRegistrationInfo();
        ConsumerRegistryTestCase.assertTrue((boolean)regInfo.isUndetermined());
        ConsumerRegistryTestCase.assertEquals((Object)this.registry, (Object)info.getRegistry());
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(id));
        WSRPConsumer fromRegistry = this.registry.getConsumer(id);
        ConsumerRegistryTestCase.assertNotNull((Object)fromRegistry);
        ConsumerRegistryTestCase.assertEquals((String)consumer.getProducerId(), (String)fromRegistry.getProducerId());
        ProducerInfo fromRegistryInfo = fromRegistry.getProducerInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)fromRegistryInfo);
        ConsumerRegistryTestCase.assertEquals((String)fromRegistry.getProducerId(), (String)fromRegistryInfo.getId());
        ConsumerRegistryTestCase.assertNotNull((Object)fromRegistryInfo.getEndpointConfigurationInfo());
        ConsumerRegistryTestCase.assertTrue((boolean)fromRegistryInfo.getRegistrationInfo().isUndetermined());
        ConsumerRegistryTestCase.assertEquals((Object)this.registry, (Object)fromRegistryInfo.getRegistry());
        ConsumerRegistryTestCase.assertEquals((String)info.getId(), (String)fromRegistryInfo.getId());
        ConsumerRegistryTestCase.assertEquals((Object)info.getEndpointConfigurationInfo(), (Object)fromRegistryInfo.getEndpointConfigurationInfo());
        ConsumerRegistryTestCase.assertEquals((Object)info.getRegistrationInfo(), (Object)fromRegistryInfo.getRegistrationInfo());
        List consumers = this.registry.getConfiguredConsumers();
        ConsumerRegistryTestCase.assertNotNull((Object)consumers);
        ConsumerRegistryTestCase.assertEquals((int)1, (int)consumers.size());
        ConsumerRegistryTestCase.assertTrue((boolean)consumers.contains(consumer));
        Collection ids = this.registry.getConfiguredConsumersIds();
        ConsumerRegistryTestCase.assertNotNull((Object)ids);
        ConsumerRegistryTestCase.assertEquals((int)1, (int)ids.size());
        ConsumerRegistryTestCase.assertTrue((boolean)ids.contains(id));
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
    }

    public void testGetConsumer() {
        ConsumerRegistryTestCase.assertNull((Object)this.registry.getConsumer("inexistent"));
    }

    public void testDoubleRegistrationOfConsumerWithSameId() {
        String id = "foo";
        this.registry.createConsumer(id, null, null);
        try {
            this.registry.createConsumer(id, null, null);
            ConsumerRegistryTestCase.fail((String)"Shouldn't be possible to create a consumer with an existing id");
        }
        catch (ConsumerException consumerException) {
            // empty catch block
        }
    }

    public void testDelete() {
        String id = "id";
        WSRPConsumer consumer = this.registry.createConsumer(id, null, null);
        ConsumerRegistryTestCase.assertEquals((Object)consumer, (Object)this.registry.getConsumer(id));
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(id));
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
        this.registry.destroyConsumer(id);
        ConsumerRegistryTestCase.assertFalse((boolean)this.registry.containsConsumer(id));
        ConsumerRegistryTestCase.assertNull((Object)this.registry.getConsumer(id));
        ConsumerRegistryTestCase.assertEquals((int)0, (int)this.registry.getConfiguredConsumerNumber());
    }

    public void testUpdateProducerInfo() {
        String id = "foo";
        WSRPConsumer consumer = this.registry.createConsumer(id, null, null);
        ProducerInfo info = consumer.getProducerInfo();
        String previousId = this.registry.updateProducerInfo(info);
        ConsumerRegistryTestCase.assertNull((Object)previousId);
        info.setId("bar");
        previousId = this.registry.updateProducerInfo(info);
        ConsumerRegistryTestCase.assertEquals((String)"foo", (String)previousId);
        ConsumerRegistryTestCase.assertNull((Object)this.registry.getConsumer(id));
        ConsumerRegistryTestCase.assertFalse((boolean)this.registry.containsConsumer(id));
        ConsumerRegistryTestCase.assertEquals((Object)info, (Object)consumer.getProducerInfo());
        ConsumerRegistryTestCase.assertEquals((Object)consumer, (Object)this.registry.getConsumer("bar"));
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("bar"));
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
    }

    public void testStoppingShouldNotStartConsumers() throws Exception {
        ProducerInfo info = (ProducerInfo)Mockito.mock(ProducerInfo.class);
        Mockito.stub((Object)info.isActive()).toReturn((Object)true);
        Mockito.stub((Object)info.getId()).toReturn((Object)"foo");
        Mockito.stub((Object)info.getKey()).toReturn((Object)"fooKey");
        EndpointConfigurationInfo endpoint = (EndpointConfigurationInfo)Mockito.mock(EndpointConfigurationInfo.class);
        Mockito.stub((Object)info.getEndpointConfigurationInfo()).toReturn((Object)endpoint);
        this.registry.save(info, "Couldn't save ProducerInfo");
        WSRPConsumer original = this.registry.createConsumerFrom(info, true);
        ConsumerRegistryTestCase.assertEquals((Object)original, (Object)this.registry.getFederatingPortletInvoker().getFederatedInvoker("foo").getPortletInvoker());
        WSRPConsumer consumer = (WSRPConsumer)Mockito.spy((Object)original);
        AbstractConsumerRegistry registrySpy = (AbstractConsumerRegistry)Mockito.spy((Object)this.registry);
        ((AbstractConsumerRegistry)Mockito.doReturn((Object)consumer).when((Object)registrySpy)).getConsumer("foo");
        ((AbstractConsumerRegistry)Mockito.doReturn(Collections.singletonList(consumer)).when((Object)registrySpy)).getConsumers(false);
        WSRPConsumer foo = registrySpy.getConsumer("foo");
        ConsumerRegistryTestCase.assertTrue((boolean)foo.getProducerInfo().isActive());
        ConsumerRegistryTestCase.assertEquals((Object)consumer, (Object)foo);
        consumer.stop();
        registrySpy.stop();
        ((WSRPConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).start();
        ConsumerRegistryTestCase.assertEquals(null, (Object)registrySpy.getFederatingPortletInvoker().getFederatedInvoker("foo"));
    }

    public void testReloadConsumers() {
        WSRPConsumer consumer1 = this.registry.createConsumer("consumer1", null, null);
        WSRPConsumer consumer2 = this.registry.createConsumer("consumer2", null, null);
        ConsumerRegistryTestCase.assertEquals((int)2, (int)this.registry.getConfiguredConsumersIds().size());
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer(consumer1.getProducerId()));
        ConsumerRegistryTestCase.assertEquals((Object)consumer2, (Object)this.registry.getConsumer(consumer2.getProducerId()));
        this.registry.reloadConsumers();
        ConsumerRegistryTestCase.assertEquals((int)2, (int)this.registry.getConfiguredConsumersIds().size());
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer(consumer1.getProducerId()));
        ConsumerRegistryTestCase.assertEquals((Object)consumer2, (Object)this.registry.getConsumer(consumer2.getProducerId()));
    }

    public void testCacheSimple() {
        WSRPConsumer consumer1 = this.registry.createConsumer("consumer1", null, null);
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(consumer1.getProducerId()));
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.consumerCache.getConsumer(consumer1.getProducerId()));
        ProducerInfo info = consumer1.getProducerInfo();
        info.setId("foo");
        this.registry.updateProducerInfo(info);
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer("foo"));
        this.registry.destroyConsumer("foo");
        ConsumerRegistryTestCase.assertFalse((boolean)this.registry.containsConsumer("foo"));
    }

    public void testCacheModifyingProducerInfo() {
        WSRPConsumer consumer1 = this.registry.createConsumer("consumer1", null, null);
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(consumer1.getProducerId()));
        ProducerInfo info = consumer1.getProducerInfo();
        info.setId("foo");
        this.registry.update(info);
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer("foo"));
    }
}

