/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.services;

import java.net.URL;
import javax.wsdl.WSDLException;
import junit.framework.TestCase;
import org.gatein.wsrp.services.SOAPServiceFactory;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.oasis.wsrp.v2.WSRPV2MarkupPortType;
import org.oasis.wsrp.v2.WSRPV2PortletManagementPortType;
import org.oasis.wsrp.v2.WSRPV2RegistrationPortType;
import org.oasis.wsrp.v2.WSRPV2ServiceDescriptionPortType;

public class SOAPServiceFactoryTestCase
extends TestCase {
    private SOAPServiceFactory factory;
    public static final Class[] WSRP2_PORT_TYPES = new Class[]{WSRPV2MarkupPortType.class, WSRPV2ServiceDescriptionPortType.class, WSRPV2PortletManagementPortType.class, WSRPV2RegistrationPortType.class};
    public static final Class[] WSRP1_PORT_TYPES = new Class[]{WSRPV1MarkupPortType.class, WSRPV1ServiceDescriptionPortType.class, WSRPV1PortletManagementPortType.class, WSRPV1RegistrationPortType.class};

    protected void setUp() throws Exception {
        this.factory = new SOAPServiceFactory();
    }

    private String getWSDLURL(String fileName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        return url.toExternalForm();
    }

    public void testMissingMandatoryPort() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/missing-mandatory.wsdl"));
        try {
            this.checkPorts(WSRP2_PORT_TYPES);
            SOAPServiceFactoryTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testV2ServiceWithExtraPorts() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/extra-ports.wsdl"));
        this.checkPorts(WSRP2_PORT_TYPES);
    }

    public void testWebsphere() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/missing-registration-non-std-ns.wsdl"));
        this.checkPorts(WSRPV2MarkupPortType.class, WSRPV2ServiceDescriptionPortType.class, WSRPV2PortletManagementPortType.class);
    }

    public void testSimpleV2Service() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/simplev2.wsdl"));
        this.checkPorts(WSRP2_PORT_TYPES);
    }

    public void testSimpleV1Service() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/simplev1.wsdl"));
        this.checkPorts(WSRP1_PORT_TYPES);
    }

    public void testBothServices() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/both-services.wsdl"));
        this.checkPorts(WSRP2_PORT_TYPES);
    }

    public void testDefaultDotNetWSDLCompositeService() throws Exception {
        this.factory.setWsdlDefinitionURL(this.getWSDLURL("wsdl/dot-net-composite.wsdl"));
        try {
            this.checkPorts(WSRP2_PORT_TYPES);
            SOAPServiceFactoryTestCase.fail();
        }
        catch (Exception e) {
            SOAPServiceFactoryTestCase.assertTrue((boolean)(e instanceof WSDLException));
            WSDLException wsdlEx = (WSDLException)e;
            SOAPServiceFactoryTestCase.assertEquals((String)"OTHER_ERROR", (String)wsdlEx.getFaultCode());
        }
    }

    private void checkPorts(Class ... ports) throws Exception {
        for (Class portClass : ports) {
            SOAPServiceFactoryTestCase.assertNotNull((Object)this.factory.getService(portClass));
        }
    }
}

