/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.protocol.v1.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v1.TestProducerBehavior;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1InvalidCookie;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidSession;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MarkupContext;
import org.oasis.wsrp.v1.V1MarkupParams;
import org.oasis.wsrp.v1.V1MarkupResponse;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1PortletStateChangeRequired;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1SessionContext;
import org.oasis.wsrp.v1.V1UnsupportedLocale;
import org.oasis.wsrp.v1.V1UnsupportedMimeType;
import org.oasis.wsrp.v1.V1UnsupportedMode;
import org.oasis.wsrp.v1.V1UnsupportedWindowState;
import org.oasis.wsrp.v1.V1UpdateResponse;
import org.oasis.wsrp.v1.V1UserContext;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;

public abstract class MarkupBehavior
extends TestProducerBehavior
implements WSRPV1MarkupPortType {
    private List<String> handles = new ArrayList<String>(3);
    private BehaviorRegistry registry;

    protected MarkupBehavior(BehaviorRegistry registry) {
        this.registry = registry;
    }

    protected abstract String getMarkupString(Mode var1, WindowState var2, String var3, V1GetMarkup var4) throws V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1UnsupportedLocale, V1UnsupportedMode, V1OperationFailed, V1MissingParameters, V1InvalidUserCategory, V1InvalidRegistration, V1UnsupportedMimeType;

    public void modifyResponseIfNeeded(V1MarkupResponse markupResponse) {
    }

    public List<String> getSupportedHandles() {
        return this.handles;
    }

    public V1PortletDescription getPortletDescriptionFor(String handle) {
        if (this.handles.contains(handle)) {
            return this.createPortletDescription(handle, this.getSuffixFor(handle));
        }
        throw new IllegalArgumentException("MarkupBehavior " + this.getClass().getName() + " is not associated with handle '" + handle + "'");
    }

    protected String getSuffixFor(String handle) {
        return "";
    }

    protected void registerHandle(String handle) {
        this.handles.add(handle);
        V1PortletDescription portletDescription = this.createPortletDescription(handle, this.getSuffixFor(handle));
        this.registry.getServiceDescriptionBehavior().addPortletDescription(portletDescription);
    }

    public void performBlockingInteraction(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1MarkupParams markupParams, @WebParam(name="interactionParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1InteractionParams interactionParams, @WebParam(mode=WebParam.Mode.OUT, name="updateResponse", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1UpdateResponse> updateResponse, @WebParam(mode=WebParam.Mode.OUT, name="redirectURL", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> redirectURL, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1MissingParameters, V1UnsupportedLocale, V1InconsistentParameters, V1PortletStateChangeRequired, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
    }

    public List<V1Extension> releaseSessions(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="sessionIDs", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> sessionIDs) throws V1MissingParameters, V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        return null;
    }

    public void getMarkup(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1MarkupParams markupParams, @WebParam(mode=WebParam.Mode.OUT, name="markupContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1MarkupContext> markupContext, @WebParam(mode=WebParam.Mode.OUT, name="sessionContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1SessionContext> sessionContext, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1MissingParameters, V1UnsupportedLocale, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        V1GetMarkup gm = new V1GetMarkup();
        gm.setMarkupParams(markupParams);
        gm.setPortletContext(portletContext);
        gm.setRegistrationContext(registrationContext);
        gm.setRuntimeContext(runtimeContext);
        gm.setUserContext(userContext);
        String markupString = this.getMarkupString(WSRPUtils.getJSR168PortletModeFromWSRPName((String)markupParams.getMode()), WSRPUtils.getJSR168WindowStateFromWSRPName((String)markupParams.getWindowState()), markupParams.getNavigationalState(), gm);
        markupContext.value = WSRP1TypeFactory.createMarkupContext((String)MediaType.TEXT_HTML.getValue(), (String)markupString, null, null);
        ((V1MarkupContext)markupContext.value).setRequiresUrlRewriting(Boolean.TRUE);
        V1MarkupResponse markupResponse = WSRP1TypeFactory.createMarkupResponse((V1MarkupContext)((V1MarkupContext)markupContext.value));
        this.modifyResponseIfNeeded(markupResponse);
        sessionContext.value = markupResponse.getSessionContext();
    }

    public List<V1Extension> initCookie(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext) throws V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        return null;
    }
}

