/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1;

import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.net.media.MediaType;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.oasis.wsrp.v1.V1LocalizedString;
import org.oasis.wsrp.v1.V1MarkupType;
import org.oasis.wsrp.v1.V1PortletDescription;

public abstract class TestProducerBehavior {
    protected int callCount;
    public static final String SAMPLE_DESCRIPTION = "SampleDescription";
    public static final String SAMPLE_SHORTTITLE = "SampleShortTitle";
    public static final String SAMPLE_TITLE = "SampleTitle";
    public static final String SAMPLE_DISPLAYNAME = "SampleDisplayName";
    public static final String SAMPLE_KEYWORD = "keyword";

    public void incrementCallCount() {
        ++this.callCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public V1PortletDescription createPortletDescription(String portletHandle, String suffix) {
        V1PortletDescription portletDesc = new V1PortletDescription();
        portletDesc.setPortletHandle(portletHandle);
        V1MarkupType markupType = new V1MarkupType();
        markupType.setMimeType(MediaType.TEXT_HTML.getValue());
        markupType.getModes().add("wsrp:view");
        markupType.getWindowStates().add("wsrp:normal");
        markupType.getLocales().addAll(WSRPConstants.getDefaultLocales());
        portletDesc.getMarkupTypes().add(markupType);
        String suffixString = suffix == null ? "" : suffix;
        portletDesc.setDescription(TestProducerBehavior.createLocalizedString(SAMPLE_DESCRIPTION + suffixString));
        portletDesc.setTitle(TestProducerBehavior.createLocalizedString(SAMPLE_TITLE + suffixString));
        portletDesc.setShortTitle(TestProducerBehavior.createLocalizedString(SAMPLE_SHORTTITLE + suffixString));
        portletDesc.setDisplayName(TestProducerBehavior.createLocalizedString(SAMPLE_DISPLAYNAME + suffixString));
        portletDesc.getKeywords().add(TestProducerBehavior.createLocalizedString(SAMPLE_KEYWORD + suffixString));
        return portletDesc;
    }

    public static V1LocalizedString createLocalizedString(String value) {
        return WSRP1TypeFactory.createLocalizedString((String)value);
    }

    public static String extractString(LocalizedString ls) {
        return ls.getPreferredOrBestLocalizedMappingFor(new String[]{"en"}).getString();
    }
}

