/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1;

import java.util.List;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.gatein.wsrp.test.protocol.v1.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v1.MarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.PortletManagementBehavior;
import org.gatein.wsrp.test.protocol.v1.ServiceDescriptionBehavior;
import org.gatein.wsrp.test.protocol.v1.TestWSRPProducer;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1CookieProtocol;
import org.oasis.wsrp.v1.V1DestroyFailed;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1InvalidCookie;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidSession;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1ItemDescription;
import org.oasis.wsrp.v1.V1MarkupContext;
import org.oasis.wsrp.v1.V1MarkupParams;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1PortletStateChangeRequired;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1PropertyList;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RegistrationData;
import org.oasis.wsrp.v1.V1ResetProperty;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1SessionContext;
import org.oasis.wsrp.v1.V1UnsupportedLocale;
import org.oasis.wsrp.v1.V1UnsupportedMimeType;
import org.oasis.wsrp.v1.V1UnsupportedMode;
import org.oasis.wsrp.v1.V1UnsupportedWindowState;
import org.oasis.wsrp.v1.V1UpdateResponse;
import org.oasis.wsrp.v1.V1UserContext;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;

public class TestWSRPProducerImpl
implements TestWSRPProducer,
WSRPV1MarkupPortType,
WSRPV1PortletManagementPortType,
WSRPV1RegistrationPortType,
WSRPV1ServiceDescriptionPortType {
    private int sessionExpirationTime = 600;
    private V1CookieProtocol requiresInitCookie = V1CookieProtocol.NONE;
    private BehaviorRegistry behaviorRegistry = new BehaviorRegistry();
    public static final String USER_COOKIE = "cookie";
    private String currentMarkupBehaviorHandle;
    private boolean strict = true;

    public TestWSRPProducerImpl() {
        this.reset();
    }

    @Override
    public BehaviorRegistry getBehaviorRegistry() {
        return this.behaviorRegistry;
    }

    @Override
    public void setCurrentMarkupBehaviorHandle(String handle) {
        this.currentMarkupBehaviorHandle = handle;
    }

    @Override
    public void reset() {
        this.requiresInitCookie = null;
        this.currentMarkupBehaviorHandle = null;
        this.behaviorRegistry.clear();
    }

    private MarkupBehavior getMarkupBehaviorFor(String portletHandle) throws V1InvalidHandle {
        return this.behaviorRegistry.getMarkupBehaviorFor(portletHandle);
    }

    private ServiceDescriptionBehavior getServiceDescriptionBehavior() {
        return this.behaviorRegistry.getServiceDescriptionBehavior();
    }

    public PortletManagementBehavior getPortletManagementBehavior() {
        return this.behaviorRegistry.getPortletManagementBehavior();
    }

    public void getServiceDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="requiresRegistration", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<Boolean> requiresRegistration, @WebParam(mode=WebParam.Mode.OUT, name="offeredPortlets", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1PortletDescription>> offeredPortlets, @WebParam(mode=WebParam.Mode.OUT, name="userCategoryDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> userCategoryDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customUserProfileItemDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customUserProfileItemDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customWindowStateDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customWindowStateDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customModeDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customModeDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="requiresInitCookie", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1CookieProtocol> requiresInitCookie, @WebParam(mode=WebParam.Mode.OUT, name="registrationPropertyDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ModelDescription> registrationPropertyDescription, @WebParam(mode=WebParam.Mode.OUT, name="locales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<String>> locales, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1InvalidRegistration, V1OperationFailed {
        this.getServiceDescriptionBehavior().getServiceDescription(registrationContext, desiredLocales, requiresRegistration, offeredPortlets, userCategoryDescriptions, customUserProfileItemDescriptions, customWindowStateDescriptions, customModeDescriptions, requiresInitCookie, registrationPropertyDescription, locales, resourceList, extensions);
    }

    public void performBlockingInteraction(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1MarkupParams markupParams, @WebParam(name="interactionParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1InteractionParams interactionParams, @WebParam(mode=WebParam.Mode.OUT, name="updateResponse", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1UpdateResponse> updateResponse, @WebParam(mode=WebParam.Mode.OUT, name="redirectURL", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> redirectURL, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1MissingParameters, V1UnsupportedLocale, V1InconsistentParameters, V1PortletStateChangeRequired, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getMarkupBehaviorFor(portletContext.getPortletHandle()).performBlockingInteraction(registrationContext, portletContext, runtimeContext, userContext, markupParams, interactionParams, updateResponse, redirectURL, extensions);
    }

    public List<V1Extension> releaseSessions(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="sessionIDs", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> sessionIDs) throws V1MissingParameters, V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        return null;
    }

    public void getMarkup(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1MarkupParams markupParams, @WebParam(mode=WebParam.Mode.OUT, name="markupContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1MarkupContext> markupContext, @WebParam(mode=WebParam.Mode.OUT, name="sessionContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1SessionContext> sessionContext, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1MissingParameters, V1UnsupportedLocale, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getMarkupBehaviorFor(portletContext.getPortletHandle()).getMarkup(registrationContext, portletContext, runtimeContext, userContext, markupParams, markupContext, sessionContext, extensions);
    }

    public List<V1Extension> initCookie(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext) throws V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        if (this.requiresInitCookie == null || V1CookieProtocol.NONE.equals((Object)this.requiresInitCookie)) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.throwWSException(V1OperationFailed.class, (String)"Shouldn't have called initCookie", null);
        }
        try {
            return this.getMarkupBehaviorFor(this.currentMarkupBehaviorHandle).initCookie(registrationContext);
        }
        catch (V1InvalidHandle invalidHandle) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.throwWSException(V1OperationFailed.class, (String)"Invalid handle", (Throwable)invalidHandle);
        }
    }

    public void register(@WebParam(name="consumerName", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") String consumerName, @WebParam(name="consumerAgent", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") String consumerAgent, @WebParam(name="methodGetSupported", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") boolean methodGetSupported, @WebParam(name="consumerModes", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> consumerModes, @WebParam(name="consumerWindowStates", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> consumerWindowStates, @WebParam(name="consumerUserScopes", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> consumerUserScopes, @WebParam(name="customUserProfileData", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> customUserProfileData, @WebParam(name="registrationProperties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<V1Property> registrationProperties, @WebParam(mode=WebParam.Mode.INOUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions, @WebParam(mode=WebParam.Mode.OUT, name="registrationHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> registrationHandle, @WebParam(mode=WebParam.Mode.OUT, name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> registrationState) throws V1MissingParameters, V1OperationFailed {
        registrationHandle.value = "registration";
    }

    public void modifyRegistration(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="registrationData", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationData registrationData, @WebParam(mode=WebParam.Mode.OUT, name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> registrationState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InvalidRegistration, V1OperationFailed {
    }

    public void deregister(@WebParam(name="registrationHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") String registrationHandle, @WebParam(name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") byte[] registrationState, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types", mode=WebParam.Mode.INOUT) Holder<List<V1Extension>> extensions) throws V1InvalidRegistration, V1OperationFailed {
    }

    public void getPortletPropertyDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="modelDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ModelDescription> modelDescription, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getPortletManagementBehavior().getPortletPropertyDescription(registrationContext, portletContext, userContext, desiredLocales, modelDescription, resourceList, extensions);
    }

    public void setPortletProperties(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="propertyList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PropertyList propertyList, @WebParam(mode=WebParam.Mode.OUT, name="portletHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> portletHandle, @WebParam(mode=WebParam.Mode.OUT, name="portletState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> portletState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getPortletManagementBehavior().setPortletProperties(registrationContext, portletContext, userContext, propertyList, portletHandle, portletState, extensions);
    }

    public void clonePortlet(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(mode=WebParam.Mode.OUT, name="portletHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> portletHandle, @WebParam(mode=WebParam.Mode.OUT, name="portletState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> portletState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getPortletManagementBehavior().clonePortlet(registrationContext, portletContext, userContext, portletHandle, portletState, extensions);
    }

    public void getPortletDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="portletDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1PortletDescription> portletDescription, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getPortletManagementBehavior().getPortletDescription(registrationContext, portletContext, userContext, desiredLocales, portletDescription, resourceList, extensions);
    }

    public void getPortletProperties(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="names", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> names, @WebParam(mode=WebParam.Mode.OUT, name="properties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Property>> properties, @WebParam(mode=WebParam.Mode.OUT, name="resetProperties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ResetProperty>> resetProperties, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        this.getPortletManagementBehavior().getPortletProperties(registrationContext, portletContext, userContext, names, properties, resetProperties, extensions);
    }

    public void destroyPortlets(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletHandles", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> portletHandles, @WebParam(mode=WebParam.Mode.OUT, name="destroyFailed", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1DestroyFailed>> destroyFailed, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidRegistration, V1OperationFailed {
        this.getPortletManagementBehavior().destroyPortlets(registrationContext, portletHandles, destroyFailed, extensions);
    }

    public V1CookieProtocol getRequiresInitCookie() {
        return this.requiresInitCookie;
    }

    @Override
    public void setRequiresInitCookie(String cookieProtocolAsString) {
        V1CookieProtocol protocol;
        this.requiresInitCookie = protocol = V1CookieProtocol.fromValue((String)cookieProtocolAsString);
        this.getServiceDescriptionBehavior().setRequiresInitCookie(this.requiresInitCookie);
    }

    public int getSessionExpirationTime() {
        return this.sessionExpirationTime;
    }

    public void setSessionExpirationTime(int sessionExpirationTime) {
        this.sessionExpirationTime = sessionExpirationTime;
    }

    @Override
    public void usingStrictModeChangedTo(boolean strictMode) {
        this.strict = strictMode;
    }
}

