/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.api.session.SessionEventBroadcaster;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.handlers.session.InMemorySessionRegistry;
import org.gatein.wsrp.consumer.handlers.session.SessionRegistry;
import org.gatein.wsrp.consumer.migration.InMemoryMigrationService;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.gatein.wsrp.test.support.MockWSRPConsumer;

public class MockConsumerRegistry
implements ConsumerRegistrySPI {
    private Map<String, WSRPConsumer> consumers = new HashMap<String, WSRPConsumer>(3);
    public static final String MOCK_SERVICE_DESCRIPTION = "mock-service-description";
    public static final String MOCK_MARKUP = "mock-markup";
    public static final String CONSUMER1 = "inDB";
    public static final String CONSUMER2 = "inDB2";
    private InMemorySessionRegistry sessionRegistry = new InMemorySessionRegistry();
    private InMemoryMigrationService migrationService = new InMemoryMigrationService();

    public MockConsumerRegistry() {
        this.reloadConsumers();
    }

    public List<WSRPConsumer> getConfiguredConsumers() {
        return new ArrayList<WSRPConsumer>(this.consumers.values());
    }

    public WSRPConsumer getConsumer(String id) {
        return this.consumers.get(id);
    }

    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return null;
    }

    public WSRPConsumer createConsumer(String id, Integer expirationCacheSeconds, String wsdlURL) {
        MockWSRPConsumer consumer = new MockWSRPConsumer(id);
        ProducerInfo producerInfo = consumer.getProducerInfo();
        producerInfo.setExpirationCacheSeconds(expirationCacheSeconds);
        producerInfo.getEndpointConfigurationInfo().setWsdlDefinitionURL(wsdlURL);
        this.consumers.put(id, (WSRPConsumer)consumer);
        return consumer;
    }

    public void persistConsumer(WSRPConsumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"WSRPConsumer");
        this.consumers.put(consumer.getProducerId(), consumer);
    }

    public void activateConsumerWith(String id) throws ConsumerException {
    }

    public String updateProducerInfo(ProducerInfo producerInfo) {
        return null;
    }

    public void deactivateConsumerWith(String id) throws ConsumerException {
    }

    public void registerOrDeregisterConsumerWith(String id, boolean register) {
    }

    public void destroyConsumer(String id) {
    }

    public void reloadConsumers() {
        this.consumers.clear();
        this.consumers.put(CONSUMER1, (WSRPConsumer)new MockWSRPConsumer(CONSUMER1));
        MockWSRPConsumer consumer = new MockWSRPConsumer(CONSUMER2);
        consumer.getProducerInfo().setActive(true);
        EndpointConfigurationInfo info = consumer.getProducerInfo().getEndpointConfigurationInfo();
        this.consumers.put(CONSUMER2, (WSRPConsumer)consumer);
    }

    public void start() throws Exception {
        this.reloadConsumers();
    }

    public void stop() throws Exception {
    }

    public void save(ProducerInfo info, String messageOnError) throws ConsumerException {
        throw new UnsupportedOperationException();
    }

    public void delete(ProducerInfo info) throws ConsumerException {
        throw new UnsupportedOperationException();
    }

    public String update(ProducerInfo producerInfo) {
        throw new UnsupportedOperationException();
    }

    public Iterator<ProducerInfo> getProducerInfosFromStorage() {
        throw new UnsupportedOperationException();
    }

    public ProducerInfo loadProducerInfo(String id) {
        throw new UnsupportedOperationException();
    }

    public void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
    }

    public void setSessionEventBroadcaster(SessionEventBroadcaster sessionEventBroadcaster) {
    }

    public ProducerInfo getProducerInfoByKey(String key) {
        throw new UnsupportedOperationException();
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        throw new UnsupportedOperationException();
    }

    public SessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        throw new UnsupportedOperationException();
    }

    public boolean containsConsumer(String id) {
        return this.consumers.containsKey(id);
    }

    public Collection<String> getConfiguredConsumersIds() {
        return this.consumers.keySet();
    }

    public int getConfiguredConsumerNumber() {
        return this.consumers.size();
    }

    public WSRPConsumer createConsumerFrom(ProducerInfo producerInfo, boolean putInCache) {
        throw new UnsupportedOperationException();
    }

    public void registerWithFederatingPortletInvoker(WSRPConsumer consumer) {
        this.consumers.put(consumer.getProducerId(), consumer);
    }

    public void deregisterWithFederatingPortletInvoker(WSRPConsumer consumer) {
        this.consumers.remove(consumer.getProducerId());
    }

    public long getPersistedLastModifiedForProducerInfoWith(String id) {
        return System.currentTimeMillis();
    }
}

