/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.migration.mapping;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.util.ParameterValidation;

@PrimaryType(name="wsrp:exporterror")
public abstract class ExportErrorMapping {
    public static final String NODE_NAME = "wsrp:exporterror";
    private static final String COMMA = ",";

    @Property(name="errorcode")
    public abstract String getCode();

    public abstract void setCode(String var1);

    @Property(name="handles")
    public abstract String getHandles();

    public abstract void setHandles(String var1);

    public QName getErrorCode() {
        return QName.valueOf(this.getCode());
    }

    public List<String> getPortletHandles() {
        return Arrays.asList(this.getHandles().split(COMMA));
    }

    public void initFrom(QName errorCode, List<String> handles) {
        this.setCode(errorCode.toString());
        if (ParameterValidation.existsAndIsNotEmpty(handles)) {
            StringBuilder sb = new StringBuilder();
            int size = handles.size();
            int index = 0;
            for (String handle : handles) {
                sb.append(handle);
                if (index++ >= size) continue;
                sb.append(COMMA);
            }
            this.setHandles(sb.toString());
        }
    }
}

