/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gatein.exports.data.ExportData;

public class ExportPortletData
extends ExportData {
    protected static final String ENCODING = "UTF-8";
    public static final String TYPE = "WSRP_EC";
    public static final double VERSION = 1.0;
    protected static final String PORTLETHANDLEKEY = "pID";
    protected static final String PORTLETSTATEKEY = "pState";
    protected String portletHandle;
    protected byte[] portletState;

    public ExportPortletData(String portletHandle, byte[] portletState) {
        this.portletHandle = portletHandle;
        this.portletState = portletState;
    }

    public String getPortletHandle() {
        return this.portletHandle;
    }

    public byte[] getPortletState() {
        return this.portletState;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double getVersion() {
        return 1.0;
    }

    public static ExportPortletData create(byte[] bytes) throws IOException {
        byte[] portletState;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        String portletHandle = ois.readUTF();
        if (ois.available() > 0) {
            portletState = new byte[ois.available()];
            ois.readFully(portletState);
        } else {
            portletState = null;
        }
        ois.close();
        return new ExportPortletData(portletHandle, portletState);
    }

    @Override
    protected byte[] internalEncodeAsBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeUTF(this.portletHandle);
        if (this.portletState != null) {
            oos.write(this.portletState);
        }
        oos.close();
        return baos.toByteArray();
    }
}

