/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.gatein.exports.ExportManager;
import org.gatein.exports.ExportPersistenceManager;
import org.gatein.exports.OperationFailedException;
import org.gatein.exports.OperationNotSupportedException;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportData;
import org.gatein.exports.data.ExportPortletData;

public class ExportManagerImpl
implements ExportManager {
    protected ExportPersistenceManager exportPersistenceManager;
    protected boolean preferExportByValue = false;
    protected boolean supportExportByValue = true;

    @Override
    public ExportPersistenceManager getPersistenceManager() {
        return this.exportPersistenceManager;
    }

    @Override
    public void setPersistenceManager(ExportPersistenceManager exportPersistenceManager) {
        this.exportPersistenceManager = exportPersistenceManager;
    }

    @Override
    public ExportContext createExportContext(boolean exportByValueRequired, long currentTime, long terminationTime, long refreshDuration) throws UnsupportedEncodingException {
        boolean useExportByValue = false;
        if (exportByValueRequired || this.exportPersistenceManager == null && this.preferExportByValue) {
            useExportByValue = true;
        }
        return new ExportContext(useExportByValue, currentTime, terminationTime, refreshDuration);
    }

    @Override
    public boolean supportsExportByValue() {
        return this.supportExportByValue;
    }

    public void setPreferExportByValue(boolean preferExportByValue) {
        this.preferExportByValue = preferExportByValue;
    }

    @Override
    public ExportContext createExportContext(byte[] bytes) throws OperationFailedException {
        try {
            String type = ExportData.getType(bytes);
            double version = ExportData.getVersion(bytes);
            if ("WSRP_EC".equals(type) && 1.0 == version) {
                byte[] internalBytes = ExportData.getInternalBytes(bytes);
                return ExportContext.create(internalBytes);
            }
            if (this.exportPersistenceManager != null && this.exportPersistenceManager.supports(type, version)) {
                String refId = this.exportPersistenceManager.getExportReferenceId(type, version, ExportData.getInternalBytes(bytes));
                return this.exportPersistenceManager.getExportContext(refId);
            }
            throw new OperationFailedException("Byte array format not compatible");
        }
        catch (UnsupportedEncodingException e) {
            throw new OperationFailedException("Could not decode the byte array.");
        }
        catch (IOException e) {
            throw new OperationFailedException("Could not decode the byte array.");
        }
    }

    @Override
    public ExportPortletData createExportPortletData(ExportContext exportContextData, String portletHandle, byte[] portletState) throws UnsupportedEncodingException {
        return new ExportPortletData(portletHandle, portletState);
    }

    @Override
    public ExportPortletData createExportPortletData(ExportContext exportContextData, long currentTime, long terminationTime, long refreshDuration, byte[] bytes) throws OperationFailedException {
        try {
            String type = ExportData.getType(bytes);
            double version = ExportData.getVersion(bytes);
            if ("WSRP_EC".equals(type) && 1.0 == version) {
                byte[] internalBytes = ExportData.getInternalBytes(bytes);
                return ExportPortletData.create(internalBytes);
            }
            throw new OperationFailedException("Bytes array format not compatible");
        }
        catch (UnsupportedEncodingException e) {
            throw new OperationFailedException("Could not decode the byte array.");
        }
        catch (IOException e) {
            throw new OperationFailedException("Could not decode the byte array.");
        }
    }

    @Override
    public byte[] encodeExportPortletData(ExportContext exportContextData, ExportPortletData exportPortletData) throws IOException {
        if (exportContextData.isExportByValue()) {
            return exportPortletData.encodeAsBytes();
        }
        String refId = this.exportPersistenceManager.storeExportPortletData(exportContextData, exportPortletData);
        return this.exportPersistenceManager.encodeExportPortletData(refId);
    }

    @Override
    public byte[] encodeExportContextData(ExportContext exportContext) throws IOException {
        if (exportContext.isExportByValue()) {
            return exportContext.encodeAsBytes();
        }
        String refId = this.exportPersistenceManager.storeExportContext(exportContext);
        return this.exportPersistenceManager.encodeExportContext(refId);
    }

    @Override
    public ExportContext setExportLifetime(byte[] exportContextBytes, long currentTime, long terminationTime, long refreshDuration) throws OperationNotSupportedException, OperationFailedException {
        if (this.getPersistenceManager() == null) {
            throw new OperationNotSupportedException("The producer only supports export by value. Cannot call setExportLifetime on this producer");
        }
        try {
            String type = ExportData.getType(exportContextBytes);
            double version = ExportData.getVersion(exportContextBytes);
            if (this.getPersistenceManager().supports(type, version)) {
                String refId = this.getPersistenceManager().getExportReferenceId(type, version, ExportData.getInternalBytes(exportContextBytes));
                ExportContext exportContext = this.getPersistenceManager().getExportContext(refId);
                if (exportContext.isExportByValue()) {
                    throw new OperationFailedException("Cannot set the lifetime for an export that was exported by value.");
                }
                exportContext.setCurrentTime(currentTime);
                exportContext.setTerminationTime(terminationTime);
                exportContext.setRefreshDuration(refreshDuration);
                ExportContext updatedExportContext = this.getPersistenceManager().updateExportContext(refId, exportContext);
                return updatedExportContext;
            }
            throw new OperationFailedException("Byte array format not recognized.");
        }
        catch (IOException e) {
            throw new OperationFailedException("Could not decode the byte array.");
        }
    }

    @Override
    public void releaseExport(byte[] bytes) throws IOException {
        double version;
        String type;
        if (bytes != null && bytes.length > 0 && this.exportPersistenceManager != null && this.exportPersistenceManager.supports(type = ExportData.getType(bytes), version = ExportData.getVersion(bytes))) {
            String refId = this.exportPersistenceManager.getExportReferenceId(type, version, ExportData.getInternalBytes(bytes));
            this.exportPersistenceManager.removeExportContext(refId);
        }
    }
}

