/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PropertyDescription;

public class Utils {
    public static ModelDescription convertRegistrationPropertiesToModelDescription(Map<QName, RegistrationPropertyDescription> registrationInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationInfo, (String)"registration info");
        if (registrationInfo.isEmpty()) {
            return WSRPTypeFactory.createModelDescription(null);
        }
        ArrayList<PropertyDescription> propertyDescriptions = new ArrayList<PropertyDescription>(registrationInfo.size());
        for (RegistrationPropertyDescription property : registrationInfo.values()) {
            propertyDescriptions.add(Utils.convertToPropertyDescription(property));
        }
        return WSRPTypeFactory.createModelDescription(propertyDescriptions);
    }

    public static PropertyDescription convertToPropertyDescription(RegistrationPropertyDescription propertyDescription) {
        org.gatein.wsrp.registration.LocalizedString label;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"RegistrationPropertyDescription");
        PropertyDescription propDesc = WSRPTypeFactory.createPropertyDescription((String)propertyDescription.getName().toString(), (QName)propertyDescription.getType());
        org.gatein.wsrp.registration.LocalizedString hint = propertyDescription.getHint();
        if (hint != null) {
            propDesc.setHint(Utils.convertToWSRPLocalizedString(hint));
        }
        if ((label = propertyDescription.getLabel()) != null) {
            propDesc.setLabel(Utils.convertToWSRPLocalizedString(label));
        }
        return propDesc;
    }

    public static RegistrationPropertyDescription convertToRegistrationPropertyDescription(PropertyDescription propertyDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"PropertyDescription");
        RegistrationPropertyDescription desc = new RegistrationPropertyDescription(propertyDescription.getName(), propertyDescription.getType());
        desc.setLabel(Utils.getLocalizedStringOrNull(propertyDescription.getLabel()));
        desc.setHint(Utils.getLocalizedStringOrNull(propertyDescription.getHint()));
        return desc;
    }

    private static org.gatein.wsrp.registration.LocalizedString getLocalizedStringOrNull(LocalizedString wsrpLocalizedString) {
        if (wsrpLocalizedString == null) {
            return null;
        }
        return Utils.convertToLocalizedString(wsrpLocalizedString);
    }

    public static org.gatein.wsrp.registration.LocalizedString convertToLocalizedString(LocalizedString wsrpLocalizedString) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)wsrpLocalizedString, (String)"WSRP LocalizedString");
        String lang = wsrpLocalizedString.getLang();
        Locale locale = lang == null ? Locale.getDefault() : WSRPUtils.getLocale((String)lang);
        org.gatein.wsrp.registration.LocalizedString localizedString = new org.gatein.wsrp.registration.LocalizedString(wsrpLocalizedString.getValue(), locale);
        localizedString.setResourceName(wsrpLocalizedString.getResourceName());
        return localizedString;
    }

    public static LocalizedString convertToWSRPLocalizedString(org.gatein.wsrp.registration.LocalizedString regLocalizedString) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)regLocalizedString, (String)"LocalizedString");
        return WSRPTypeFactory.createLocalizedString((String)WSRPUtils.toString((Locale)regLocalizedString.getLocale()), (String)regLocalizedString.getResourceName(), (String)regLocalizedString.getValue());
    }

    public static LocalizedString convertToWSRPLocalizedString(org.gatein.common.i18n.LocalizedString localizedString, List<String> desiredLocales) {
        LocalizedString.Value match = Utils.getPreferredOrBestMatchFor(localizedString, desiredLocales);
        if (match != null) {
            Locale locale = match.getLocale();
            String value = match.getString();
            String language = WSRPUtils.toString((Locale)locale);
            return WSRPTypeFactory.createLocalizedString((String)language, null, (String)value);
        }
        return null;
    }

    public static LocalizedString convertToWSRPLocalizedString(org.gatein.common.i18n.LocalizedString localizedString, Locale locale) {
        String value;
        if (localizedString == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((value = localizedString.getString(locale, true)) != null) {
            return WSRPTypeFactory.createLocalizedString((String)WSRPUtils.toString((Locale)locale), null, (String)value);
        }
        return null;
    }

    public static Locale getPreferredOrBestLocaleFor(org.gatein.common.i18n.LocalizedString localizedString, List<String> desiredLocales) {
        LocalizedString.Value match = Utils.getPreferredOrBestMatchFor(localizedString, desiredLocales);
        if (match != null) {
            return match.getLocale();
        }
        return null;
    }

    private static LocalizedString.Value getPreferredOrBestMatchFor(org.gatein.common.i18n.LocalizedString localizedString, List<String> desiredLocales) {
        if (localizedString == null) {
            return null;
        }
        if (desiredLocales == null || desiredLocales.isEmpty()) {
            desiredLocales = Collections.singletonList(WSRPConstants.DEFAULT_LOCALE);
        }
        return localizedString.getPreferredOrBestLocalizedMappingFor(desiredLocales.toArray(new String[desiredLocales.size()]));
    }

    public static void throwOperationFaultOnSessionOperation() throws OperationFailed {
        throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"JBoss Portal's Producer manages sessions completely on the server side, passing or trying to release sessionIDs is therefore an error.", null);
    }
}

