/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.endpoints.v1;

import com.google.common.base.Function;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.cxf.feature.Features;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.endpoints.WSRPBaseEndpoint;
import org.gatein.wsrp.spec.v1.V1ToV2Converter;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.oasis.wsrp.v1.V1CookieProtocol;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1ItemDescription;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.ServiceDescription;

@WebService(name="WSRPV1ServiceDescriptionPortType", serviceName="WSRPService", portName="WSRPServiceDescriptionService", targetNamespace="urn:oasis:names:tc:wsrp:v1:wsdl", wsdlLocation="/WEB-INF/wsdl/wsrp_services.wsdl", endpointInterface="org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType")
@Features(features={"org.gatein.wsrp.cxf.WSRPEndpointFeature"})
public class ServiceDescriptionEndpoint
extends WSRPBaseEndpoint
implements WSRPV1ServiceDescriptionPortType {
    public void getServiceDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="requiresRegistration", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<Boolean> requiresRegistration, @WebParam(mode=WebParam.Mode.OUT, name="offeredPortlets", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1PortletDescription>> offeredPortlets, @WebParam(mode=WebParam.Mode.OUT, name="userCategoryDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> userCategoryDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customUserProfileItemDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customUserProfileItemDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customWindowStateDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customWindowStateDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customModeDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customModeDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="requiresInitCookie", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1CookieProtocol> requiresInitCookie, @WebParam(mode=WebParam.Mode.OUT, name="registrationPropertyDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ModelDescription> registrationPropertyDescription, @WebParam(mode=WebParam.Mode.OUT, name="locales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<String>> locales, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1InvalidRegistration, V1OperationFailed {
        ServiceDescription description;
        GetServiceDescription getServiceDescription = WSRPTypeFactory.createGetServiceDescription((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), null);
        getServiceDescription.getDesiredLocales().addAll(desiredLocales);
        try {
            description = this.producer.getServiceDescription(getServiceDescription);
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        requiresRegistration.value = description.isRequiresRegistration();
        offeredPortlets.value = WSRPUtils.transform((List)description.getOfferedPortlets(), (Function)V2ToV1Converter.PORTLETDESCRIPTION);
        userCategoryDescriptions.value = WSRPUtils.transform((List)description.getUserCategoryDescriptions(), (Function)V2ToV1Converter.ITEMDESCRIPTION);
        customWindowStateDescriptions.value = WSRPUtils.transform((List)description.getCustomWindowStateDescriptions(), (Function)V2ToV1Converter.ITEMDESCRIPTION);
        customModeDescriptions.value = WSRPUtils.transform((List)description.getCustomModeDescriptions(), (Function)V2ToV1Converter.ITEMDESCRIPTION);
        requiresInitCookie.value = V2ToV1Converter.toV1CookieProtocol((CookieProtocol)description.getRequiresInitCookie());
        registrationPropertyDescription.value = V2ToV1Converter.toV1ModelDescription((ModelDescription)description.getRegistrationPropertyDescription());
        locales.value = description.getLocales();
        resourceList.value = V2ToV1Converter.toV1ResourceList((ResourceList)description.getResourceList());
        extensions.value = WSRPUtils.transform((List)description.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
    }
}

