/*
 * Decompiled with CFR 0.152.
 */
package org.wsrp.wss.jboss5.handlers.consumer;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gatein.wci.security.Credentials;
import org.gatein.wsrp.servlet.ServletAccess;
import org.jboss.ws.core.CommonMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSSecurityCredentialHandler
implements SOAPHandler<SOAPMessageContext> {
    private static Logger log = LoggerFactory.getLogger(WSSecurityCredentialHandler.class);

    public void close(MessageContext arg0) {
    }

    public boolean handleFault(SOAPMessageContext soapMessageContext) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        if (Boolean.TRUE.equals(soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound"))) {
            return this.handleRequest(soapMessageContext);
        }
        return this.handleResponse(soapMessageContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequest(SOAPMessageContext soapMessageContext) {
        try {
            log.debug("Attempting to convert security context to WS-Security header");
            CommonMessageContext ctx = (CommonMessageContext)soapMessageContext;
            HttpServletRequest request = ServletAccess.getRequest();
            if (request != null && request.getSession() != null) {
                Credentials credentials = (Credentials)request.getSession().getAttribute("credentials");
                if (credentials != null) {
                    ctx.put("javax.xml.ws.security.auth.username", (Object)credentials.getUsername());
                    ctx.put("javax.xml.ws.security.auth.password", (Object)credentials.getPassword());
                    return true;
                }
                log.debug("Could not find credentials to put in WS-Security header");
                return true;
            }
            log.debug("Could not get current HttpServletRequest, cannot login.");
            return true;
        }
        catch (Exception e) {
            log.warn("Error occured when trying to add the credentials to the BindingProvider for WS-Security.", (Throwable)e);
        }
        return true;
    }

    private boolean handleResponse(SOAPMessageContext soapMessageContext) {
        return false;
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

