/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.Set;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktPunctuationToken;

abstract class WktVariant {
    private final WktPunctuationToken openList;
    private final WktPunctuationToken closeList;
    private final WktPunctuationToken elementSeparator;
    private final WktPunctuationToken end = new WktPunctuationToken(' ');

    protected WktVariant(char openList, char closeList, char elementSeparator) {
        this.openList = new WktPunctuationToken(openList);
        this.closeList = new WktPunctuationToken(closeList);
        this.elementSeparator = new WktPunctuationToken(elementSeparator);
    }

    public WktKeywordToken matchKeyword(CharSequence wkt, int currentPos, int endPos) {
        for (WktKeywordToken token : this.getWktKeywords()) {
            if (!token.matches(wkt, currentPos, endPos)) continue;
            return token;
        }
        throw new WktDecodeException(String.format("Can't interpret word %s in Wkt.", wkt.subSequence(currentPos, endPos)));
    }

    protected abstract Set<WktKeywordToken> getWktKeywords();

    public WktPunctuationToken getOpenList() {
        return this.openList;
    }

    public WktPunctuationToken getCloseList() {
        return this.closeList;
    }

    public WktPunctuationToken getElementSeparator() {
        return this.elementSeparator;
    }

    public WktPunctuationToken end() {
        return this.end;
    }

    public char getOpenListChar() {
        return this.getOpenList().getChar();
    }

    public char getCloseListChar() {
        return this.getCloseList().getChar();
    }

    public char getElemSepChar() {
        return this.getElementSeparator().getChar();
    }
}

