/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsIdentifiable;

public class Ellipsoid
extends CrsIdentifiable {
    private final double semiMajorAxis;
    private final double inverseFlattening;

    public Ellipsoid(CrsId crsId, String name, double semiMajorAxis, double inverseFlattening) {
        super(crsId, name);
        this.semiMajorAxis = semiMajorAxis;
        this.inverseFlattening = inverseFlattening;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ellipsoid ellipsoid = (Ellipsoid)o;
        if (Double.compare(ellipsoid.inverseFlattening, this.inverseFlattening) != 0) {
            return false;
        }
        return Double.compare(ellipsoid.semiMajorAxis, this.semiMajorAxis) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = this.semiMajorAxis != 0.0 ? Double.doubleToLongBits(this.semiMajorAxis) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inverseFlattening != 0.0 ? Double.doubleToLongBits(this.inverseFlattening) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

