/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.crs.trans.TransformOperation;

public class TransformVisitor<P extends Position, Q extends Position>
implements GeometryVisitor<P> {
    private final TransformOperation<P, Q> operation;
    private Stack<Geometry<Q>> transformed = new Stack();

    public TransformVisitor(TransformOperation<P, Q> op) {
        this.operation = op;
    }

    public void reset() {
        this.transformed.clear();
    }

    public TransformVisitor<Q, P> reversed() {
        return new TransformVisitor<Q, P>(this.operation.reversed());
    }

    @Override
    public void visit(Point<P> point) {
        if (point.isEmpty()) {
            this.transformed.push(new Point<Q>(this.operation.getTarget()));
        } else {
            this.transformed.push(new Point<Q>(this.operation.forward(point.getPosition()), this.operation.getTarget()));
        }
    }

    @Override
    public void visit(LineString<P> lineString) {
        if (lineString.isEmpty()) {
            this.transformed.push(new LineString<Q>(this.operation.getTarget()));
        } else {
            ConvertingVisitor llv = new ConvertingVisitor(lineString.getNumPositions());
            lineString.getPositions().accept(llv);
            this.transformed.push(new LineString(llv.build(), this.operation.getTarget()));
        }
    }

    @Override
    public void visit(Polygon<P> polygon) {
        if (polygon.isEmpty()) {
            this.transformed.push(new Polygon<Q>(this.operation.getTarget()));
        } else {
            LinearRing[] rings = new LinearRing[polygon.getNumInteriorRing() + 1];
            int idx = 0;
            for (LinearRing<P> ring : polygon.components()) {
                ConvertingVisitor llv = new ConvertingVisitor(ring.getNumPositions());
                ring.getPositions().accept(llv);
                rings[idx++] = new LinearRing(llv.build(), this.operation.getTarget());
            }
            this.transformed.push(new Polygon(rings));
        }
    }

    @Override
    public <G extends Geometry<P>> void visit(AbstractGeometryCollection<P, G> collection) {
        this.transformed.push(null);
    }

    @Override
    public <G extends Geometry<P>> void endVisit(AbstractGeometryCollection<P, G> collection) {
        Geometry<Q> popped;
        ArrayList parts = new ArrayList();
        while (!this.transformed.isEmpty() && (popped = this.transformed.pop()) != null) {
            parts.add(popped);
        }
        Collections.reverse(parts);
        this.transformed.push(Geometries.mkGeometry(collection.getClass(), parts));
    }

    public Geometry<Q> getTransformed() {
        return this.transformed.pop();
    }

    private class ConvertingVisitor
    implements LLAPositionVisitor {
        private final PositionSequenceBuilder<Q> builder;
        private final double[] coordinates;

        ConvertingVisitor(int size) {
            this.builder = PositionSequenceBuilders.fixedSized(size, TransformVisitor.this.operation.getTarget().getPositionClass());
            int coordinateDimension = TransformVisitor.this.operation.getTarget().getCoordinateDimension();
            this.coordinates = new double[coordinateDimension];
        }

        @Override
        public void visit(double[] inCoordinates) {
            TransformVisitor.this.operation.getOperation().forward(inCoordinates, this.coordinates);
            this.builder.add((Object)this.coordinates);
        }

        PositionSequence<Q> build() {
            return this.builder.toPositionSequence();
        }
    }
}

