/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.glassfish.module.maven.commandsecurityplugin.CommandAuthorizationInfo;
import org.glassfish.module.maven.commandsecurityplugin.CommonMojo;
import org.glassfish.module.maven.commandsecurityplugin.OverrideManager;
import org.glassfish.module.maven.commandsecurityplugin.RestEndpointInfo;
import org.glassfish.module.maven.commandsecurityplugin.TypeProcessorImpl;
import org.glassfish.module.maven.commandsecurityplugin.Util;

@Mojo(name="print", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PrintMojo
extends CommonMojo {
    private static final String OUTPUT_PROP_NAME = "org.glassfish.command.security.output";
    private static final String OUTPUT_INDENT_PROP_NAME = "org.glassfish.command.security.output.indent";
    private static final String IS_ANY_OUTPUT_NAME = "org.glassfish.command.security.isAnyOutput";
    private static final String OVERRIDE_FILE = "commandSecurityOverride.txt";
    @Parameter(property="command-security-maven-plugin.output-type", readonly=true, defaultValue="summary")
    protected String outputType;
    private PrintWriter pw;
    AtomicBoolean isAnyOutput = new AtomicBoolean(false);
    private boolean isAnyOutputThisModule = false;
    StringBuilder indent;
    URI parentOfTopURI;
    Map<String, TypeProcessorImpl.Inhabitant> configBeans;
    private OverrideManager om;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<String> offendingClassNames;
        this.isAnyOutput = this.getOrSet(IS_ANY_OUTPUT_NAME, this.isAnyOutput);
        this.parentOfTopURI = this.findParentOfTopURI();
        TypeProcessorImpl typeProcessor = new TypeProcessorImpl(this, this.session, this.project);
        typeProcessor.execute();
        this.configBeans = typeProcessor.configBeans();
        this.om = this.initOverrideManager();
        OutputFormatter outputFormatter = this.chooseOutputFormatter(this.outputType);
        this.pw = this.getPrintWriter();
        this.indent = this.getAndAdjustIndent();
        for (CommandAuthorizationInfo info : typeProcessor.authInfosThisModule()) {
            if (info.name() != null) {
                if (!this.isAnyOutputThisModule) {
                    outputFormatter.postOpen();
                    this.isAnyOutputThisModule = true;
                }
                outputFormatter.printCommandInfo(this.om.adjust(info));
                continue;
            }
            this.getLog().debug((CharSequence)("info.name() was null in project " + this.project.getName() + " for type " + info.className()));
        }
        outputFormatter.preClose();
        StringBuilder trace = typeProcessor.trace();
        if (trace != null) {
            this.getLog().debug((CharSequence)trace.toString());
        }
        if (typeProcessor.okClassNames() != null) {
            this.getLog().debug((CharSequence)("Command classes with authorization: " + typeProcessor.okClassNames().toString()));
        }
        if (!(offendingClassNames = typeProcessor.offendingClassNames()).isEmpty()) {
            if (typeProcessor.isFailureFatal()) {
                this.getLog().error((CharSequence)("Following command classes neither provide nor inherit authorization: " + offendingClassNames.toString()));
                throw new MojoFailureException("Command class(es) with no authorization");
            }
            this.getLog().warn((CharSequence)("Following command classes neither provide nor inherit authorization: " + offendingClassNames.toString()));
        }
        this.restoreIndent(this.indent);
        this.pw.flush();
    }

    private OverrideManager initOverrideManager() {
        File overrideFile = new File(this.project.getBasedir(), OVERRIDE_FILE);
        return new OverrideManager(overrideFile, this.getLog());
    }

    private boolean isLastProject() {
        List projects = this.reactorProjects;
        return this.project.equals(projects.get(projects.size() - 1)) && this.isAnyOutput.get();
    }

    <T> T getOrSet(String propertyName, T value) {
        Object result = this.getSessionProperties().get(propertyName);
        if (result == null) {
            result = value;
            this.getSessionProperties().put(propertyName, result);
        }
        return (T)result;
    }

    private URI findParentOfTopURI() {
        File parentOfTopLevel = null;
        for (File dir = this.project.getBasedir(); dir != null; dir = dir.getParentFile()) {
            File pom = new File(dir, "pom.xml");
            if (pom.canRead()) continue;
            parentOfTopLevel = dir;
            break;
        }
        return parentOfTopLevel.toURI();
    }

    private Properties getSessionProperties() {
        return this.session.getUserProperties();
    }

    private PrintWriter getPrintWriter() throws MojoFailureException {
        PrintWriter pw = (PrintWriter)this.getSessionProperties().get(OUTPUT_PROP_NAME);
        if (pw == null) {
            MavenProject execRoot = this.getExecutionRootProject();
            File outputFile = new File(execRoot.getBasedir(), "commandList.txt");
            try {
                pw = new PrintWriter(outputFile);
                this.getSessionProperties().put(OUTPUT_PROP_NAME, pw);
            }
            catch (FileNotFoundException ex) {
                throw new MojoFailureException("Unable to open command list output file " + outputFile.getAbsolutePath() + ex.getMessage());
            }
        }
        return pw;
    }

    private MavenProject getExecutionRootProject() {
        MavenProject execRoot = null;
        for (Object o : this.reactorProjects) {
            MavenProject p;
            if (!(o instanceof MavenProject) || !(p = (MavenProject)o).isExecutionRoot()) continue;
            execRoot = p;
        }
        return execRoot;
    }

    private StringBuilder getAndAdjustIndent() {
        StringBuilder result = (StringBuilder)this.getSessionProperties().get(OUTPUT_INDENT_PROP_NAME);
        if (result == null) {
            result = new StringBuilder();
        }
        result.append("  ");
        this.getSessionProperties().put(OUTPUT_INDENT_PROP_NAME, result);
        return result;
    }

    private void restoreIndent(StringBuilder indent) {
        if (indent.length() > 0) {
            indent.delete(indent.length() - 2, indent.length());
        }
    }

    private OutputFormatter chooseOutputFormatter(String outputType) {
        if (outputType.equals("summary")) {
            return new SummaryFormatter();
        }
        if (outputType.equals("wiki")) {
            return new WikiFormatter();
        }
        if (outputType.equals("csv")) {
            return new CSVFormatter();
        }
        this.getLog().warn((CharSequence)("Unrecognized output type " + outputType + "; using human-readable instead"));
        return new SummaryFormatter();
    }

    private class CSVFormatter
    extends OneLineFormatter {
        CSVFormatter() {
            super(",");
        }

        @Override
        public void doPostOpen() {
            PrintMojo.this.pw.println("Module Name,Module Dir, Command Name,Resource,Action,Origin");
        }
    }

    private class WikiFormatter
    extends OneLineFormatter {
        WikiFormatter() {
            super(" | ");
        }

        @Override
        public void doPostOpen() {
            PrintMojo.this.pw.println("{table-plus}");
            PrintMojo.this.pw.println("|| Module Name || Module Dir || Command Name || Resource || Action || Origin ||");
        }

        @Override
        public void doPreClose() {
            PrintMojo.this.pw.println("{table-plus}");
        }
    }

    private abstract class OneLineFormatter
    implements OutputFormatter {
        private final String sep;

        OneLineFormatter(String sep) {
            this.sep = sep;
        }

        protected abstract void doPostOpen();

        @Override
        public void postOpen() {
            if (!PrintMojo.this.isAnyOutput.get()) {
                this.doPostOpen();
                PrintMojo.this.isAnyOutput.set(true);
            }
        }

        String lastPart(String s) {
            int lastSlash = s.lastIndexOf(47);
            if (lastSlash != -1) {
                return s.substring(lastSlash + 1);
            }
            return s;
        }

        @Override
        public void printCommandInfo(CommandAuthorizationInfo authInfo) {
            Object sb;
            StringBuilder prefix = new StringBuilder(this.sep).append(PrintMojo.this.project.getName()).append(this.sep).append(PrintMojo.this.parentOfTopURI.relativize(PrintMojo.this.project.getBasedir().toURI()).toASCIIString()).append(this.sep).append(authInfo.name()).append(this.sep);
            if (authInfo.delegate() != null) {
                sb = new StringBuilder(prefix).append('?').append(this.sep).append('?').append(this.sep).append("Delegates to ").append(authInfo.delegate().delegateInternalClassName().replace('/', '.')).append(this.sep);
                PrintMojo.this.pw.println(((StringBuilder)sb).toString());
            }
            if (!authInfo.genericAction().isEmpty()) {
                sb = new StringBuilder(prefix).append(authInfo.genericSubpathPerAction("/")).append(this.sep).append(authInfo.adjustedGenericAction()).append(this.sep).append("CRUD").append(this.sep);
                PrintMojo.this.pw.println(((StringBuilder)sb).toString());
            }
            for (RestEndpointInfo endpointInfo : authInfo.restEndpoints()) {
                if (!endpointInfo.useForAuthorization()) continue;
                TypeProcessorImpl.Inhabitant configBean = PrintMojo.this.configBeans.get(endpointInfo.configBeanClassName().replace('/', '.'));
                if (configBean == null) {
                    PrintMojo.this.getLog().error((CharSequence)("Could not find config bean for RestEndpoint with config bean class name " + endpointInfo.configBeanClassName()));
                    continue;
                }
                StringBuilder sb2 = new StringBuilder(prefix).append(configBean.fullPath()).append(this.sep).append(Util.restOpTypeToAction(endpointInfo.opType())).append(this.sep).append("ReST").append(this.sep);
                PrintMojo.this.pw.println(sb2.toString());
            }
            for (CommandAuthorizationInfo.ResourceAction ra : authInfo.resourceActionPairs()) {
                StringBuilder sb3 = new StringBuilder(prefix).append(ra.resource).append(this.sep).append(ra.action).append(this.sep).append(ra.origin).append(this.sep);
                PrintMojo.this.pw.println(sb3.toString());
            }
            if (authInfo.isAccessCheckProvider()) {
                sb = new StringBuilder(prefix).append("?").append(this.sep).append("?").append(this.sep).append("AccessCheckProvider").append(this.sep);
                PrintMojo.this.pw.println(((StringBuilder)sb).toString());
            }
        }

        protected void doPreClose() {
        }

        @Override
        public void preClose() {
            if (PrintMojo.this.isLastProject() && PrintMojo.this.isAnyOutput.get()) {
                this.doPreClose();
            }
        }
    }

    private class SummaryFormatter
    implements OutputFormatter {
        private SummaryFormatter() {
        }

        @Override
        public void postOpen() {
            PrintMojo.this.pw.println(PrintMojo.this.indent.toString() + "=================================================================================");
            PrintMojo.this.pw.println(PrintMojo.this.indent.toString() + PrintMojo.this.project.getName() + "(" + PrintMojo.this.project.getBasedir() + ")");
            PrintMojo.this.pw.println();
        }

        @Override
        public void printCommandInfo(CommandAuthorizationInfo authInfo) {
            PrintMojo.this.pw.println(PrintMojo.this.indent.toString() + "  " + authInfo.toString(PrintMojo.this.indent.toString() + "  ", true));
        }

        @Override
        public void preClose() {
        }
    }

    private static interface OutputFormatter {
        public void postOpen();

        public void printCommandInfo(CommandAuthorizationInfo var1);

        public void preClose();
    }
}

