/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec.maven;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.glassfish.spec.Artifact;
import org.glassfish.spec.Metadata;
import org.glassfish.spec.Spec;

@Mojo(name="check-module", requiresProject=true, defaultPhase=LifecyclePhase.PACKAGE)
public final class CheckModuleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="module")
    private File module;
    @Parameter(property="ignoreErrors", defaultValue="false")
    private boolean ignoreErrors;
    @Parameter(property="specMode", defaultValue="jakarta")
    private String specMode;
    @Parameter(property="spec", required=true)
    private Spec spec;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.module == null || !this.module.exists()) {
            this.module = this.project.getArtifact().getFile();
            if (this.module == null || !this.module.exists()) {
                this.getLog().error((CharSequence)"There is no jar to verify, try using mvn package first.");
                throw new MojoFailureException("no jar to verify");
            }
        }
        try {
            if (this.spec == null) {
                this.spec = new Spec();
            }
            this.spec.setSpecMode(this.specMode);
            this.spec.setArtifact(new Artifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
            this.spec.setMetadata(Metadata.fromJar(new JarFile(this.module)));
            this.spec.verify();
            if (!this.spec.getErrors().isEmpty()) {
                System.out.println("");
                System.out.println(this.spec.getArtifact().toString());
                String specDesc = this.spec.toString();
                if (!specDesc.isEmpty()) {
                    System.out.println(this.spec.toString());
                }
                for (int i = 0; i < this.spec.getErrors().size(); ++i) {
                    System.out.println("" + '-' + ' ' + this.spec.getErrors().get(i));
                }
                System.out.println("");
                if (!this.ignoreErrors) {
                    throw new MojoFailureException("spec verification failed.");
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

