/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.ClassSerializer;
import com.googlecode.jtype.ClassSerializers;
import com.googlecode.jtype.ClassUtils;
import com.googlecode.jtype.DefaultGenericArrayType;
import com.googlecode.jtype.DefaultParameterizedType;
import com.googlecode.jtype.DefaultTypeVariable;
import com.googlecode.jtype.DefaultWildcardType;
import com.googlecode.jtype.Types;
import com.googlecode.jtype.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtils {
    private TypeUtils() {
        throw new AssertionError();
    }

    public static boolean isAssignable(Type supertype, Type type2) {
        Utils.checkNotNull(supertype, "supertype");
        Utils.checkNotNull(type2, "type");
        boolean assignable = supertype.equals(type2) ? true : (supertype instanceof Class && type2 instanceof Class ? ((Class)supertype).isAssignableFrom((Class)type2) : (supertype instanceof Class && type2 instanceof ParameterizedType ? TypeUtils.isAssignable(supertype, ((ParameterizedType)type2).getRawType()) : (supertype instanceof ParameterizedType && type2 instanceof ParameterizedType ? TypeUtils.isAssignable((ParameterizedType)supertype, (ParameterizedType)type2) : (supertype instanceof WildcardType ? TypeUtils.isAssignable((WildcardType)supertype, type2) : (type2 instanceof Class ? TypeUtils.isAssignable(supertype, (Class)type2) : false)))));
        return assignable;
    }

    public static boolean isInstance(Type type2, Object object) {
        return TypeUtils.getRawType(type2).isInstance(object);
    }

    public static Type getErasedType(Type type2) {
        Type erasedType;
        Utils.checkNotNull(type2, "type");
        if (type2 instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type2).getRawType();
            erasedType = TypeUtils.getErasedType(rawType);
        } else if (TypeUtils.isArray(type2)) {
            Type componentType = TypeUtils.getComponentType(type2);
            Type erasedComponentType = TypeUtils.getErasedType(componentType);
            erasedType = TypeUtils.getArrayType(erasedComponentType);
        } else if (type2 instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type2).getBounds();
            erasedType = TypeUtils.getErasedType(bounds[0]);
        } else {
            erasedType = type2;
        }
        return erasedType;
    }

    public static Class<?> getRawType(Type type2) {
        Class<?> rawType;
        Utils.checkNotNull(type2, "type");
        if (type2 instanceof Class) {
            rawType = (Class<?>)type2;
        } else if (type2 instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type2).getGenericComponentType();
            Class<?> rawComponentType = TypeUtils.getRawType(componentType);
            rawType = ClassUtils.getArrayType(rawComponentType);
        } else if (type2 instanceof ParameterizedType) {
            rawType = TypeUtils.getRawType(((ParameterizedType)type2).getRawType());
        } else {
            throw new IllegalArgumentException("Cannot obtain raw type from " + type2);
        }
        return rawType;
    }

    public static boolean isArray(Type type2) {
        Utils.checkNotNull(type2, "type");
        boolean array = type2 instanceof Class ? ((Class)type2).isArray() : type2 instanceof GenericArrayType;
        return array;
    }

    public static Type getComponentType(Type type2) {
        Class klass;
        Utils.checkNotNull(type2, "type");
        Class<Object> componentType = type2 instanceof Class ? ((klass = (Class)type2).isArray() ? klass.getComponentType() : null) : (type2 instanceof GenericArrayType ? ((GenericArrayType)type2).getGenericComponentType() : null);
        return componentType;
    }

    public static Type getArrayType(Type componentType) {
        Utils.checkNotNull(componentType, "componentType");
        Type arrayType = componentType instanceof Class ? ClassUtils.getArrayType((Class)componentType) : Types.genericArrayType(componentType);
        return arrayType;
    }

    public static boolean isSimpleParameterizedType(Type type2, Class<?> rawType) {
        Utils.checkNotNull(type2, "type");
        Utils.checkNotNull(rawType, "rawType");
        if (!(type2 instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramType = (ParameterizedType)type2;
        Type paramRawType = paramType.getRawType();
        if (!(paramRawType instanceof Class)) {
            return false;
        }
        Class paramRawClass = (Class)paramRawType;
        if (!rawType.isAssignableFrom(paramRawClass)) {
            return false;
        }
        Type[] typeArgs = paramType.getActualTypeArguments();
        return typeArgs.length == 1;
    }

    public static Type getActualTypeArgument(Type type2) {
        Utils.checkNotNull(type2, "type");
        ParameterizedType paramType = (ParameterizedType)type2;
        Type[] typeArgs = paramType.getActualTypeArguments();
        Utils.checkTrue(typeArgs.length == 1, "type must be a ParameterizedType with one actual type argument: ", type2);
        return typeArgs[0];
    }

    public static String toString(Type type2) {
        return TypeUtils.toString(type2, ClassSerializers.QUALIFIED);
    }

    public static String toString(Type type2, ClassSerializer serializer) {
        Class klass;
        String value = type2 instanceof Class ? ((klass = (Class)type2).isArray() ? TypeUtils.toString(klass.getComponentType(), serializer) + "[]" : serializer.toString(klass)) : (type2 instanceof TypeVariable ? DefaultTypeVariable.toString((TypeVariable)type2, serializer) : (type2 instanceof GenericArrayType ? DefaultGenericArrayType.toString((GenericArrayType)type2, serializer) : (type2 instanceof ParameterizedType ? DefaultParameterizedType.toString((ParameterizedType)type2, serializer) : (type2 instanceof WildcardType ? DefaultWildcardType.toString((WildcardType)type2, serializer) : String.valueOf(type2)))));
        return value;
    }

    public static String toUnqualifiedString(Type type2) {
        return TypeUtils.toString(type2, ClassSerializers.UNQUALIFIED);
    }

    static StringBuilder appendBounds(StringBuilder builder, Type[] bounds, ClassSerializer serializer) {
        for (int i = 0; i < bounds.length; ++i) {
            if (i > 0) {
                builder.append(" & ");
            }
            builder.append(TypeUtils.toString(bounds[i], serializer));
        }
        return builder;
    }

    private static boolean isAssignable(ParameterizedType supertype, ParameterizedType type2) {
        Type[] typeArgs;
        if (!TypeUtils.isAssignable(supertype.getRawType(), type2.getRawType())) {
            return false;
        }
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        if (supertypeArgs.length != (typeArgs = type2.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < supertypeArgs.length; ++i) {
            Type supertypeArg = supertypeArgs[i];
            Type typeArg = typeArgs[i];
            if (supertypeArg.equals(typeArg) || supertypeArg instanceof WildcardType && TypeUtils.isAssignable((WildcardType)supertypeArg, typeArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType supertype, Type type2) {
        for (Type upperBound : supertype.getUpperBounds()) {
            if (TypeUtils.isAssignable(upperBound, type2)) continue;
            return false;
        }
        for (Type lowerBound : supertype.getLowerBounds()) {
            if (TypeUtils.isAssignable(type2, lowerBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type supertype, Class<?> type2) {
        Type genericSuperclass = type2.getGenericSuperclass();
        if (genericSuperclass != null && TypeUtils.isAssignable(supertype, genericSuperclass)) {
            return true;
        }
        for (Type interphace : type2.getGenericInterfaces()) {
            if (!TypeUtils.isAssignable(supertype, interphace)) continue;
            return true;
        }
        return false;
    }
}

