/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.comm;

import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.EventCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.comm.GridDataCommand;
import com.sun.btrace.comm.InstrumentCommand;
import com.sun.btrace.comm.MessageCommand;
import com.sun.btrace.comm.NumberDataCommand;
import com.sun.btrace.comm.NumberMapDataCommand;
import com.sun.btrace.comm.OkayCommand;
import com.sun.btrace.comm.RenameCommand;
import com.sun.btrace.comm.StringMapDataCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class WireIO {
    private WireIO() {
    }

    public static Command read(ObjectInput in) throws IOException {
        Command cmd;
        byte type2 = in.readByte();
        switch (type2) {
            case 0: {
                cmd = new ErrorCommand();
                break;
            }
            case 1: {
                cmd = new EventCommand();
                break;
            }
            case 2: {
                cmd = new ExitCommand();
                break;
            }
            case 3: {
                cmd = new InstrumentCommand();
                break;
            }
            case 4: {
                cmd = new MessageCommand();
                break;
            }
            case 5: {
                cmd = new RenameCommand();
                break;
            }
            case 6: {
                cmd = new OkayCommand();
                break;
            }
            case 7: {
                cmd = new NumberMapDataCommand();
                break;
            }
            case 8: {
                cmd = new StringMapDataCommand();
                break;
            }
            case 9: {
                cmd = new NumberDataCommand();
                break;
            }
            case 10: {
                cmd = new GridDataCommand();
                break;
            }
            default: {
                throw new RuntimeException("invalid command: " + type2);
            }
        }
        try {
            cmd.read(in);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        return cmd;
    }

    public static void write(ObjectOutput out, Command cmd) throws IOException {
        out.writeByte(cmd.getType());
        cmd.write(out);
        out.flush();
    }
}

