/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.annotations.BTrace;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.Attribute;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.FieldVisitor;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.util.NullVisitor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ClassFilter {
    private String[] sourceClasses;
    private Pattern[] sourceClassPatterns;
    private String[] annotationClasses;
    private Pattern[] annotationClassPatterns;
    private String[] superTypes;
    private String[] superTypesInternal;

    public ClassFilter(List<OnMethod> onMethods) {
        this.init(onMethods);
    }

    public boolean isCandidate(Class target) {
        return this.isCandidate(target, true);
    }

    public boolean isCandidate(Class target, boolean checkAnnotations) {
        if (target.isInterface() || target.isPrimitive() || target.isArray()) {
            return false;
        }
        if (checkAnnotations && target.getAnnotation(BTrace.class) != null) {
            return false;
        }
        String className = target.getName();
        for (String name : this.sourceClasses) {
            if (!name.equals(className)) continue;
            return true;
        }
        for (Pattern pat : this.sourceClassPatterns) {
            if (!pat.matcher(className).matches()) continue;
            return true;
        }
        for (String st : this.superTypes) {
            if (!ClassFilter.isSubTypeOf(target, st)) continue;
            return true;
        }
        if (checkAnnotations) {
            int i;
            Annotation[] annotations = target.getAnnotations();
            String[] annoTypes = new String[annotations.length];
            for (int i2 = 0; i2 < annotations.length; ++i2) {
                annoTypes[i2] = annotations[i2].annotationType().getName();
            }
            for (String name : this.annotationClasses) {
                for (i = 0; i < annoTypes.length; ++i) {
                    if (!name.equals(annoTypes[i])) continue;
                    return true;
                }
            }
            for (Pattern pat : this.annotationClassPatterns) {
                for (i = 0; i < annoTypes.length; ++i) {
                    if (!pat.matcher(annoTypes[i]).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCandidate(byte[] classBytes) {
        return this.isCandidate(new ClassReader(classBytes));
    }

    public boolean isCandidate(ClassReader reader) {
        CheckingVisitor cv = new CheckingVisitor();
        InstrumentUtils.accept(reader, cv);
        return cv.isCandidate();
    }

    public static boolean isSubTypeOf(Class clazz, String typeName) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(typeName)) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!ClassFilter.isSubTypeOf(iface, typeName)) continue;
            return true;
        }
        return ClassFilter.isSubTypeOf(clazz.getSuperclass(), typeName);
    }

    private void init(List<OnMethod> onMethods) {
        ArrayList<String> strSrcList = new ArrayList<String>();
        ArrayList<Pattern> patSrcList = new ArrayList<Pattern>();
        ArrayList<String> superTypesList = new ArrayList<String>();
        ArrayList<String> superTypesInternalList = new ArrayList<String>();
        ArrayList<String> strAnoList = new ArrayList<String>();
        ArrayList<Pattern> patAnoList = new ArrayList<Pattern>();
        for (OnMethod om : onMethods) {
            Pattern p;
            String className = om.getClazz();
            if (className.length() == 0) continue;
            char firstCh = className.charAt(0);
            if (firstCh == '/' && Constants.REGEX_SPECIFIER.matcher(className).matches()) {
                p = Pattern.compile(className.substring(1, className.length() - 1));
                patSrcList.add(p);
                continue;
            }
            if (firstCh == '@') {
                if (Constants.REGEX_SPECIFIER.matcher(className = className.substring(1)).matches()) {
                    p = Pattern.compile(className.substring(1, className.length() - 1));
                    patAnoList.add(p);
                    continue;
                }
                strAnoList.add(className);
                continue;
            }
            if (firstCh == '+') {
                String superType = className.substring(1);
                superTypesList.add(superType);
                superTypesInternalList.add(superType.replace('.', '/'));
                continue;
            }
            strSrcList.add(className);
        }
        this.sourceClasses = new String[strSrcList.size()];
        strSrcList.toArray(this.sourceClasses);
        this.sourceClassPatterns = new Pattern[patSrcList.size()];
        patSrcList.toArray(this.sourceClassPatterns);
        this.superTypes = new String[superTypesList.size()];
        superTypesList.toArray(this.superTypes);
        this.superTypesInternal = new String[superTypesInternalList.size()];
        superTypesInternalList.toArray(this.superTypesInternal);
        this.annotationClasses = new String[strAnoList.size()];
        strAnoList.toArray(this.annotationClasses);
        this.annotationClassPatterns = new Pattern[patAnoList.size()];
        patAnoList.toArray(this.annotationClassPatterns);
    }

    static {
        CheckingVisitor.class.getClass();
        ClassReader.class.getClass();
        NullVisitor.class.getClass();
        AnnotationVisitor.class.getClass();
        FieldVisitor.class.getClass();
        MethodVisitor.class.getClass();
        Attribute.class.getClass();
    }

    private class CheckingVisitor
    implements ClassVisitor {
        private boolean isInterface;
        private boolean isCandidate;
        private NullVisitor nullVisitor = new NullVisitor();

        private CheckingVisitor() {
        }

        boolean isCandidate() {
            return this.isCandidate;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 0x200) != 0) {
                this.isInterface = true;
                this.isCandidate = false;
                return;
            }
            name = name.replace('/', '.');
            for (String className : ClassFilter.this.sourceClasses) {
                if (!className.equals(name)) continue;
                this.isCandidate = true;
                return;
            }
            for (Pattern pat : ClassFilter.this.sourceClassPatterns) {
                if (!pat.matcher(name).matches()) continue;
                this.isCandidate = true;
                return;
            }
            for (String st : ClassFilter.this.superTypesInternal) {
                if (superName.equals(st)) {
                    this.isCandidate = true;
                    return;
                }
                for (String iface : interfaces) {
                    if (!iface.equals(st)) continue;
                    this.isCandidate = true;
                    return;
                }
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.isInterface) {
                return this.nullVisitor;
            }
            if (Constants.BTRACE_DESC.equals(desc)) {
                this.isCandidate = false;
                return this.nullVisitor;
            }
            if (!this.isCandidate) {
                String annoName = Type.getType(desc).getClassName();
                for (String name : ClassFilter.this.annotationClasses) {
                    if (!annoName.equals(name)) continue;
                    this.isCandidate = true;
                    return this.nullVisitor;
                }
                for (Pattern pat : ClassFilter.this.annotationClassPatterns) {
                    if (!pat.matcher(annoName).matches()) continue;
                    this.isCandidate = true;
                    return this.nullVisitor;
                }
            }
            return this.nullVisitor;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }
    }
}

