/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.runtime.Constants;

public class InstrumentUtils {
    public static String arrayDescriptorFor(int typeCode) {
        switch (typeCode) {
            case 4: {
                return "[Z";
            }
            case 5: {
                return "[C";
            }
            case 6: {
                return "[F";
            }
            case 7: {
                return "[D";
            }
            case 8: {
                return "[B";
            }
            case 9: {
                return "[S";
            }
            case 10: {
                return "[I";
            }
            case 11: {
                return "[J";
            }
        }
        throw new IllegalArgumentException();
    }

    public static void accept(ClassReader reader, ClassVisitor visitor) {
        InstrumentUtils.accept(reader, visitor, 4);
    }

    public static void accept(ClassReader reader, ClassVisitor visitor, int flags) {
        reader.accept(visitor, flags);
    }

    private static boolean isJDK16OrAbove(byte[] code) {
        int majorOffset = 6;
        int major = code[6] << 8 & 0xFF00 | code[7] & 0xFF;
        return major >= 50;
    }

    public static ClassWriter newClassWriter() {
        return InstrumentUtils.newClassWriter(null, 3);
    }

    public static ClassWriter newClassWriter(byte[] code) {
        int flags = 1;
        if (InstrumentUtils.isJDK16OrAbove(code)) {
            flags |= 2;
        }
        return InstrumentUtils.newClassWriter(null, flags);
    }

    public static ClassWriter newClassWriter(ClassReader reader, int flags) {
        if (reader != null) {
            return new ClassWriter(reader, flags){

                @Override
                protected String getCommonSuperClass(String type1, String type2) {
                    try {
                        return super.getCommonSuperClass(type1, type2);
                    }
                    catch (LinkageError le) {
                        return Constants.JAVA_LANG_OBJECT;
                    }
                    catch (RuntimeException re) {
                        return Constants.JAVA_LANG_OBJECT;
                    }
                }
            };
        }
        return new ClassWriter(flags){

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                try {
                    return super.getCommonSuperClass(type1, type2);
                }
                catch (LinkageError le) {
                    return Constants.JAVA_LANG_OBJECT;
                }
                catch (RuntimeException re) {
                    return Constants.JAVA_LANG_OBJECT;
                }
            }
        };
    }
}

