/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.TypeUtils;

public class MethodInstrumentor
extends MethodAdapter {
    public static final String JAVA_LANG_THREAD_LOCAL = Type.getInternalName(ThreadLocal.class);
    public static final String JAVA_LANG_THREAD_LOCAL_GET = "get";
    public static final String JAVA_LANG_THREAD_LOCAL_GET_DESC = "()Ljava/lang/Object;";
    public static final String JAVA_LANG_THREAD_LOCAL_SET = "set";
    public static final String JAVA_LANG_THREAD_LOCAL_SET_DESC = "(Ljava/lang/Object;)V";
    public static final String JAVA_LANG_STRING = Type.getInternalName(String.class);
    public static final String JAVA_LANG_STRING_DESC = Type.getDescriptor(String.class);
    public static final String JAVA_LANG_NUMBER = Type.getInternalName(Number.class);
    public static final String JAVA_LANG_BOOLEAN = Type.getInternalName(Boolean.class);
    public static final String JAVA_LANG_CHARACTER = Type.getInternalName(Character.class);
    public static final String JAVA_LANG_BYTE = Type.getInternalName(Byte.class);
    public static final String JAVA_LANG_SHORT = Type.getInternalName(Short.class);
    public static final String JAVA_LANG_INTEGER = Type.getInternalName(Integer.class);
    public static final String JAVA_LANG_LONG = Type.getInternalName(Long.class);
    public static final String JAVA_LANG_FLOAT = Type.getInternalName(Float.class);
    public static final String JAVA_LANG_DOUBLE = Type.getInternalName(Double.class);
    public static final String BOX_VALUEOF = "valueOf";
    public static final String BOX_BOOLEAN_DESC = "(Z)Ljava/lang/Boolean;";
    public static final String BOX_CHARACTER_DESC = "(C)Ljava/lang/Character;";
    public static final String BOX_BYTE_DESC = "(B)Ljava/lang/Byte;";
    public static final String BOX_SHORT_DESC = "(S)Ljava/lang/Short;";
    public static final String BOX_INTEGER_DESC = "(I)Ljava/lang/Integer;";
    public static final String BOX_LONG_DESC = "(J)Ljava/lang/Long;";
    public static final String BOX_FLOAT_DESC = "(F)Ljava/lang/Float;";
    public static final String BOX_DOUBLE_DESC = "(D)Ljava/lang/Double;";
    public static final String BOOLEAN_VALUE = "booleanValue";
    public static final String CHAR_VALUE = "charValue";
    public static final String BYTE_VALUE = "byteValue";
    public static final String SHORT_VALUE = "shortValue";
    public static final String INT_VALUE = "intValue";
    public static final String LONG_VALUE = "longValue";
    public static final String FLOAT_VALUE = "floatValue";
    public static final String DOUBLE_VALUE = "doubleValue";
    public static final String BOOLEAN_VALUE_DESC = "()Z";
    public static final String CHAR_VALUE_DESC = "()C";
    public static final String BYTE_VALUE_DESC = "()B";
    public static final String SHORT_VALUE_DESC = "()S";
    public static final String INT_VALUE_DESC = "()I";
    public static final String LONG_VALUE_DESC = "()J";
    public static final String FLOAT_VALUE_DESC = "()F";
    public static final String DOUBLE_VALUE_DESC = "()D";
    private final int access;
    private final String name;
    private final String desc;
    private Type returnType;
    private Type[] argumentTypes;

    public MethodInstrumentor(MethodVisitor mv, int access, String name, String desc) {
        super(mv);
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.returnType = Type.getReturnType(desc);
        this.argumentTypes = Type.getArgumentTypes(desc);
    }

    public int getAccess() {
        return this.access;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescriptor() {
        return this.desc;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void loadArgument(int arg) {
        this.loadLocal(this.argumentTypes[arg], this.getArgumentIndex(arg));
    }

    public void loadArguments(int arg, int count, int selfParam, int returnParam, int retOpCode) {
        int loadedIndex = 0;
        int index = this.getArgumentIndex(arg);
        for (int i = 0; i < count; ++i) {
            if (loadedIndex == selfParam) {
                if (this.isStatic()) continue;
                this.loadThis();
                continue;
            }
            if (loadedIndex == returnParam) {
                this.dupReturnValue(retOpCode);
                continue;
            }
            ++loadedIndex;
            Type t = this.argumentTypes[arg + i];
            this.loadLocal(t, index);
            index += t.getSize();
        }
        if (loadedIndex == selfParam) {
            if (!this.isStatic()) {
                this.loadThis();
            }
        } else if (loadedIndex == returnParam) {
            this.dupReturnValue(retOpCode);
        }
    }

    public void loadArguments(OnMethod onMethod) {
        this.loadArguments(onMethod, Integer.MIN_VALUE);
    }

    public void loadArguments(OnMethod onMethod, int retOpCode) {
        this.loadArguments(0, this.argumentTypes.length, onMethod.getSelfParameter(), onMethod.getReturnParameter(), retOpCode);
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' inside static method");
        }
        super.visitVarInsn(25, 0);
    }

    public int loadArgumentArray() {
        int count = this.argumentTypes.length;
        boolean isStatic = (this.access & 8) != 0;
        this.push(count);
        super.visitTypeInsn(189, TypeUtils.objectType.getInternalName());
        int start = isStatic ? 0 : 1;
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.dup();
            this.push(i + start);
            this.loadArgument(i);
            this.box(this.argumentTypes[i]);
            this.arrayStore(TypeUtils.objectType);
        }
        return count;
    }

    protected final boolean isStatic() {
        return (this.getAccess() & 8) != 0;
    }

    protected final boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public void returnValue() {
        super.visitInsn(this.returnType.getOpcode(172));
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            super.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            super.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            super.visitIntInsn(17, value);
        } else {
            super.visitLdcInsn(value);
        }
    }

    public void arrayLoad(Type type2) {
        super.visitInsn(type2.getOpcode(46));
    }

    public void arrayStore(Type type2) {
        super.visitInsn(type2.getOpcode(79));
    }

    public void loadLocal(Type type2, int index) {
        super.visitVarInsn(type2.getOpcode(21), index);
    }

    public void storeLocal(Type type2, int index) {
        super.visitVarInsn(type2.getOpcode(54), index);
    }

    public void pop() {
        super.visitInsn(87);
    }

    public void dup() {
        super.visitInsn(89);
    }

    public void dup2() {
        super.visitInsn(92);
    }

    public void dupArrayValue(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.dup();
                break;
            }
            case 47: 
            case 49: 
            case 80: 
            case 82: {
                this.dup2();
            }
        }
    }

    public void dupReturnValue(int returnOpcode) {
        switch (returnOpcode) {
            case 172: 
            case 174: 
            case 176: {
                super.visitInsn(89);
                return;
            }
            case 173: 
            case 175: {
                super.visitInsn(92);
                return;
            }
            case 177: {
                return;
            }
        }
        throw new IllegalArgumentException("not return");
    }

    public void dupValue(Type type2) {
        switch (type2.getSize()) {
            case 1: {
                this.dup();
                break;
            }
            case 2: {
                this.dup2();
            }
        }
    }

    public void dupValue(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                super.visitInsn(89);
                break;
            }
            case 'D': 
            case 'J': {
                super.visitInsn(92);
                break;
            }
            default: {
                throw new RuntimeException("invalid signature");
            }
        }
    }

    public void box(Type type2) {
        this.box(type2.getDescriptor());
    }

    public void box(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                break;
            }
            case 'Z': {
                super.visitMethodInsn(184, JAVA_LANG_BOOLEAN, BOX_VALUEOF, BOX_BOOLEAN_DESC);
                break;
            }
            case 'C': {
                super.visitMethodInsn(184, JAVA_LANG_CHARACTER, BOX_VALUEOF, BOX_CHARACTER_DESC);
                break;
            }
            case 'B': {
                super.visitMethodInsn(184, JAVA_LANG_BYTE, BOX_VALUEOF, BOX_BYTE_DESC);
                break;
            }
            case 'S': {
                super.visitMethodInsn(184, JAVA_LANG_SHORT, BOX_VALUEOF, BOX_SHORT_DESC);
                break;
            }
            case 'I': {
                super.visitMethodInsn(184, JAVA_LANG_INTEGER, BOX_VALUEOF, BOX_INTEGER_DESC);
                break;
            }
            case 'J': {
                super.visitMethodInsn(184, JAVA_LANG_LONG, BOX_VALUEOF, BOX_LONG_DESC);
                break;
            }
            case 'F': {
                super.visitMethodInsn(184, JAVA_LANG_FLOAT, BOX_VALUEOF, BOX_FLOAT_DESC);
                break;
            }
            case 'D': {
                super.visitMethodInsn(184, JAVA_LANG_DOUBLE, BOX_VALUEOF, BOX_DOUBLE_DESC);
            }
        }
    }

    public void unbox(Type type2) {
        this.unbox(type2.getDescriptor());
    }

    public void unbox(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                super.visitTypeInsn(192, Type.getType(desc).getInternalName());
                break;
            }
            case 'Z': {
                super.visitTypeInsn(192, JAVA_LANG_BOOLEAN);
                super.visitMethodInsn(182, JAVA_LANG_BOOLEAN, BOOLEAN_VALUE, BOOLEAN_VALUE_DESC);
                break;
            }
            case 'C': {
                super.visitTypeInsn(192, JAVA_LANG_CHARACTER);
                super.visitMethodInsn(182, JAVA_LANG_CHARACTER, CHAR_VALUE, CHAR_VALUE_DESC);
                break;
            }
            case 'B': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, BYTE_VALUE, BYTE_VALUE_DESC);
                break;
            }
            case 'S': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, SHORT_VALUE, SHORT_VALUE_DESC);
                break;
            }
            case 'I': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, INT_VALUE, INT_VALUE_DESC);
                break;
            }
            case 'J': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, LONG_VALUE, LONG_VALUE_DESC);
                break;
            }
            case 'F': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, FLOAT_VALUE, FLOAT_VALUE_DESC);
                break;
            }
            case 'D': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, DOUBLE_VALUE, DOUBLE_VALUE_DESC);
            }
        }
    }

    public void defaultValue(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                super.visitInsn(1);
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                super.visitInsn(3);
                break;
            }
            case 'J': {
                super.visitInsn(9);
                break;
            }
            case 'F': {
                super.visitInsn(11);
                break;
            }
            case 'D': {
                super.visitInsn(14);
            }
        }
    }

    public void println(String msg) {
        super.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        super.visitLdcInsn(msg);
        super.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public void printObject() {
        super.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        super.visitInsn(95);
        super.visitMethodInsn(182, "java/io/PrintStream", "println", JAVA_LANG_THREAD_LOCAL_SET_DESC);
    }

    public void invokeVirtual(String owner, String method, String desc) {
        super.visitMethodInsn(182, owner, method, desc);
    }

    public void invokeSpecial(String owner, String method, String desc) {
        super.visitMethodInsn(183, owner, method, desc);
    }

    public void invokeStatic(String owner, String method, String desc) {
        super.visitMethodInsn(184, owner, method, desc);
    }

    private int getArgumentIndex(int arg) {
        int index = (this.access & 8) == 0 ? 1 : 0;
        for (int i = 0; i < arg; ++i) {
            index += this.argumentTypes[i].getSize();
        }
        return index;
    }
}

