/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.orbutil.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.spi.orbutil.logex.Chain;
import com.sun.corba.ee.spi.orbutil.logex.ExceptionWrapper;
import com.sun.corba.ee.spi.orbutil.logex.Log;
import com.sun.corba.ee.spi.orbutil.logex.LogLevel;
import com.sun.corba.ee.spi.orbutil.logex.Message;
import com.sun.corba.ee.spi.orbutil.logex.WrapperGenerator;
import com.sun.corba.ee.spi.orbutil.logex.stdcorba.StandardLogger;

@ExceptionWrapper(idPrefix="ORBTPOOL")
public interface Exceptions {
    public static final Exceptions self = WrapperGenerator.makeWrapper(Exceptions.class, StandardLogger.self);
    public static final int EXCEPTIONS_PER_CLASS = 100;
    public static final int TP_START = 1;
    public static final int TPM_START = 101;
    public static final int TSV_START = 201;

    @Message(value="Join was interrrupted on thread {0} while closing ThreadPool {1}")
    @Log(id=1)
    public void interruptedJoinCallWhileClosingThreadPool(@Chain InterruptedException var1, Thread var2, ThreadPoolImpl var3);

    @Message(value="Worker Thread {0} has been created with ClassLoader {1}")
    @Log(id=1, level=LogLevel.FINE)
    public void workerThreadCreated(Thread var1, ClassLoader var2);

    @Message(value="Worker thread creation failure")
    @Log(id=2, level=LogLevel.SEVERE)
    public void workerThreadCreationFailure(@Chain Throwable var1);

    @Message(value="Unable to get worker thread {0}; check securiy policy file: must grant 'getContextClassLoader' runtime permission")
    @Log(id=3)
    public RuntimeException workerThreadGetContextClassloaderFailed(@Chain SecurityException var1, Thread var2);

    @Message(value="Worker thread {0} context ClassLoader was changed to {1}; will attempt a reset to its initial ClassLoader {2} ")
    @Log(id=4, level=LogLevel.FINE)
    public void workerThreadForgotClassloaderReset(Thread var1, ClassLoader var2, ClassLoader var3);

    @Message(value="Unable to set worker thread {0}; check securiy policy file: must grant 'setContextClassLoader' runtime permission")
    @Log(id=6)
    public void workerThreadResetContextClassloaderFailed(@Chain SecurityException var1, Thread var2);

    @Message(value="Worker thread {0} caught throwable while executing work.")
    @Log(id=7)
    public void workerThreadDoWorkThrowable(@Chain Throwable var1, Thread var2);

    @Message(value="Worker thread {0} will exit; current thread count {1} is greater than minimum worker threads needed {2}")
    @Log(id=8, level=LogLevel.FINE)
    public void workerThreadNotNeeded(Thread var1, int var2, int var3);

    @Message(value="Worker thread from thread pool {0} was interrupted: closeCalled is {1}")
    @Log(id=9, level=LogLevel.FINE)
    public void workQueueThreadInterrupted(InterruptedException var1, String var2, Boolean var3);

    @Message(value="Worker thread {0} caught throwable when requesting work from work queue {1}")
    @Log(id=10, level=LogLevel.FINE)
    public void workerThreadThrowableFromRequestWork(@Chain Throwable var1, Thread var2, String var3);

    @Message(value="Worker thread {0} caught unexpected throwable")
    @Log(id=11)
    public void workerThreadCaughtUnexpectedThrowable(@Chain Throwable var1, Thread var2);

    @Message(value="Error in closing ThreadPool")
    @Log(id=101)
    public void threadPoolCloseError();

    @Message(value="ThreadGroup {0} is already destroyed; cannot destroy it again")
    @Log(id=102)
    public void threadGroupIsDestroyed(ThreadGroup var1);

    @Message(value="ThreadGroup {0} has {1} active threads: destroy may cause exceptions")
    @Log(id=103)
    public void threadGroupHasActiveThreadsInClose(ThreadGroup var1, int var2);

    @Message(value="ThreadGroup {0} has {1} sub-ThreadGroups: destroy may cause exceptions")
    @Log(id=104)
    public void threadGroupHasSubGroupsInClose(ThreadGroup var1, int var2);

    @Message(value="ThreadGroup {0} could not be destroyed")
    @Log(id=105)
    public void threadGroupDestroyFailed(@Chain IllegalThreadStateException var1, ThreadGroup var2);

    @Message(value="Thread state validator threw an exception on validator {0}")
    @Log(id=201)
    public RuntimeException threadStateValidatorException(Runnable var1, @Chain Throwable var2);
}

