/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.fsm;

import com.sun.corba.ee.spi.orbutil.fsm.Action;
import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.NameBase;
import com.sun.corba.ee.spi.orbutil.fsm.Transition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class State
extends NameBase {
    private Kind kind;
    private Action defaultAction;
    private State defaultNextState;
    private Map<Input, Set<Transition>> inputMap;
    private Map<Input, Set<Transition>> inputMapImage;

    public State(String name) {
        this(name, Kind.NORMAL);
    }

    public State(String name, Kind kind) {
        this(null, name, kind);
    }

    public State(Set<State> states, String name) {
        this(states, name, Kind.NORMAL);
    }

    public State(Set<State> states, String name, Kind kind) {
        super(name);
        if (states != null) {
            states.add(this);
        }
        this.kind = kind;
        this.defaultAction = null;
        this.inputMap = new HashMap<Input, Set<Transition>>();
        this.inputMapImage = Collections.unmodifiableMap(this.inputMap);
    }

    public Kind getKind() {
        return this.kind;
    }

    public FSM preAction(FSM fsm) {
        return null;
    }

    public State returnAction(FSM fsm, FSM nestedFSM) {
        return null;
    }

    public void postAction(FSM fsm) {
    }

    public State getDefaultNextState() {
        return this.defaultNextState;
    }

    public Action getDefaultAction() {
        return this.defaultAction;
    }

    public Map<Input, Set<Transition>> getInputMap() {
        return this.inputMapImage;
    }

    void setDefaultNextState(State defaultNextState) {
        this.defaultNextState = defaultNextState;
    }

    void setDefaultAction(Action defaultAction) {
        this.defaultAction = defaultAction;
    }

    void addTransition(Input in, Transition ga) {
        Set<Transition> gas = this.inputMap.get(in);
        if (gas == null) {
            gas = new HashSet<Transition>();
            this.inputMap.put(in, gas);
        }
        gas.add(ga);
    }

    Set<Transition> getTransitions(Input in) {
        return this.inputMap.get(in);
    }

    public static enum Kind {
        INITIAL,
        NORMAL,
        REFERENCE,
        FINAL;

    }
}

