/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.misc;

import java.util.Arrays;

public abstract class ObjectWriter {
    protected StringBuffer result = new StringBuffer();

    public static ObjectWriter make(boolean isIndenting, int initialLevel, int increment) {
        if (isIndenting) {
            return new IndentingObjectWriter(initialLevel, increment);
        }
        return new SimpleObjectWriter();
    }

    public abstract void startObject(Object var1);

    public abstract void startElement();

    public abstract void endElement();

    public abstract void endObject(String var1);

    public abstract void endObject();

    public String toString() {
        return this.result.toString();
    }

    public void append(boolean arg) {
        this.result.append(arg);
    }

    public void append(char arg) {
        this.result.append(arg);
    }

    public void append(short arg) {
        this.result.append(arg);
    }

    public void append(int arg) {
        this.result.append(arg);
    }

    public void append(long arg) {
        this.result.append(arg);
    }

    public void append(float arg) {
        this.result.append(arg);
    }

    public void append(double arg) {
        this.result.append(arg);
    }

    public void append(String arg) {
        this.result.append(arg);
    }

    protected ObjectWriter() {
    }

    protected void appendObjectHeader(Object obj) {
        this.result.append(obj.getClass().getName());
        this.result.append("<");
        this.result.append(System.identityHashCode(obj));
        this.result.append(">");
        Class<?> compClass = obj.getClass().getComponentType();
        if (compClass != null) {
            this.result.append("[");
            if (compClass == Boolean.TYPE) {
                boolean[] arr = (boolean[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Byte.TYPE) {
                byte[] arr = (byte[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Short.TYPE) {
                short[] arr = (short[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Integer.TYPE) {
                int[] arr = (int[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Long.TYPE) {
                long[] arr = (long[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Character.TYPE) {
                char[] arr = (char[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Float.TYPE) {
                float[] arr = (float[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else if (compClass == Double.TYPE) {
                double[] arr = (double[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            } else {
                Object[] arr = (Object[])obj;
                this.result.append(arr.length);
                this.result.append("]");
            }
        }
        this.result.append("(");
    }

    private static class SimpleObjectWriter
    extends ObjectWriter {
        private SimpleObjectWriter() {
        }

        @Override
        public void startObject(Object obj) {
            this.appendObjectHeader(obj);
            this.result.append(" ");
        }

        @Override
        public void startElement() {
            this.result.append(" ");
        }

        @Override
        public void endObject(String str) {
            this.result.append(str);
            this.result.append(")");
        }

        @Override
        public void endElement() {
        }

        @Override
        public void endObject() {
            this.result.append(")");
        }
    }

    private static class IndentingObjectWriter
    extends ObjectWriter {
        private int level;
        private int increment;

        public IndentingObjectWriter(int initialLevel, int increment) {
            this.level = initialLevel;
            this.increment = increment;
            this.startLine();
        }

        private void startLine() {
            char[] fill = new char[this.level * this.increment];
            Arrays.fill(fill, ' ');
            this.result.append(fill);
        }

        @Override
        public void startObject(Object obj) {
            this.appendObjectHeader(obj);
            ++this.level;
        }

        @Override
        public void startElement() {
            this.result.append("\n");
            this.startLine();
        }

        @Override
        public void endElement() {
        }

        @Override
        public void endObject(String str) {
            --this.level;
            this.result.append(str);
            this.result.append(")");
        }

        @Override
        public void endObject() {
            --this.level;
            this.result.append("\n");
            this.startLine();
            this.result.append(")");
        }
    }
}

