/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.proxy;

import com.sun.corba.ee.spi.orbutil.proxy.CompositeInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompositeInvocationHandlerImpl
implements CompositeInvocationHandler {
    private Map<Class<?>, InvocationHandler> classToInvocationHandler = new LinkedHashMap();
    private InvocationHandler defaultHandler = null;

    @Override
    public void addInvocationHandler(Class<?> interf, InvocationHandler handler) {
        this.classToInvocationHandler.put(interf, handler);
    }

    @Override
    public void setDefaultHandler(InvocationHandler handler) {
        this.defaultHandler = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> cls = method.getDeclaringClass();
        if (cls.equals(Object.class)) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (Exception exc) {
                throw new RuntimeException("Invocation error on Object method", exc);
            }
        }
        InvocationHandler handler = this.classToInvocationHandler.get(cls);
        if (handler == null) {
            if (this.defaultHandler != null) {
                handler = this.defaultHandler;
            } else {
                throw new RuntimeException("No invocation handler for method \"" + method.toString() + "\"");
            }
        }
        return handler.invoke(proxy, method, args);
    }
}

