/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.corba.ee.spi.orbutil.codegen.Wrapper;
import com.sun.ejb.base.io.IOUtils;
import com.sun.ejb.codegen.AsmSerializableBeanGenerator;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GenericHomeGenerator;
import com.sun.ejb.codegen.Remote30WrapperGenerator;
import com.sun.ejb.codegen.RemoteGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.GenericEJBLocalHome;
import com.sun.ejb.containers.RemoteBusinessWrapperBase;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBUtils {
    private static final Logger _logger = LogDomains.getLogger(EJBUtils.class, "javax.enterprise.system.container.ejb");
    private static final String EJB_USE_STATIC_CODEGEN_PROP = "com.sun.ejb.UseStaticCodegen";
    private static final String REMOTE30_HOME_JNDI_SUFFIX = "__3_x_Internal_RemoteBusinessHome__";
    private static Boolean ejbUseStaticCodegen_ = null;
    private static final String CORBA_INS_PREFIX = "corbaname:";
    private static final String JAVA_GLOBAL_PREFIX = "java:global/";
    private static final String PORTABLE_JNDI_NAME_SEP = "!";
    private static final String GLASSFISH_JNDI_NAME_SEP = "#";

    public static final byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        return IOUtils.serializeObject(obj, replaceObject);
    }

    public static final byte[] serializeObject(Object obj) throws IOException {
        return IOUtils.serializeObject(obj, true);
    }

    public static final Object deserializeObject(byte[] data, ClassLoader loader, boolean resolveObject) throws Exception {
        return IOUtils.deserializeObject(data, resolveObject, loader);
    }

    public static final Object deserializeObject(byte[] data, ClassLoader loader) throws Exception {
        return IOUtils.deserializeObject(data, true, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useStaticCodegen() {
        Class<EJBUtils> clazz = EJBUtils.class;
        synchronized (EJBUtils.class) {
            if (ejbUseStaticCodegen_ == null) {
                String ejbStaticCodegenProp = null;
                ejbStaticCodegenProp = System.getSecurityManager() == null ? System.getProperty(EJB_USE_STATIC_CODEGEN_PROP) : (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(EJBUtils.EJB_USE_STATIC_CODEGEN_PROP);
                    }
                });
                boolean useStaticCodegen = ejbStaticCodegenProp != null && ejbStaticCodegenProp.equalsIgnoreCase("true");
                ejbUseStaticCodegen_ = new Boolean(useStaticCodegen);
                _logger.log(Level.FINE, "EJB Static codegen is " + (useStaticCodegen ? "ENABLED" : "DISABLED") + " ejbUseStaticCodegenProp = " + ejbStaticCodegenProp);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ejbUseStaticCodegen_;
        }
    }

    private static String getClassPackageName(String intf) {
        int dot = intf.lastIndexOf(46);
        return dot == -1 ? null : intf.substring(0, dot);
    }

    private static String getClassSimpleName(String intf) {
        int dot = intf.lastIndexOf(46);
        return dot == -1 ? intf : intf.substring(dot + 1);
    }

    public static String getGeneratedOptionalInterfaceName(String ejbClassName) {
        String packageName = EJBUtils.getClassPackageName(ejbClassName);
        String simpleName = EJBUtils.getClassSimpleName(ejbClassName);
        String optionalIntfName = "__EJB31_Generated__" + simpleName + "__Intf__";
        return packageName != null ? packageName + "." + optionalIntfName : optionalIntfName;
    }

    public static String getGeneratedSerializableClassName(String beanClass) {
        String packageName = EJBUtils.getClassPackageName(beanClass);
        String simpleName = EJBUtils.getClassSimpleName(beanClass);
        String generatedSimpleName = "_" + simpleName + "_Serializable";
        return packageName != null ? packageName + "." + generatedSimpleName : generatedSimpleName;
    }

    public static String getGeneratedRemoteIntfName(String businessIntf) {
        String packageName = EJBUtils.getClassPackageName(businessIntf);
        String simpleName = EJBUtils.getClassSimpleName(businessIntf);
        String generatedSimpleName = "_" + simpleName + "_Remote";
        return packageName != null ? packageName + "." + generatedSimpleName : generatedSimpleName;
    }

    public static String getGeneratedRemoteWrapperName(String businessIntf) {
        String packageName = EJBUtils.getClassPackageName(businessIntf);
        String simpleName = EJBUtils.getClassSimpleName(businessIntf);
        String generatedSimpleName = "_" + simpleName + "_Wrapper";
        return packageName != null ? packageName + "." + generatedSimpleName : generatedSimpleName;
    }

    public static String getGenericEJBHomeClassName() {
        return "com.sun.ejb.codegen.GenericEJBHome_Generated";
    }

    public static String getRemoteEjbJndiName(EjbReferenceDescriptor refDesc) {
        String intf = refDesc.isEJB30ClientView() ? refDesc.getEjbInterface() : refDesc.getHomeClassName();
        return EJBUtils.getRemoteEjbJndiName(refDesc.isEJB30ClientView(), intf, refDesc.getJndiName());
    }

    public static String getRemote30HomeJndiName(String jndiName) {
        return jndiName + REMOTE30_HOME_JNDI_SUFFIX;
    }

    public static String getRemoteEjbJndiName(boolean businessView, String interfaceName, String jndiName) {
        String returnValue = jndiName;
        String portableFullyQualifiedPortion = PORTABLE_JNDI_NAME_SEP + interfaceName;
        String glassfishFullyQualifiedPortion = GLASSFISH_JNDI_NAME_SEP + interfaceName;
        if (businessView) {
            if (jndiName.startsWith(CORBA_INS_PREFIX)) {
                int indexOfCorbaNameSep = jndiName.indexOf(GLASSFISH_JNDI_NAME_SEP);
                String jndiNameMinusCorbaNamePortion = jndiName.substring(indexOfCorbaNameSep + 1);
                String newJndiName = jndiName;
                if (jndiNameMinusCorbaNamePortion.startsWith(JAVA_GLOBAL_PREFIX)) {
                    newJndiName = EJBUtils.stripFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
                } else if (jndiNameMinusCorbaNamePortion.endsWith(glassfishFullyQualifiedPortion)) {
                    newJndiName = EJBUtils.stripFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
                }
                returnValue = EJBUtils.getRemote30HomeJndiName(newJndiName);
            } else {
                returnValue = jndiName.startsWith(JAVA_GLOBAL_PREFIX) ? EJBUtils.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion) : EJBUtils.checkFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
            }
        } else if (jndiName.startsWith(JAVA_GLOBAL_PREFIX)) {
            returnValue = EJBUtils.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
        }
        return returnValue;
    }

    private static String checkFullyQualifiedJndiName(String origJndiName, String fullyQualifiedPortion) {
        String returnValue = origJndiName;
        if (!origJndiName.endsWith(fullyQualifiedPortion)) {
            returnValue = origJndiName + fullyQualifiedPortion;
        }
        return returnValue;
    }

    private static String stripFullyQualifiedJndiName(String origJndiName, String fullyQualifiedPortion) {
        String returnValue = origJndiName;
        if (origJndiName.endsWith(fullyQualifiedPortion)) {
            int portionLength = fullyQualifiedPortion.length();
            returnValue = origJndiName.substring(0, origJndiName.length() - portionLength);
        }
        return returnValue;
    }

    public static Object resolveEjbRefObject(EjbReferenceDescriptor refDesc, Object jndiObj) throws NamingException {
        Object returnObject = jndiObj;
        if (refDesc.isLocal()) {
            EjbDescriptor target = refDesc.getEjbDescriptor();
            BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(target.getUniqueId());
            if (refDesc.isEJB30ClientView()) {
                GenericEJBLocalHome genericLocalHome = container.getEJBLocalBusinessHome(refDesc.getEjbInterface());
                returnObject = genericLocalHome.create(refDesc.getEjbInterface());
            } else {
                returnObject = container.getEJBLocalHome();
            }
        } else if (refDesc.isEJB30ClientView() && !(jndiObj instanceof RemoteBusinessWrapperBase)) {
            returnObject = EJBUtils.lookupRemote30BusinessObject(jndiObj, refDesc.getEjbInterface());
        }
        return returnObject;
    }

    public static Object lookupRemote30BusinessObject(Object jndiObj, String businessInterface) throws NamingException {
        RemoteBusinessWrapperBase returnObject = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class genericEJBHome = EJBUtils.loadGeneratedGenericEJBHomeClass(loader);
            Object genericHomeObj = PortableRemoteObject.narrow((Object)jndiObj, (Class)genericEJBHome);
            EJBUtils.loadGeneratedRemoteBusinessClasses(businessInterface);
            String generatedRemoteIntfName = EJBUtils.getGeneratedRemoteIntfName(businessInterface);
            Method createMethod = genericEJBHome.getMethod("create", String.class);
            Remote delegate = (Remote)createMethod.invoke(genericHomeObj, generatedRemoteIntfName);
            returnObject = EJBUtils.createRemoteBusinessObject(loader, businessInterface, delegate);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("ejb ref resolution error for remote business interface" + businessInterface);
            ne.initCause(e instanceof InvocationTargetException ? e.getCause() : e);
            throw ne;
        }
        return returnObject;
    }

    public static Class loadGeneratedSerializableClass(ClassLoader loader, String className) throws Exception {
        String generatedSerializableClassName = EJBUtils.getGeneratedSerializableClassName(className);
        Class<?> developerClass = loader.loadClass(className);
        AsmSerializableBeanGenerator gen = new AsmSerializableBeanGenerator(loader, developerClass, generatedSerializableClassName);
        Class serializableClass = gen.generateSerializableSubclass();
        return serializableClass;
    }

    public static void loadGeneratedRemoteBusinessClasses(String businessInterfaceName) throws Exception {
        ClassLoader appClassLoader = EJBUtils.getBusinessIntfClassLoader(businessInterfaceName);
        EJBUtils.loadGeneratedRemoteBusinessClasses(appClassLoader, businessInterfaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGeneratedRemoteBusinessClasses(ClassLoader appClassLoader, String businessInterfaceName) throws Exception {
        String generatedRemoteIntfName = EJBUtils.getGeneratedRemoteIntfName(businessInterfaceName);
        String wrapperClassName = EJBUtils.getGeneratedRemoteWrapperName(businessInterfaceName);
        Class generatedRemoteIntf = null;
        try {
            generatedRemoteIntf = appClassLoader.loadClass(generatedRemoteIntfName);
        }
        catch (Exception e) {
            // empty catch block
        }
        Class generatedRemoteWrapper = null;
        try {
            generatedRemoteWrapper = appClassLoader.loadClass(wrapperClassName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (generatedRemoteIntf != null && generatedRemoteWrapper != null) {
            return;
        }
        Wrapper._setClassLoader((ClassLoader)appClassLoader);
        try {
            Class<?> developerClass;
            Generator gen;
            if (generatedRemoteIntf == null) {
                gen = new RemoteGenerator(appClassLoader, businessInterfaceName);
                developerClass = appClassLoader.loadClass(businessInterfaceName);
                generatedRemoteIntf = EJBUtils.generateAndLoad(gen, generatedRemoteIntfName, appClassLoader, developerClass);
            }
            if (generatedRemoteWrapper == null) {
                gen = new Remote30WrapperGenerator(appClassLoader, businessInterfaceName, generatedRemoteIntfName);
                developerClass = appClassLoader.loadClass(businessInterfaceName);
                generatedRemoteWrapper = EJBUtils.generateAndLoad(gen, wrapperClassName, appClassLoader, developerClass);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Wrapper._setClassLoader(null);
            throw throwable;
        }
        Wrapper._setClassLoader(null);
    }

    public static Class loadGeneratedGenericEJBHomeClass(ClassLoader appClassLoader) throws Exception {
        String className = EJBUtils.getGenericEJBHomeClassName();
        Class generatedGenericEJBHomeClass = null;
        try {
            generatedGenericEJBHomeClass = appClassLoader.loadClass(className);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (generatedGenericEJBHomeClass == null) {
            GenericHomeGenerator gen = new GenericHomeGenerator(appClassLoader);
            generatedGenericEJBHomeClass = EJBUtils.generateAndLoad(gen, className, appClassLoader, EJBUtils.class);
        }
        return generatedGenericEJBHomeClass;
    }

    public static Class generateSEI(ClassGeneratorFactory cgf, String seiClassName, ClassLoader loader, Class beanClass) {
        return EJBUtils.generateAndLoad(cgf, seiClassName, loader, beanClass);
    }

    private static Class generateAndLoad(ClassGeneratorFactory cgf, String actualClassName, final ClassLoader loader, final Class protectionDomainBase) {
        cgf.evaluate();
        final Properties props = new Properties();
        if (_logger.isLoggable(Level.FINE)) {
            props.put("com.sun.corba.codegen.debug.dumpAfterSetupVisitor", "true");
            props.put("com.sun.corba.codegen.debug.traceByteCodeGeneration", "true");
            props.put("com.sun.corba.codegen.debug.useAsmVerifier", "true");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                Wrapper._sourceCode((PrintStream)ps, (Properties)props);
                _logger.fine(baos.toString());
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "exception generating src", e);
            }
        }
        Class result = null;
        try {
            result = System.getSecurityManager() == null ? Wrapper._generate((ClassLoader)loader, (ProtectionDomain)protectionDomainBase.getProtectionDomain(), (Properties)props) : (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Wrapper._generate((ClassLoader)loader, (ProtectionDomain)protectionDomainBase.getProtectionDomain(), (Properties)props);
                }
            });
        }
        catch (RuntimeException runEx) {
            try {
                result = loader.loadClass(actualClassName);
                _logger.log(Level.FINE, "[EJBUtils] Got exception ex: " + runEx + " but loaded class: " + result.getName());
            }
            catch (ClassNotFoundException cnfEx) {
                throw runEx;
            }
        }
        return result;
    }

    public static RemoteBusinessWrapperBase createRemoteBusinessObject(String businessInterface, Remote delegate) throws Exception {
        ClassLoader appClassLoader = EJBUtils.getBusinessIntfClassLoader(businessInterface);
        return EJBUtils.createRemoteBusinessObject(appClassLoader, businessInterface, delegate);
    }

    public static RemoteBusinessWrapperBase createRemoteBusinessObject(ClassLoader loader, String businessInterface, Remote delegate) throws Exception {
        String wrapperClassName = EJBUtils.getGeneratedRemoteWrapperName(businessInterface);
        Class<?> clientWrapperClass = loader.loadClass(wrapperClassName);
        Constructor<?>[] ctors = clientWrapperClass.getConstructors();
        Constructor<?> ctor = null;
        for (Constructor<?> next : ctors) {
            if (next.getParameterTypes().length <= 0) continue;
            ctor = next;
            break;
        }
        Object obj = ctor.newInstance(delegate, businessInterface);
        return (RemoteBusinessWrapperBase)obj;
    }

    private static ClassLoader getBusinessIntfClassLoader(String businessInterface) throws Exception {
        ClassLoader cl;
        ClassLoader contextLoader = null;
        contextLoader = System.getSecurityManager() == null ? ((cl = Thread.currentThread().getContextClassLoader()) != null ? cl : ClassLoader.getSystemClassLoader()) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl : ClassLoader.getSystemClassLoader();
            }
        });
        final Class<?> businessInterfaceClass = contextLoader.loadClass(businessInterface);
        ClassLoader appClassLoader = null;
        appClassLoader = System.getSecurityManager() == null ? businessInterfaceClass.getClassLoader() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return businessInterfaceClass.getClassLoader();
            }
        });
        return appClassLoader;
    }

    private static boolean isEJB30Ref(EjbReferenceDescriptor refDesc) {
        return refDesc.isEJB30ClientView();
    }

    public static void serializeObjectFields(Object instance, ObjectOutputStream oos) throws IOException {
        Class<?> clazz = instance.getClass().getSuperclass();
        ObjectOutputStream objOutStream = oos;
        Iterator<Field> i$ = EJBUtils.getSerializationFields(clazz).iterator();
        while (i$.hasNext()) {
            Field next;
            final Field nextField = next = i$.next();
            final Object theInstance = instance;
            try {
                Object value = null;
                if (System.getSecurityManager() == null) {
                    if (!nextField.isAccessible()) {
                        nextField.setAccessible(true);
                    }
                    value = nextField.get(theInstance);
                } else {
                    value = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (!nextField.isAccessible()) {
                                nextField.setAccessible(true);
                            }
                            return nextField.get(theInstance);
                        }
                    });
                }
                objOutStream.writeObject(value);
            }
            catch (Throwable t) {
                IOException ioe = new IOException();
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                ioe.initCause(cause);
                throw ioe;
            }
        }
    }

    public static void deserializeObjectFields(Object instance, ObjectInputStream ois) throws IOException {
        Class<?> clazz = instance.getClass().getSuperclass();
        ObjectInputStream objInputStream = ois;
        for (Field next : EJBUtils.getSerializationFields(clazz)) {
            try {
                final Field nextField = next;
                final Object value = ois.readObject();
                final Object theInstance = instance;
                if (System.getSecurityManager() == null) {
                    if (!nextField.isAccessible()) {
                        nextField.setAccessible(true);
                    }
                    nextField.set(theInstance, value);
                    continue;
                }
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!nextField.isAccessible()) {
                            nextField.setAccessible(true);
                        }
                        nextField.set(theInstance, value);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                IOException ioe = new IOException();
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                ioe.initCause(cause);
                throw ioe;
            }
        }
    }

    private static Collection<Field> getSerializationFields(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        TreeMap<String, Field> sortedMap = new TreeMap<String, Field>();
        for (Field next : fields) {
            int modifiers = next.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            sortedMap.put(next.getName(), next);
        }
        return sortedMap.values();
    }
}

