/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseCache
implements Cache {
    protected static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    protected static ResourceBundle _rb = null;
    private static int MAX_BUCKETS = 65536;
    static final int MAX_ENTRIES = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    int maxEntries;
    protected int entryCount;
    protected Object entryCountLk = new Object();
    protected int threshold = 0;
    protected int hitCount;
    protected Object hitCountLk = new Object();
    protected int missCount;
    protected Object missCountLk = new Object();
    protected int removalCount;
    protected Object removalCountLk = new Object();
    protected int refreshCount;
    protected Object refreshCountLk = new Object();
    protected int addCount;
    protected Object addCountLk = new Object();
    protected int overflowCount;
    protected Object overflowCountLk = new Object();
    protected int maxBuckets;
    protected CacheItem[] buckets;
    protected Object[] bucketLocks;
    protected boolean[] refreshFlags;
    protected ArrayList listeners = new ArrayList();

    public void destroy() {
        if (this.listeners != null && this.buckets != null && this.bucketLocks != null) {
            this.clear();
            this.listeners.clear();
        }
        this.entryCountLk = null;
        this.hitCountLk = null;
        this.missCountLk = null;
        this.removalCountLk = null;
        this.refreshCountLk = null;
        this.addCountLk = null;
        this.overflowCountLk = null;
        this.buckets = null;
        this.bucketLocks = null;
        this.refreshFlags = null;
        this.listeners = null;
    }

    public void init(int maxEntries, Properties props) throws Exception {
        this.init(maxEntries, 0.75f, props);
    }

    public void init(int maxEntries, float loadFactor, Properties props) {
        _rb = LogDomains.getLogger(BaseCache.class, "javax.enterprise.system.container.ejb").getResourceBundle();
        if (maxEntries <= 0) {
            String msg = _rb.getString("cache.BaseCache.illegalMaxEntries");
            Integer obj = new Integer(maxEntries);
            Object[] params = new Object[]{obj};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        if (maxEntries > 0x40000000) {
            maxEntries = 0x40000000;
        }
        this.maxEntries = maxEntries;
        this.maxBuckets = 1;
        while (this.maxBuckets < maxEntries && this.maxBuckets < MAX_BUCKETS) {
            this.maxBuckets <<= 1;
        }
        _logger.log(Level.FINE, "EJBContainer.BaseCache about to create maxBuckets = " + this.maxBuckets + "; MAX_BUCKETS = " + MAX_BUCKETS + "; maxEntries = " + maxEntries);
        if (maxEntries != 0) {
            this.threshold = (int)((float)maxEntries * loadFactor) + 1;
        }
        this.entryCount = 0;
        this.buckets = new CacheItem[this.maxBuckets];
        this.bucketLocks = new Object[this.maxBuckets];
        this.refreshFlags = new boolean[this.maxBuckets];
        for (int i = 0; i < this.maxBuckets; ++i) {
            this.buckets[i] = null;
            this.bucketLocks[i] = new Object();
            this.refreshFlags[i] = false;
        }
    }

    public void addCacheListener(CacheListener listener) {
        this.listeners.add(listener);
    }

    protected int hash(Object x) {
        int h = x.hashCode();
        return h - (h << 7);
    }

    protected boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    protected void handleOverflow() {
        this.threshold *= 2;
        this.incrementOverflowCount();
    }

    protected CacheItem itemAdded(CacheItem item) {
        if (this.isThresholdReached()) {
            this.handleOverflow();
        }
        return null;
    }

    protected void itemAccessed(CacheItem item) {
    }

    protected void itemRefreshed(CacheItem item, int oldSize) {
    }

    protected void itemRemoved(CacheItem item) {
    }

    protected Object loadValue(Object key, int hashCode) {
        return null;
    }

    protected CacheItem createItem(int hashCode, Object key, Object value, int size) {
        return new CacheItem(hashCode, key, value, size);
    }

    protected boolean isThresholdReached() {
        return this.entryCount > this.threshold;
    }

    protected final int getIndex(int hashCode) {
        return hashCode & this.maxBuckets - 1;
    }

    public final int getIndex(Object key) {
        return this.getIndex(this.hash(key));
    }

    public Object get(Object key) {
        int hashCode = this.hash(key);
        return this.get(hashCode, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int hashCode, Object key) {
        Object value;
        int index = this.getIndex(hashCode);
        CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (!(item == null || hashCode == item.hashCode && this.eq(key, item.key))) {
                item = item.next;
            }
            if (item != null) {
                value = item.getValue();
                this.itemAccessed(item);
            } else {
                value = this.loadValue(key, hashCode);
            }
        }
        if (item != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return value;
    }

    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAll(Object key) {
        int hashCode = this.hash(key);
        int index = this.getIndex(hashCode);
        ArrayList<Object> valueList = new ArrayList<Object>(this.entryCount);
        Object object = this.bucketLocks[index];
        synchronized (object) {
            CacheItem item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && this.eq(key, item.key)) {
                    this.incrementHitCount();
                    valueList.add(item.getValue());
                }
                item = item.next;
            }
        }
        return valueList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keys() {
        ArrayList<Object> keyList = new ArrayList<Object>(this.entryCount);
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CacheItem item = this.buckets[index];
                while (item != null) {
                    keyList.add(item.key);
                    item = item.next;
                }
                continue;
            }
        }
        return keyList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        Vector<Object> keyList = new Vector<Object>();
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CacheItem item = this.buckets[index];
                while (item != null) {
                    keyList.addElement(item.value);
                    item = item.next;
                }
                continue;
            }
        }
        return keyList.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator values() {
        ArrayList<Object> valueList = new ArrayList<Object>(this.entryCount);
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CacheItem item = this.buckets[index];
                while (item != null) {
                    valueList.add(item.value);
                    item = item.next;
                }
                continue;
            }
        }
        return valueList.iterator();
    }

    public Object put(Object key, Object value) {
        int hashCode = this.hash(key);
        return this._put(hashCode, key, value, -1, false);
    }

    public Object put(Object key, Object value, int size) {
        int hashCode = this.hash(key);
        return this._put(hashCode, key, value, size, false);
    }

    public void add(Object key, Object value) {
        int hashCode = this.hash(key);
        this._put(hashCode, key, value, -1, true);
    }

    public void add(Object key, Object value, int size) {
        int hashCode = this.hash(key);
        this._put(hashCode, key, value, size, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _put(int hashCode, Object key, Object value, int size, boolean addValue) {
        Object oldValue;
        int index = this.getIndex(hashCode);
        CacheItem newItem = null;
        CacheItem oldItem = null;
        CacheItem overflow = null;
        int oldSize = 0;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            CacheItem item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && this.eq(key, item.key)) {
                    oldItem = item;
                    break;
                }
                item = item.next;
            }
            if (addValue || oldItem == null) {
                newItem = this.createItem(hashCode, key, value, size);
                newItem.next = this.buckets[index];
                this.buckets[index] = newItem;
                oldValue = null;
                overflow = this.itemAdded(newItem);
            } else {
                oldSize = oldItem.getSize();
                oldValue = oldItem.refreshValue(value, size);
                this.itemRefreshed(oldItem, oldSize);
            }
        }
        if (newItem != null) {
            this.incrementEntryCount();
            this.incrementAddCount();
            if (overflow != null) {
                this.trimItem(overflow);
            }
        } else {
            this.incrementRefreshCount();
        }
        return oldValue;
    }

    public Object remove(Object key) {
        int hashCode = this.hash(key);
        Object retVal = null;
        CacheItem removed = this._remove(hashCode, key, null);
        if (removed != null) {
            retVal = removed.getValue();
        }
        return retVal;
    }

    public Object remove(int hashCode, Object key) {
        Object retVal = null;
        CacheItem removed = this._remove(hashCode, key, null);
        if (removed != null) {
            retVal = removed.getValue();
        }
        return retVal;
    }

    public Object remove(Object key, Object value) {
        int hashCode = this.hash(key);
        Object retVal = null;
        CacheItem removed = this._remove(hashCode, key, value);
        if (removed != null) {
            retVal = removed.getValue();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheItem _remove(int hashCode, Object key, Object value) {
        int index = this.getIndex(hashCode);
        CacheItem prev = null;
        CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && key.equals(item.key) && (value == null || value == item.value)) {
                    if (prev == null) {
                        this.buckets[index] = item.next;
                    } else {
                        prev.next = item.next;
                    }
                    item.next = null;
                    this.itemRemoved(item);
                    break;
                }
                prev = item;
                item = item.next;
            }
        }
        if (item != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheItem _removeItem(CacheItem ritem) {
        int index = this.getIndex(ritem.hashCode);
        CacheItem prev = null;
        CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (item != null) {
                if (item == ritem) {
                    if (prev == null) {
                        this.buckets[index] = item.next;
                    } else {
                        prev.next = item.next;
                    }
                    item.next = null;
                    break;
                }
                prev = item;
                item = item.next;
            }
        }
        if (item != null) {
            this.decrementEntryCount();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Object key) {
        int hashCode = this.hash(key);
        int index = this.getIndex(hashCode);
        CacheItem prev = null;
        CacheItem item = null;
        ArrayList<CacheItem> items = new ArrayList<CacheItem>(this.entryCount);
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && key.equals(item.key)) {
                    if (prev == null) {
                        this.buckets[index] = item.next;
                    } else {
                        prev.next = item.next;
                    }
                    item.next = null;
                    this.decrementEntryCount();
                    this.incrementRemovalCount();
                    items.add(item);
                }
                prev = item;
                item = item.next;
            }
        }
        for (int i = 0; i < items.size(); ++i) {
            this.itemRemoved((CacheItem)items.get(i));
        }
    }

    protected void trimItem(CacheItem item) {
        CacheItem removed = this._removeItem(item);
        if (removed != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CacheListener listener = (CacheListener)this.listeners.get(i);
                listener.trimEvent(removed.key, removed.value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRefresh(int index) {
        Object object = this.bucketLocks[index];
        synchronized (object) {
            if (!this.refreshFlags[index]) {
                this.refreshFlags[index] = true;
                return false;
            }
            try {
                this.bucketLocks[index].wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRefresh(int index) {
        Object object = this.bucketLocks[index];
        synchronized (object) {
            this.refreshFlags[index] = false;
            this.bucketLocks[index].notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear() {
        CacheItem item = null;
        CacheItem next = null;
        int count = 0;
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                item = this.buckets[index];
                while (item != null) {
                    next = item.next;
                    item.next = null;
                    ++count;
                    this.decrementEntryCount();
                    this.itemRemoved(item);
                    if (this.entryCount == 0) break;
                    item = item.next;
                }
                this.buckets[index] = null;
                continue;
            }
        }
        return count;
    }

    public void trimExpiredEntries(int maxCount) {
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public boolean isEmpty() {
        return this.entryCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementEntryCount() {
        Object object = this.entryCountLk;
        synchronized (object) {
            ++this.entryCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decrementEntryCount() {
        Object object = this.entryCountLk;
        synchronized (object) {
            --this.entryCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementHitCount() {
        Object object = this.hitCountLk;
        synchronized (object) {
            ++this.hitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementMissCount() {
        Object object = this.missCountLk;
        synchronized (object) {
            ++this.missCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementRemovalCount() {
        Object object = this.removalCountLk;
        synchronized (object) {
            ++this.removalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementRefreshCount() {
        Object object = this.refreshCountLk;
        synchronized (object) {
            ++this.refreshCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementAddCount() {
        Object object = this.addCountLk;
        synchronized (object) {
            ++this.addCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementOverflowCount() {
        Object object = this.overflowCountLk;
        synchronized (object) {
            ++this.overflowCount;
        }
    }

    public Object getStatByName(String key) {
        Integer stat = null;
        if (key == null) {
            return null;
        }
        if (key.equals("cache.BaseCache.stat_maxEntries")) {
            stat = new Integer(this.maxEntries);
        } else if (key.equals("cache.BaseCache.stat_threshold")) {
            stat = new Integer(this.threshold);
        } else if (key.equals("cache.BaseCache.stat_tableSize")) {
            stat = new Integer(this.maxBuckets);
        } else if (key.equals("cache.BaseCache.stat_entryCount")) {
            stat = new Integer(this.entryCount);
        } else if (key.equals("cache.BaseCache.stat_hitCount")) {
            stat = new Integer(this.hitCount);
        } else if (key.equals("cache.BaseCache.stat_missCount")) {
            stat = new Integer(this.missCount);
        } else if (key.equals("cache.BaseCache.stat_removalCount")) {
            stat = new Integer(this.removalCount);
        } else if (key.equals("cache.BaseCache.stat_refreshCount")) {
            stat = new Integer(this.refreshCount);
        } else if (key.equals("cache.BaseCache.stat_overflowCount")) {
            stat = new Integer(this.overflowCount);
        } else if (key.equals("cache.BaseCache.stat_addCount")) {
            stat = new Integer(this.addCount);
        }
        return stat;
    }

    public Map getStats() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("cache.BaseCache.stat_maxEntries", new Integer(this.maxEntries));
        stats.put("cache.BaseCache.stat_threshold", new Integer(this.threshold));
        stats.put("cache.BaseCache.stat_tableSize", new Integer(this.maxBuckets));
        stats.put("cache.BaseCache.stat_entryCount", new Integer(this.entryCount));
        stats.put("cache.BaseCache.stat_hitCount", new Integer(this.hitCount));
        stats.put("cache.BaseCache.stat_missCount", new Integer(this.missCount));
        stats.put("cache.BaseCache.stat_removalCount", new Integer(this.removalCount));
        stats.put("cache.BaseCache.stat_refreshCount", new Integer(this.refreshCount));
        stats.put("cache.BaseCache.stat_overflowCount", new Integer(this.overflowCount));
        stats.put("cache.BaseCache.stat_addCount", new Integer(this.addCount));
        return stats;
    }

    public void clearStats() {
        this.hitCount = 0;
        this.missCount = 0;
        this.removalCount = 0;
        this.refreshCount = 0;
        this.overflowCount = 0;
        this.addCount = 0;
    }

    static {
        try {
            String maxBucketStr = System.getProperty("com.sun.ejb.containers.MAX_BUCKETS");
            if (maxBucketStr != null) {
                int maxBucketVal = Integer.parseInt(maxBucketStr);
                if (maxBucketVal > 0) {
                    MAX_BUCKETS = maxBucketVal;
                    _logger.log(Level.INFO, "EJBContainer.BaseCache will use MAX_BUCKETS = " + MAX_BUCKETS);
                } else {
                    _logger.log(Level.WARNING, "EJBContainer.BaseCache will use (default) MAX_BUCKETS = " + MAX_BUCKETS);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class CacheItem {
        int hashCode;
        Object key;
        Object value;
        int size;
        CacheItem next;

        protected CacheItem(int hashCode, Object key, Object value, int size) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
            this.size = size;
        }

        protected int getHashCode() {
            return this.hashCode;
        }

        protected Object getKey() {
            return this.key;
        }

        protected Object getValue() {
            return this.value;
        }

        protected int getSize() {
            return this.size;
        }

        protected Object refreshValue(Object value, int newSize) {
            Object oldValue = this.value;
            this.value = value;
            this.size = newSize;
            return oldValue;
        }

        public String toString() {
            return "key: " + this.key + "; value: " + this.value.toString();
        }
    }
}

