/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.MonitorTask;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="monitor")
@Scoped(value=PerLookup.class)
public class MonitorCommand
extends CLICommand {
    @Param(optional=true, defaultValue="30")
    private int interval = 30;
    @Param
    private String type;
    @Param(optional=true)
    private String filter;
    @Param(optional=true)
    private File fileName;
    @Param(primary=true, optional=true)
    private String target;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MonitorCommand.class);

    protected int executeCommand() throws CommandException, CommandValidationException {
        Timer timer = new Timer();
        try {
            MonitorTask monitorTask = new MonitorTask(timer, this.getRemoteArgs(), this.programOpts, this.env, this.type, this.filter, this.fileName);
            timer.scheduleAtFixedRate((TimerTask)monitorTask, 0L, (long)(this.interval * 1000));
            boolean done = false;
            while (!done) {
                String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (str.equals("q") || str.equals("Q")) {
                    timer.cancel();
                    done = true;
                    String exceptionMessage = monitorTask.getExceptionMessage();
                    if (exceptionMessage == null) continue;
                    throw new CommandException(exceptionMessage);
                }
                if (!str.equals("h") && !str.equals("H")) continue;
                monitorTask.displayDetails();
            }
        }
        catch (Exception e) {
            timer.cancel();
            throw new CommandException(strings.get("monitorCommand.errorRemote", e.getMessage()));
        }
        return 0;
    }

    private String[] getRemoteArgs() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("monitor");
        if (MonitorCommand.ok(this.type)) {
            list.add("--type");
            list.add(this.type);
        }
        if (MonitorCommand.ok(this.filter)) {
            list.add("--filter");
            list.add(this.filter);
        }
        return list.toArray(new String[list.size()]);
    }
}

