/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.StopLocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-local-instance")
@Scoped(value=PerLookup.class)
public class RestartLocalInstanceCommand
extends StopLocalInstanceCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private Habitat habitat;

    protected final int doRemoteCommand() throws CommandException {
        this.setLocalPassword();
        this.programOpts.setInteractive(false);
        long uptimeOldServer = this.getUptime();
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long timestamp = pwFile != null ? pwFile.lastModified() : -1L;
        RemoteCommand cmd = new RemoteCommand("_restart-instance", this.programOpts, this.env);
        if (this.debug != null) {
            cmd.executeAndReturnOutput("_restart-instance", "--debug", this.debug.toString());
        } else {
            cmd.executeAndReturnOutput("_restart-instance");
        }
        this.waitForRestart(pwFile, timestamp, uptimeOldServer);
        return 0;
    }

    protected int instanceNotRunning() throws CommandException {
        logger.warning(Strings.get("restart.instanceNotRunning"));
        CLICommand cmd = this.habitat.getComponent(CLICommand.class, "start-local-instance");
        return cmd.execute(this.argv);
    }
}

