/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.context;

import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.security.SecurityContext;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;

public class ConnectorCallbackHandler
implements CallbackHandler {
    private static final Logger logger = LogDomains.getLogger(WorkCoordinator.class, "LogStrings");
    public static final List<String> supportedCallbacks = new ArrayList<String>();
    private CallbackHandler handler;
    private boolean needMapping;
    private Map securityMap;
    private Subject executionSubject;

    public ConnectorCallbackHandler(Subject executionSubject, CallbackHandler handler, Map securityMap) {
        this.handler = handler;
        if (securityMap != null && securityMap.size() > 0) {
            this.needMapping = true;
            this.debug("translation required");
        } else {
            this.debug("no translation required");
        }
        this.executionSubject = executionSubject;
        this.securityMap = securityMap;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] mappedCallbacks = callbacks;
        if (callbacks != null) {
            ArrayList<Callback> asCallbacks = new ArrayList<Callback>();
            boolean hasCallerPrincipalCallback = this.hasCallerPrincipalCallback(callbacks);
            if (this.needMapping) {
                for (Callback callback : callbacks) {
                    boolean callbackSupported = false;
                    for (String supportedCallback : supportedCallbacks) {
                        try {
                            if (!Class.forName(supportedCallback).isAssignableFrom(callback.getClass())) continue;
                            callbackSupported = true;
                            asCallbacks.add(this.handleSupportedCallback(callback));
                        }
                        catch (ClassNotFoundException cnfe) {
                            logger.log(Level.FINEST, "class not found", cnfe);
                        }
                    }
                    if (callbackSupported) continue;
                    UnsupportedCallbackException uce = new UnsupportedCallbackException(callback);
                    Object[] params = new Object[]{callback.getClass().getName(), uce};
                    logger.log(Level.WARNING, "workcontext.unsupported_callback", params);
                    throw uce;
                }
                mappedCallbacks = new Callback[asCallbacks.size()];
                for (int i = 0; i < asCallbacks.size(); ++i) {
                    mappedCallbacks[i] = (Callback)asCallbacks.get(i);
                }
            }
            this.handler.handle(mappedCallbacks);
            this.processResults(mappedCallbacks, hasCallerPrincipalCallback);
        }
    }

    private boolean hasCallerPrincipalCallback(Callback[] callbacks) {
        if (callbacks != null) {
            for (Callback c : callbacks) {
                if (!(c instanceof CallerPrincipalCallback)) continue;
                return true;
            }
        }
        return false;
    }

    private void processResults(Callback[] mappedCallbacks, boolean hasCallerPrincipalCallback) {
        if (mappedCallbacks != null) {
            Set<Principal> principals;
            Subject s = new Subject();
            if (!hasCallerPrincipalCallback && (principals = this.executionSubject.getPrincipals()) != null && principals.size() == 1) {
                for (Principal p : principals) {
                    Principal mappedPrincipal = null;
                    mappedPrincipal = this.needMapping ? this.getMappedPrincipal(p, null) : p;
                    if (mappedPrincipal == null) continue;
                    s.getPrincipals().add(mappedPrincipal);
                }
                s.getPublicCredentials().addAll(this.executionSubject.getPublicCredentials());
                s.getPrivateCredentials().addAll(this.executionSubject.getPrivateCredentials());
            }
            for (Callback callback : mappedCallbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    s.getPrincipals().addAll(cpc.getSubject().getPrincipals());
                    s.getPublicCredentials().addAll(cpc.getSubject().getPublicCredentials());
                    s.getPrivateCredentials().addAll(cpc.getSubject().getPrivateCredentials());
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    s.getPrincipals().addAll(gpc.getSubject().getPrincipals());
                    s.getPublicCredentials().addAll(gpc.getSubject().getPublicCredentials());
                    s.getPrivateCredentials().addAll(gpc.getSubject().getPrivateCredentials());
                    continue;
                }
                if (!(callback instanceof PasswordValidationCallback)) continue;
                PasswordValidationCallback pvc = (PasswordValidationCallback)callback;
                s.getPrincipals().addAll(pvc.getSubject().getPrincipals());
                s.getPublicCredentials().addAll(pvc.getSubject().getPublicCredentials());
                s.getPrivateCredentials().addAll(pvc.getSubject().getPrivateCredentials());
            }
            SecurityContext.setCurrent(new SecurityContext(s));
        }
    }

    private Callback handleSupportedCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof CallerPrincipalCallback) {
            return this.handleCallerPrincipalCallbackWithMapping((CallerPrincipalCallback)callback);
        }
        if (callback instanceof GroupPrincipalCallback) {
            return this.handleGroupPrincipalCallbackWithMapping((GroupPrincipalCallback)callback);
        }
        throw new UnsupportedCallbackException(callback);
    }

    private Callback handleGroupPrincipalCallbackWithMapping(GroupPrincipalCallback gpc) {
        String[] groups = gpc.getGroups();
        ArrayList<String> asGroupNames = new ArrayList<String>();
        for (String groupName : groups) {
            Group mappedGroup = (Group)this.securityMap.get(new Group(groupName));
            if (mappedGroup == null) continue;
            this.debug("got mapped group as [" + groupName + "] for eis-group [" + mappedGroup.getName() + "]");
            asGroupNames.add(mappedGroup.getName());
        }
        String[] asGroupsString = new String[asGroupNames.size()];
        for (int i = 0; i < asGroupNames.size(); ++i) {
            asGroupsString[i] = (String)asGroupNames.get(i);
        }
        return new GroupPrincipalCallback(gpc.getSubject(), asGroupsString);
    }

    public Callback handleCallerPrincipalCallbackWithMapping(CallerPrincipalCallback cpc) {
        Principal eisPrincipal = cpc.getPrincipal();
        String eisName = cpc.getName();
        Principal asPrincipal = this.getMappedPrincipal(eisPrincipal, eisName);
        CallerPrincipalCallback asCPC = new CallerPrincipalCallback(cpc.getSubject(), asPrincipal);
        return asCPC;
    }

    private Principal getMappedPrincipal(Principal eisPrincipal, String eisName) {
        PrincipalImpl asPrincipal = null;
        if (eisPrincipal != null) {
            asPrincipal = (PrincipalImpl)this.securityMap.get(eisPrincipal);
            this.debug("got mapped principal as [" + asPrincipal + "] for eis-group [" + eisPrincipal.getName() + "]");
        } else if (eisName != null) {
            asPrincipal = (PrincipalImpl)this.securityMap.get(new PrincipalImpl(eisName));
            this.debug("got mapped principal as [" + asPrincipal + "] for eis-group [" + eisName + "]");
        }
        return asPrincipal;
    }

    public void debug(String message) {
        logger.finest(message);
    }

    static {
        supportedCallbacks.add(GroupPrincipalCallback.class.getName());
        supportedCallbacks.add(CallerPrincipalCallback.class.getName());
    }
}

