/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.application;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.node.runtime.application.WLModuleNode;
import com.sun.enterprise.deployment.node.runtime.common.WLSecurityRoleAssignmentNode;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.runtime.ApplicationParameter;
import com.sun.enterprise.deployment.runtime.WLModuleDescriptor;
import com.sun.enterprise.deployment.runtime.common.WLSecurityRoleAssignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLApplicationRuntimeNode
extends RuntimeBundleNode<Application> {
    public static final String SCHEMA_ID = "weblogic-application.xsd";
    private static final List<String> systemIDs = WLApplicationRuntimeNode.initSystemIDs();
    Application descriptor = null;

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return Collections.unmodifiableList(systemIDs);
    }

    public WLApplicationRuntimeNode(Application descriptor) {
        super(descriptor);
        this.descriptor = descriptor;
    }

    public WLApplicationRuntimeNode() {
        super(null);
    }

    @Override
    protected void Init() {
        super.Init();
        this.registerElementHandler(new XMLElement("application-param"), InitParamNode.class);
        this.registerElementHandler(new XMLElement("module"), WLModuleNode.class);
        this.registerElementHandler(new XMLElement("security-role-assignment"), WLSecurityRoleAssignmentNode.class);
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return new XMLElement("weblogic-application");
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Application getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EnvironmentProperty) {
            this.descriptor.addApplicationParam((ApplicationParameter)newDescriptor);
        } else if (newDescriptor instanceof WLModuleDescriptor) {
            this.descriptor.addWLModule((WLModuleDescriptor)newDescriptor);
        } else if (newDescriptor instanceof WLSecurityRoleAssignment) {
            WLSecurityRoleAssignment roleMap = (WLSecurityRoleAssignment)newDescriptor;
            if (this.descriptor != null && !this.descriptor.isVirtual()) {
                this.descriptor.addWLRoleAssignments(roleMap);
                Role role = new Role(roleMap.getRoleName());
                SecurityRoleMapper rm = this.descriptor.getRoleMapper();
                if (rm != null) {
                    if (roleMap.isExternallyDefined()) {
                        rm.assignRole(new Group(roleMap.getRoleName()), role, this.descriptor);
                    } else {
                        List<String> principals = roleMap.getPrincipalNames();
                        for (int i = 0; i < principals.size(); ++i) {
                            rm.assignRole(new PrincipalImpl(principals.get(i)), role, this.descriptor);
                        }
                    }
                }
            }
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, Application application) {
        Element root = WLApplicationRuntimeNode.appendChildNS(parent, this.getXMLRootTag().getQName(), "http://xmlns.oracle.com/weblogic/weblogic-application");
        Set<ApplicationParameter> applicationParams = application.getApplicationParams();
        if (!applicationParams.isEmpty()) {
            InitParamNode initParamNode = new InitParamNode();
            for (ApplicationParameter appParam : applicationParams) {
                initParamNode.writeDescriptor((Node)root, "application-param", (EnvironmentProperty)appParam);
            }
        }
        WLModuleNode moduleNode = new WLModuleNode();
        for (WLModuleDescriptor md : application.getWLModules()) {
            moduleNode.writeDescriptor((Node)root, "module", md);
        }
        List<WLSecurityRoleAssignment> wlRoleAssignments = application.getWlRoleAssignments();
        for (int i = 0; i < wlRoleAssignments.size(); ++i) {
            WLSecurityRoleAssignmentNode sran = new WLSecurityRoleAssignmentNode();
            sran.writeDescriptor((Node)root, "security-role-assignment", wlRoleAssignments.get(i));
        }
        return root;
    }
}

