/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.GroupManagementService;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

public class GMSMember
implements Serializable {
    private final String memberToken;
    private final String memberType;
    private long id;
    private final String groupName;
    private final Long startTime;

    public GMSMember(String memberToken, String memberType, String groupName, Long startTime) {
        this.memberToken = memberToken;
        this.memberType = memberType;
        this.groupName = groupName;
        this.startTime = startTime;
    }

    public String getMemberToken() {
        return this.memberToken;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setSnapShotId(long id) {
        this.id = id;
    }

    public long getSnapShotId() {
        return this.id;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isWatchDog() {
        return GroupManagementService.MemberType.WATCHDOG.toString().equalsIgnoreCase(this.memberType);
    }

    public boolean isCore() {
        return GroupManagementService.MemberType.CORE.toString().equalsIgnoreCase(this.memberType);
    }

    public String toString() {
        String result = MessageFormat.format("GMSMember name: {0}  group: {1} memberType: {2} startTime: {3,date} {3,time,full}", this.memberToken, this.groupName, this.memberType, new Date(this.startTime));
        return result;
    }

    public GMSMember getByMemberToken(List<GMSMember> view) {
        GMSMember result = null;
        for (GMSMember current : view) {
            if (!this.memberToken.equals(current.memberToken)) continue;
            result = current;
            break;
        }
        return result;
    }
}

