/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.web;

import com.sun.enterprise.glassfish.web.WarHandler;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.embedded.ScatteredArchive;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class ScatteredWarHandler
extends WarHandler
implements ArchiveHandler {
    private static final Logger logger = LogDomains.getLogger(ScatteredWarHandler.class, "javax.enterprise.system.tools.deployment");

    public String getArchiveType() {
        return "scattered-archive";
    }

    public boolean handles(ReadableArchive archive) {
        return archive instanceof ScatteredArchive && ((ScatteredArchive)archive).type() == ScatteredArchive.Builder.type.war;
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        ScatteredArchive archive = (ScatteredArchive)context.getSource();
        WebappClassLoader cloader = new WebappClassLoader(parent);
        try {
            FileDirContext r = new FileDirContext();
            File base = archive.getResourcesDir();
            r.setDocBase(base.getAbsolutePath());
            File sunWeb = archive.getFile("WEB-INF/sun-web.xml");
            WarHandler.SunWebXmlParser sunWebXmlParser = null;
            if (sunWeb != null && sunWeb.exists()) {
                sunWebXmlParser = new WarHandler.SunWebXmlParser(this, sunWeb.getParentFile().getParent());
            }
            cloader.setResources(r);
            for (URL url : archive.getClassPath()) {
                cloader.addRepository(url.toExternalForm());
            }
            if (context.getScratchDir("jsp") != null) {
                cloader.setWorkDir(context.getScratchDir("jsp"));
            }
            if (sunWebXmlParser != null) {
                this.configureLoaderAttributes(cloader, sunWebXmlParser, base);
                this.configureLoaderProperties(cloader, sunWebXmlParser, base);
            }
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, xse.getMessage());
            logger.log(Level.FINE, xse.getMessage(), xse);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, fnfe.getMessage());
            logger.log(Level.FINE, fnfe.getMessage(), fnfe);
        }
        try {
            cloader.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cloader;
    }
}

