/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.server.logging.BooleanLatch;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.LogRotationTimerTask;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.glassfish.api.logging.Task;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
@ContractProvided(value=Handler.class)
public class GFFileHandler
extends StreamHandler
implements PostConstruct,
PreDestroy {
    @Inject
    ServerContext serverContext;
    @Inject
    ServerEnvironmentImpl env;
    @Inject(optional=true)
    Agent agent;
    @Inject
    Version version;
    private MeteredStream meter;
    private static final String LOGS_DIR = "logs";
    private String logFileName = "server.log";
    private String absoluteServerLogName = null;
    private File absoluteFile = null;
    private int flushFrequency = 1;
    private int maxHistoryFiles = 10;
    private static final int MINIMUM_FILE_ROTATION_VALUE = 500000;
    private int limitForFileRotation = 0;
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private AtomicBoolean rotationRequested = new AtomicBoolean(false);
    private static final String LOG_ROTATE_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    private static final SimpleDateFormat logRotateDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
    private BooleanLatch done = new BooleanLatch();
    private Thread pump;
    private static final int MAX_RECENT_ERRORS = 4;

    public void postConstruct() {
        String formatterName;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String filename = TranslatedConfigView.getTranslatedValue(manager.getProperty(cname + ".file")).toString();
        File serverLog = new File(filename);
        this.absoluteServerLogName = filename;
        if (!serverLog.isAbsolute()) {
            serverLog = new File(this.env.getDomainRoot(), filename);
            this.absoluteServerLogName = this.env.getDomainRoot() + File.separator + filename;
        }
        this.changeFileName(serverLog);
        this.pump = new Thread(){

            public void run() {
                try {
                    while (!GFFileHandler.this.done.isSignalled()) {
                        GFFileHandler.this.log();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.pump.start();
        GFFileHandler gFFileHandler = this;
        LogRecord lr = new LogRecord(Level.INFO, "Running GlassFish Version: " + gFFileHandler.version.getFullVersion());
        lr.setThreadID((int)Thread.currentThread().getId());
        this.publish(lr);
        Long rotationTimeLimitValue = 0L;
        try {
            rotationTimeLimitValue = Long.parseLong(manager.getProperty(cname + ".rotationTimelimitInMinutes"));
        }
        catch (NumberFormatException e) {
            lr = new LogRecord(Level.SEVERE, "Cannot read rotationTimelimitInMinutes property from logging config file");
            lr.setThreadID((int)Thread.currentThread().getId());
            this.publish(lr);
        }
        if (rotationTimeLimitValue != 0L) {
            Task rotationTask = new Task(){

                public Object run() {
                    GFFileHandler.this.rotate();
                    return null;
                }
            };
            LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, rotationTimeLimitValue));
            this.setLimitForRotation(0);
        } else {
            Integer rotationLimitAttrValue = 0;
            try {
                rotationLimitAttrValue = Integer.parseInt(manager.getProperty(cname + ".rotationLimitInBytes"));
            }
            catch (NumberFormatException e) {
                lr = new LogRecord(Level.WARNING, "Cannot read rotationLimitInBytes property from logging config file. Using default.");
                lr.setThreadID((int)Thread.currentThread().getId());
                this.publish(lr);
            }
            this.setLimitForRotation(rotationLimitAttrValue);
        }
        this.setLevel(Level.ALL);
        String ff = manager.getProperty(cname + ".flushFrequency");
        if (ff != null) {
            try {
                this.flushFrequency = Integer.parseInt(manager.getProperty(cname + ".flushFrequency"));
            }
            catch (NumberFormatException e) {
                lr = new LogRecord(Level.WARNING, "Cannot read flushFrequency property from logging config file. Using default.");
                lr.setThreadID((int)Thread.currentThread().getId());
                this.publish(lr);
            }
        }
        if (this.flushFrequency <= 0) {
            this.flushFrequency = 1;
        }
        if ((formatterName = manager.getProperty(cname + ".formatter")) == null || UniformLogFormatter.class.getName().equals(formatterName)) {
            if (this.agent != null) {
                this.setFormatter(new UniformLogFormatter(new AgentFormatterDelegate(this.agent)));
            } else {
                this.setFormatter(new UniformLogFormatter());
            }
        } else {
            try {
                this.setFormatter((Formatter)this.getClass().getClassLoader().loadClass(formatterName).newInstance());
            }
            catch (InstantiationException e) {
                lr = new LogRecord(Level.SEVERE, "Cannot instantiate formatter class " + formatterName);
                lr.setThreadID((int)Thread.currentThread().getId());
                this.publish(lr);
            }
            catch (IllegalAccessException e) {
                lr = new LogRecord(Level.SEVERE, "Cannot instantiate formatter class " + formatterName);
                lr.setThreadID((int)Thread.currentThread().getId());
                this.publish(lr);
            }
            catch (ClassNotFoundException e) {
                lr = new LogRecord(Level.SEVERE, "Cannot load formatter class " + formatterName);
                lr.setThreadID((int)Thread.currentThread().getId());
                this.publish(lr);
            }
        }
        try {
            this.maxHistoryFiles = Integer.parseInt(manager.getProperty(cname + ".maxHistoryFiles"));
        }
        catch (NumberFormatException e) {
            lr = new LogRecord(Level.WARNING, "Cannot read maxHistoryFiles property from logging config file. Using default.");
            lr.setThreadID((int)Thread.currentThread().getId());
            this.publish(lr);
        }
        if (this.maxHistoryFiles < 0) {
            this.maxHistoryFiles = 10;
        }
    }

    public void preDestroy() {
        LogDomains.getLogger(ServerEnvironmentImpl.class, "javax.enterprise.system.tools.admin").fine("Logger handler killed");
        this.done.tryReleaseShared(1);
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                super.publish(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeFileName(File file) {
        if (file.equals(this.absoluteFile)) {
            return;
        }
        GFFileHandler gFFileHandler = this;
        synchronized (gFFileHandler) {
            super.flush();
            super.close();
            try {
                this.openFile(file);
                this.absoluteFile = file;
            }
            catch (IOException ix) {
                new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE. Please Check to make sure that the directory for Logfile exists. Currently reverting back to use the  default server.log", ix, 4);
                try {
                    this.openFile(this.absoluteFile);
                }
                catch (Exception e) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT RE-OPEN SERVER LOG FILE. ", e, 4);
                }
            }
        }
    }

    public File getCurrentLogFile() {
        return this.absoluteFile;
    }

    synchronized void setLimitForRotation(int rotationLimitInBytes) {
        this.limitForFileRotation = rotationLimitInBytes;
    }

    private void openFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, file.length());
        this.setOutputStream(this.meter);
    }

    void requestRotation() {
        this.rotationRequested.set(true);
    }

    public void cleanUpHistoryLogFiles() {
        if (this.maxHistoryFiles == 0) {
            return;
        }
        File dir = this.absoluteFile.getParentFile();
        if (dir == null) {
            return;
        }
        File[] fset = dir.listFiles();
        ArrayList<String> candidates = new ArrayList<String>();
        for (int i = 0; fset != null && i < fset.length; ++i) {
            if (this.logFileName.equals(fset[i].getName()) || !fset[i].isFile() || !fset[i].getName().startsWith(this.logFileName)) continue;
            candidates.add(fset[i].getAbsolutePath());
        }
        if (candidates.size() <= this.maxHistoryFiles) {
            return;
        }
        Object[] pathes = candidates.toArray();
        Arrays.sort(pathes);
        try {
            for (int i = 0; i < pathes.length - this.maxHistoryFiles; ++i) {
                new File((String)pathes[i]).delete();
            }
        }
        catch (Exception e) {
            new ErrorManager().error("FATAL ERROR: COULD NOT DELETE LOG FILE..", e, 0);
        }
    }

    public void rotate() {
        final GFFileHandler thisInstance = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thisInstance.flush();
                thisInstance.close();
                try {
                    File oldFile = GFFileHandler.this.absoluteFile;
                    StringBuffer renamedFileName = new StringBuffer(GFFileHandler.this.absoluteFile + "_");
                    logRotateDateFormatter.format(new Date(), renamedFileName, new FieldPosition(0));
                    File rotatedFile = new File(renamedFileName.toString());
                    boolean renameSuccess = oldFile.renameTo(rotatedFile);
                    if (!renameSuccess) {
                        FileUtils.copy(GFFileHandler.this.absoluteFile, rotatedFile);
                        File freshServerLogFile = GFFileHandler.this.getLogFileName();
                        FileOutputStream fo = new FileOutputStream(freshServerLogFile);
                        fo.close();
                    }
                    GFFileHandler.this.openFile(GFFileHandler.this.getLogFileName());
                    GFFileHandler.this.absoluteFile = GFFileHandler.this.getLogFileName();
                    LogRotationTimer.getInstance().restartTimer();
                    GFFileHandler.this.cleanUpHistoryLogFiles();
                }
                catch (IOException ix) {
                    GFFileHandler.this.publish(new LogRecord(Level.SEVERE, "Error, could not rotate log : " + ix.getMessage()));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        try {
            LogRecord record = this.pendingRecords.take();
            super.publish(record);
        }
        catch (InterruptedException e) {
            return;
        }
        Vector v = new Vector();
        int msgs = this.pendingRecords.drainTo(v, this.flushFrequency);
        for (int j = 0; j < msgs; ++j) {
            super.publish((LogRecord)v.get(j));
        }
        this.flush();
        if (this.rotationRequested.get() || this.limitForFileRotation > 0 && this.meter.written >= (long)this.limitForFileRotation) {
            AtomicBoolean atomicBoolean = this.rotationRequested;
            synchronized (atomicBoolean) {
                this.rotate();
                this.rotationRequested.set(false);
            }
        }
    }

    public void publish(LogRecord record) {
        if (this.done.isSignalled()) {
            return;
        }
        try {
            this.pendingRecords.add(record);
        }
        catch (IllegalStateException e) {
            try {
                this.pendingRecords.put(record);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected File getLogFileName() {
        return new File(this.absoluteServerLogName);
    }

    private final class MeteredStream
    extends OutputStream {
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

