/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-node-ssh")
@I18n(value="create.node.ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class CreateNodeSshCommand
implements AdminCommand {
    private static final int DEFAULT_TIMEOUT_MSEC = 300000;
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost")
    private String nodehost;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="sshport", optional=true, defaultValue="22")
    private String sshport;
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String sshuser;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;
    @Param(name="sshpassword", optional=true, password=true)
    private String sshpassword;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    private String sshkeypassphrase;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Param(optional=true, defaultValue="false")
    boolean install;
    @Param(optional=true)
    String archive;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        this.logger = context.getLogger();
        this.checkDefaults();
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.name);
        map.add("installdir", this.installdir);
        map.add("nodehost", this.nodehost);
        map.add("nodedir", this.nodedir);
        map.add("sshport", this.sshport);
        map.add("sshuser", this.sshuser);
        map.add("sshkeyfile", this.sshkeyfile);
        map.add("sshpassword", this.sshpassword);
        map.add("sshkeypassphrase", this.sshkeypassphrase);
        map.add("type", "SSH");
        map.add("install", Boolean.toString(this.install));
        try {
            boolean s;
            NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
            nodeUtils.validate(map);
            if (this.install && !(s = this.installNode(context, nodeUtils.sshL)) && !this.force) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("node.ssh.invalid.params");
            if (!this.force) {
                String m2 = Strings.get("create.node.ssh.not.created");
                msg.append(StringUtils.cat(NL, m1, m2, e.getMessage()));
                report.setMessage(msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String m2 = Strings.get("create.node.ssh.continue.force");
            msg.append(StringUtils.cat(NL, m1, e.getMessage(), m2));
        }
        map.remove("install");
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_create-node", report);
        ci.parameters(map);
        ci.execute();
        NodeUtils.sanitizeReport(report);
        if (StringUtils.ok(report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private boolean installNode(AdminCommandContext ctx, SSHLauncher launcher) throws CommandValidationException {
        File ar;
        boolean res = false;
        ArrayList<String> command = new ArrayList<String>();
        command.add("install-node");
        command.add("--installdir");
        command.add(this.installdir);
        if (this.force) {
            command.add("--force");
        }
        if (this.archive != null && (ar = new File(this.archive)).exists() && ar.canRead()) {
            command.add("--archive");
            command.add(this.archive);
        }
        command.add("--sshuser");
        command.add(this.sshuser);
        command.add("--sshport");
        command.add(this.sshport);
        if (this.sshkeyfile == null) {
            this.sshkeyfile = SSHUtil.getExistingKeyFile();
        }
        if (this.sshkeyfile != null) {
            command.add("--sshkeyfile");
            command.add(this.sshkeyfile);
        }
        command.add(this.nodehost);
        String firstErrorMessage = Strings.get("create.node.ssh.install.failed", this.nodehost);
        StringBuilder out = new StringBuilder();
        int exitCode = this.execCommand(command, launcher, out);
        ActionReport report = ctx.getActionReport();
        if (exitCode == 0) {
            String msg = Strings.get("create.node.ssh.install.success", this.nodehost);
            report.setMessage(msg);
            res = true;
        } else {
            report.setMessage(firstErrorMessage);
        }
        return res;
    }

    void checkDefaults() {
        if (!StringUtils.ok(this.installdir)) {
            this.installdir = "${com.sun.aas.productRoot}";
        }
        if (!StringUtils.ok(this.sshport)) {
            this.sshport = "22";
        }
        if (!StringUtils.ok(this.sshuser)) {
            this.sshuser = "${user.name}";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execCommand(List<String> cmdLine, SSHLauncher launcher, StringBuilder output) {
        int exit = -1;
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = this.nodes.getDefaultLocalNode().getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok(installDir)) {
            throw new IllegalArgumentException(Strings.get("create.node.ssh.no.installdir"));
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation(installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        BufferedWriter out = null;
        File f = null;
        if (this.sshpassword != null) {
            try {
                f = new File(System.getProperty("java.io.tmpdir"), "pass.tmp");
                out = new BufferedWriter(new FileWriter(f));
                out.newLine();
                out.write("AS_ADMIN_SSHPASSWORD=" + launcher.expandPasswordAlias(this.sshpassword) + "\n");
                if (this.sshkeypassphrase != null) {
                    out.write("AS_ADMIN_SSHKEYPASSPHRASE=" + launcher.expandPasswordAlias(this.sshkeypassphrase) + "\n");
                }
            }
            catch (IOException ioe) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Failed to create the temporary password file: " + ioe.getMessage());
                }
                output.append(Strings.get("create.node.ssh.passfile.error"));
                int n = 1;
                return n;
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                    }
                    out.close();
                }
                catch (Exception ignore) {}
            }
            fullcommand.add("--passwordfile");
            fullcommand.add(f.getAbsolutePath());
        }
        fullcommand.add("--interactive=false");
        fullcommand.addAll(cmdLine);
        ProcessManager pm = new ProcessManager(fullcommand);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Running command on DAS: " + this.commandListToString(fullcommand));
        }
        pm.setTimeoutMsec(300000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing command: " + ex.getMessage());
            }
            exit = 1;
        }
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok(stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok(stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        if (f != null) {
            f.delete();
        }
        return exit;
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

