/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.listener;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SystemPropertyListener
implements ConfigListener,
PostConstruct {
    Logger logger = LogDomains.getLogger(SystemPropertyListener.class, "javax.enterprise.system.tools.admin");
    @Inject
    private volatile Domain domain;
    @Inject(name="default-instance-name")
    private Server server;

    @Override
    public void postConstruct() {
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
                if (changedType == SystemProperty.class && type2 == Changed.TYPE.ADD) {
                    SystemProperty sp = (SystemProperty)changedInstance;
                    ConfigBeanProxy proxy = sp.getParent();
                    if (proxy instanceof Domain) {
                        return SystemPropertyListener.this.addToDomain(sp);
                    }
                    if (proxy instanceof Config) {
                        return SystemPropertyListener.this.addToConfig(sp);
                    }
                    if (proxy instanceof Cluster) {
                        return SystemPropertyListener.this.addToCluster(sp);
                    }
                    return SystemPropertyListener.this.addToServer(sp);
                }
                if (changedType == SystemProperty.class && type2 == Changed.TYPE.REMOVE) {
                    SystemProperty sp = (SystemProperty)changedInstance;
                    ConfigBeanProxy proxy = sp.getParent();
                    if (proxy instanceof Domain) {
                        return SystemPropertyListener.this.removeFromDomain(sp);
                    }
                    if (proxy instanceof Config) {
                        return SystemPropertyListener.this.removeFromConfig(sp);
                    }
                    if (proxy instanceof Cluster) {
                        return SystemPropertyListener.this.removeFromCluster(sp);
                    }
                    return SystemPropertyListener.this.removeFromServer(sp);
                }
                if (changedType == SystemProperty.class && type2 == Changed.TYPE.CHANGE) {
                    SystemProperty sp = (SystemProperty)changedInstance;
                    ConfigBeanProxy proxy = sp.getParent();
                    if (proxy instanceof Domain) {
                        return SystemPropertyListener.this.addToDomain(sp);
                    }
                    if (proxy instanceof Config) {
                        return SystemPropertyListener.this.addToConfig(sp);
                    }
                    if (proxy instanceof Cluster) {
                        return SystemPropertyListener.this.addToCluster(sp);
                    }
                    return SystemPropertyListener.this.addToServer(sp);
                }
                return null;
            }
        }, this.logger);
    }

    private NotProcessed removeFromServer(SystemProperty sp) {
        SystemProperty sysProp = this.getClusterSystemProperty(sp.getName());
        if (sysProp == null) {
            sysProp = this.getConfigSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            sysProp = this.getDomainSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            System.clearProperty(sp.getName());
        } else {
            System.setProperty(sysProp.getName(), sysProp.getValue());
        }
        return null;
    }

    private NotProcessed removeFromCluster(SystemProperty sp) {
        SystemProperty sysProp = this.getConfigSystemProperty(sp.getName());
        if (sysProp == null) {
            sysProp = this.getDomainSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            if (!this.serverHas(sp)) {
                System.clearProperty(sp.getName());
            }
        } else if (!this.serverHas(sp)) {
            System.setProperty(sysProp.getName(), sysProp.getValue());
        }
        return null;
    }

    private NotProcessed removeFromConfig(SystemProperty sp) {
        SystemProperty sysProp = this.getDomainSystemProperty(sp.getName());
        if (sysProp == null) {
            if (!this.serverHas(sp) && !this.clusterHas(sp)) {
                System.clearProperty(sp.getName());
            }
        } else if (!this.serverHas(sp) && !this.clusterHas(sp)) {
            System.setProperty(sysProp.getName(), sysProp.getValue());
        }
        return null;
    }

    private NotProcessed removeFromDomain(SystemProperty sp) {
        if (!(this.serverHas(sp) || this.clusterHas(sp) || this.configHas(sp))) {
            System.clearProperty(sp.getName());
        }
        return null;
    }

    private NotProcessed addToServer(SystemProperty sp) {
        System.setProperty(sp.getName(), sp.getValue());
        return null;
    }

    private NotProcessed addToCluster(SystemProperty sp) {
        if (!this.serverHas(sp)) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private NotProcessed addToConfig(SystemProperty sp) {
        if (!this.serverHas(sp) && !this.clusterHas(sp)) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private NotProcessed addToDomain(SystemProperty sp) {
        if (!(this.serverHas(sp) || this.clusterHas(sp) || this.configHas(sp))) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private boolean serverHas(SystemProperty sp) {
        List<SystemProperty> ssps = this.server.getSystemProperty();
        return this.hasSystemProperty(ssps, sp);
    }

    private boolean configHas(SystemProperty sp) {
        Config c = this.domain.getConfigNamed(this.server.getConfigRef());
        List<SystemProperty> ssps = c.getSystemProperty();
        return this.hasSystemProperty(ssps, sp);
    }

    private boolean clusterHas(SystemProperty sp) {
        Cluster c = this.domain.getClusterForInstance(this.server.getName());
        if (c != null) {
            List<SystemProperty> ssps = c.getSystemProperty();
            return this.hasSystemProperty(ssps, sp);
        }
        return false;
    }

    private SystemProperty getClusterSystemProperty(String spName) {
        List<SystemProperty> ssps;
        Cluster c = this.domain.getClusterForInstance(this.server.getName());
        if (c != null && (ssps = c.getSystemProperty()) != null) {
            for (SystemProperty sp : ssps) {
                if (!sp.getName().equals(spName)) continue;
                return sp;
            }
        }
        return null;
    }

    private SystemProperty getConfigSystemProperty(String spName) {
        List<SystemProperty> ssps;
        Config c = this.domain.getConfigNamed(this.server.getConfigRef());
        if (c != null && (ssps = c.getSystemProperty()) != null) {
            for (SystemProperty sp : ssps) {
                if (!sp.getName().equals(spName)) continue;
                return sp;
            }
        }
        return null;
    }

    private SystemProperty getDomainSystemProperty(String spName) {
        List<SystemProperty> ssps = this.domain.getSystemProperty();
        if (ssps != null) {
            for (SystemProperty sp : ssps) {
                if (!sp.getName().equals(spName)) continue;
                return sp;
            }
        }
        return null;
    }

    private boolean hasSystemProperty(List<SystemProperty> ssps, SystemProperty sp) {
        if (ssps != null) {
            for (SystemProperty candidate : ssps) {
                if (!candidate.getName().equals(sp.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

