/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.StatsProvider;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.util.ThreadPoolConfig;
import com.sun.grizzly.util.ThreadPoolMonitoringProbe;
import java.util.Queue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MonitorableThreadPool
extends StatsThreadPool {
    public MonitorableThreadPool(GrizzlyMonitoring monitoring, String monitoringId, String threadPoolName, int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(new GrizzlyIntegrationThreadPoolConfig(monitoringId, monitoring, threadPoolName, corePoolSize, maximumPoolSize, null, maxTasksCount, keepAliveTime, unit, null, 5));
        if (monitoring != null) {
            StatsProvider statsProvider = monitoring.getThreadPoolStatsProvider(monitoringId);
            if (statsProvider != null) {
                statsProvider.setStatsObject(this);
            }
            if ((statsProvider = monitoring.getConnectionQueueStatsProvider(monitoringId)) != null) {
                statsProvider.setStatsObject(this);
            }
            ThreadPoolConfig config = this.getConfiguration();
            config.setCorePoolSize(config.getCorePoolSize());
            config.setMaxPoolSize(config.getMaxPoolSize());
            config.setQueueLimit(config.getQueueLimit());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrizzlyIntegrationThreadPoolConfig
    extends ThreadPoolConfig {
        private final String monitoringId;
        private final GrizzlyMonitoring monitoring;

        public GrizzlyIntegrationThreadPoolConfig(String monitoringId, GrizzlyMonitoring monitoring, String poolName, int corePoolSize, int maxPoolSize, Queue<Runnable> queue, int queueLimit, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, int priority) {
            super(poolName, corePoolSize, maxPoolSize, queue, queueLimit, keepAliveTime, timeUnit, threadFactory, priority, null);
            super.setMonitoringProbe(new GrizzlyIntegrationThreadPoolMonitoringProbe());
            this.monitoringId = monitoringId;
            this.monitoring = monitoring;
        }

        @Override
        public ThreadPoolConfig setCorePoolSize(int corePoolSize) {
            if (this.monitoring != null) {
                this.monitoring.getThreadPoolProbeProvider().setCoreThreadsEvent(this.monitoringId, this.getPoolName(), corePoolSize);
            }
            return super.setCorePoolSize(corePoolSize);
        }

        @Override
        public ThreadPoolConfig setMaxPoolSize(int maxPoolSize) {
            if (this.monitoring != null) {
                this.monitoring.getThreadPoolProbeProvider().setMaxThreadsEvent(this.monitoringId, this.getPoolName(), maxPoolSize);
            }
            return super.setMaxPoolSize(maxPoolSize);
        }

        @Override
        public ThreadPoolConfig setQueueLimit(int limit) {
            if (this.monitoring != null) {
                this.monitoring.getConnectionQueueProbeProvider().setMaxTaskQueueSizeEvent(this.monitoringId, limit);
            }
            return super.setQueueLimit(limit);
        }

        private class GrizzlyIntegrationThreadPoolMonitoringProbe
        implements ThreadPoolMonitoringProbe {
            private GrizzlyIntegrationThreadPoolMonitoringProbe() {
            }

            public void threadAllocatedEvent(String threadPoolName, Thread thread) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getThreadPoolProbeProvider().threadAllocatedEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, threadPoolName, thread.getName());
                }
            }

            public void threadReleasedEvent(String threadPoolName, Thread thread) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getThreadPoolProbeProvider().threadReleasedEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, threadPoolName, thread.getName());
                }
            }

            public void maxNumberOfThreadsReachedEvent(String threadPoolName, int maxNumberOfThreads) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getThreadPoolProbeProvider().maxNumberOfThreadsReachedEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, threadPoolName, maxNumberOfThreads);
                }
            }

            public void onTaskQueuedEvent(Runnable runnable) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getConnectionQueueProbeProvider().onTaskQueuedEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, String.valueOf(runnable.hashCode()));
                }
            }

            public void onTaskDequeuedEvent(Runnable runnable) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getConnectionQueueProbeProvider().onTaskDequeuedEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, String.valueOf(runnable.hashCode()));
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, GrizzlyIntegrationThreadPoolConfig.this.getPoolName(), Thread.currentThread().getName());
                }
            }

            public void onTaskQueueOverflowEvent(String threadPoolName) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getConnectionQueueProbeProvider().onTaskQueueOverflowEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId);
                }
            }

            public void onTaskCompletedEvent(Runnable runnable) {
                if (GrizzlyIntegrationThreadPoolConfig.this.monitoring != null) {
                    GrizzlyIntegrationThreadPoolConfig.this.monitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(GrizzlyIntegrationThreadPoolConfig.this.monitoringId, GrizzlyIntegrationThreadPoolConfig.this.getPoolName(), Thread.currentThread().getName());
                }
            }
        }
    }
}

